"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 *
 * @stability stable
 */
class Probe {
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit.
     * @param options Options.
     * @stability stable
     */
    static fromHttpGet(path, options = {}) {
        return {
            _toKube(container) {
                var _b, _c;
                return {
                    ...parseProbeOptions(options),
                    httpGet: {
                        path,
                        port: (_c = (_b = options.port) !== null && _b !== void 0 ? _b : container.port) !== null && _c !== void 0 ? _c : 80,
                    },
                };
            },
        };
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute.
     * @param options Options.
     * @stability stable
     */
    static fromCommand(command, options = {}) {
        return {
            _toKube: _ => ({
                ...parseProbeOptions(options),
                exec: { command },
            }),
        };
    }
}
exports.Probe = Probe;
_a = JSII_RTTI_SYMBOL_1;
Probe[_a] = { fqn: "cdk8s-plus-17.Probe", version: "1.0.0-beta.45" };
function parseProbeOptions(options = {}) {
    var _b;
    return {
        failureThreshold: (_b = options.failureThreshold) !== null && _b !== void 0 ? _b : 3,
        initialDelaySeconds: options.initialDelaySeconds ? options.initialDelaySeconds.toSeconds() : undefined,
        periodSeconds: options.periodSeconds ? options.periodSeconds.toSeconds() : undefined,
        successThreshold: options.successThreshold,
        timeoutSeconds: options.timeoutSeconds ? options.timeoutSeconds.toSeconds() : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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