/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.EndOfStoreException;
import org.openstreetmap.osmosis.core.store.StoreReader;

public class DataInputStoreReader
implements StoreReader {
    private DataInput input;

    public DataInputStoreReader(DataInput input) {
        this.input = input;
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.input.readBoolean();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a boolean from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a boolean from the store.", e);
        }
    }

    @Override
    public byte readByte() {
        try {
            return this.input.readByte();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a byte from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a byte from the store.", e);
        }
    }

    @Override
    public char readCharacter() {
        try {
            return this.input.readChar();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a character from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a character from the store.", e);
        }
    }

    @Override
    public int readInteger() {
        try {
            return this.input.readInt();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read an integer from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read an integer from the store.", e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.input.readLong();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a long from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a long from the store.", e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.input.readDouble();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a double from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a double from the store.", e);
        }
    }

    @Override
    public String readString() {
        try {
            return this.input.readUTF();
        }
        catch (EOFException e) {
            throw new EndOfStoreException("End of stream was reached while attempting to read a String from the store.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read a String from the store.", e);
        }
    }
}

