/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;

public class FileBasedLock
implements Closeable {
    private static final Logger LOG = Logger.getLogger(FileBasedLock.class.getName());
    private File lockFile;
    private FileOutputStream outputStream;
    private FileChannel fileChannel;
    private FileLock fileLock;
    private boolean initialized;

    public FileBasedLock(File lockFile) {
        this.lockFile = lockFile;
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            try {
                this.outputStream = new FileOutputStream(this.lockFile);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open lock file " + this.lockFile + ".");
            }
            this.fileChannel = this.outputStream.getChannel();
            this.initialized = true;
        }
    }

    public void lock() {
        this.initialize();
        if (this.fileLock != null) {
            throw new OsmosisRuntimeException("A lock has already been obtained on file " + this.lockFile + ".");
        }
        try {
            this.fileLock = this.fileChannel.tryLock();
            if (this.fileLock == null) {
                throw new OsmosisRuntimeException("A exclusive lock already exists on file " + this.lockFile + ".");
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("An error occurred while trying to obtain an exclusive lock on file " + this.lockFile + ".");
        }
    }

    public void unlock() {
        this.initialize();
        try {
            this.fileLock.release();
            this.fileLock = null;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to release lock on file " + this.lockFile + ".");
        }
    }

    @Override
    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                LOG.warning("Unable to close lock stream on file " + this.lockFile + ".");
            }
            finally {
                this.outputStream = null;
                this.fileChannel = null;
                this.fileLock = null;
                this.initialized = false;
            }
        }
    }
}

