/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.CopyFileset;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.IndexManager;

public class CopyFilesetLoader
implements Runnable {
    private static final Logger LOG = Logger.getLogger(CopyFilesetLoader.class.getName());
    private static final String[] COMMON_COLUMNS = new String[]{"id", "version", "user_id", "tstamp", "changeset_id", "tags"};
    private static final String[] NODE_COLUMNS = CopyFilesetLoader.appendColumn(COMMON_COLUMNS, "geom");
    private static final String[] WAY_COLUMNS = CopyFilesetLoader.appendColumn(COMMON_COLUMNS, "nodes");
    private static final String[] RELATION_COLUMNS = COMMON_COLUMNS;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private CopyFileset copyFileset;

    private static String[] appendColumn(String[] columns, String newColumn) {
        String[] result = new String[columns.length + 1];
        System.arraycopy(columns, 0, result, 0, columns.length);
        result[columns.length] = newColumn;
        return result;
    }

    public CopyFilesetLoader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, CopyFileset copyFileset) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.copyFileset = copyFileset;
    }

    @Override
    public void run() {
        try (DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);){
            dbCtx.beginTransaction();
            DatabaseCapabilityChecker capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
            new SchemaVersionValidator(dbCtx.getJdbcTemplate(), this.preferences).validateVersion(6);
            String[] wayColumns = WAY_COLUMNS;
            if (capabilityChecker.isWayBboxSupported()) {
                wayColumns = CopyFilesetLoader.appendColumn(wayColumns, "bbox");
            }
            if (capabilityChecker.isWayLinestringSupported()) {
                wayColumns = CopyFilesetLoader.appendColumn(wayColumns, "linestring");
            }
            IndexManager indexManager = new IndexManager(dbCtx, false, false);
            indexManager.prepareForLoad();
            LOG.finer("Loading users.");
            dbCtx.loadCopyFile(this.copyFileset.getUserFile(), "users", new String[0]);
            LOG.finer("Loading nodes.");
            dbCtx.loadCopyFile(this.copyFileset.getNodeFile(), "nodes", NODE_COLUMNS);
            LOG.finer("Loading ways.");
            dbCtx.loadCopyFile(this.copyFileset.getWayFile(), "ways", wayColumns);
            LOG.finer("Loading way nodes.");
            dbCtx.loadCopyFile(this.copyFileset.getWayNodeFile(), "way_nodes", new String[0]);
            LOG.finer("Loading relations.");
            dbCtx.loadCopyFile(this.copyFileset.getRelationFile(), "relations", RELATION_COLUMNS);
            LOG.finer("Loading relation members.");
            dbCtx.loadCopyFile(this.copyFileset.getRelationMemberFile(), "relation_members", new String[0]);
            LOG.finer("Committing changes.");
            LOG.fine("Data load complete.");
            indexManager.completeAfterLoad();
            dbCtx.commitTransaction();
            LOG.fine("Clustering database.");
            dbCtx.getJdbcTemplate().update("CLUSTER");
            LOG.fine("Vacuuming database.");
            dbCtx.getJdbcTemplate().update("VACUUM ANALYZE");
            LOG.fine("Complete.");
        }
    }
}

