/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.Collections;
import java.util.Comparator;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.change.v0_6.impl.TimestampSetter;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.MultiSinkRunnableChangeSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxSink;

public class ChangeDeriver
implements MultiSinkRunnableChangeSource {
    private ChangeSink changeSink;
    private DataPostbox<EntityContainer> fromPostbox;
    private DataPostboxSink fromSink;
    private DataPostbox<EntityContainer> toPostbox;
    private DataPostboxSink toSink;

    public ChangeDeriver(int inputBufferCapacity) {
        this.fromPostbox = new DataPostbox(inputBufferCapacity);
        this.fromSink = new DataPostboxSink(this.fromPostbox);
        this.toPostbox = new DataPostbox(inputBufferCapacity);
        this.toSink = new DataPostboxSink(this.toPostbox);
    }

    public Sink getSink(int instance) {
        switch (instance) {
            case 0: {
                return this.fromSink;
            }
            case 1: {
                return this.toSink;
            }
        }
        throw new OsmosisRuntimeException("Sink instance " + instance + " is not valid.");
    }

    public int getSinkCount() {
        return 2;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            EntityContainer fromEntityContainer = null;
            EntityContainer toEntityContainer = null;
            EntityContainerComparator comparator = new EntityContainerComparator((Comparator)new EntityByTypeThenIdComparator());
            TimestampSetter timestampSetter = new TimestampSetter();
            this.fromPostbox.outputInitialize();
            this.toPostbox.outputInitialize();
            this.changeSink.initialize(Collections.emptyMap());
            while ((fromEntityContainer != null || this.fromPostbox.hasNext()) && (toEntityContainer != null || this.toPostbox.hasNext())) {
                int comparisonResult;
                if (fromEntityContainer == null) {
                    fromEntityContainer = (EntityContainer)this.fromPostbox.getNext();
                }
                if (toEntityContainer == null) {
                    toEntityContainer = (EntityContainer)this.toPostbox.getNext();
                }
                if ((comparisonResult = comparator.compare(fromEntityContainer, toEntityContainer)) < 0) {
                    this.changeSink.process(new ChangeContainer(timestampSetter.updateTimestamp(fromEntityContainer), ChangeAction.Delete));
                    fromEntityContainer = null;
                    continue;
                }
                if (comparisonResult > 0) {
                    this.changeSink.process(new ChangeContainer(toEntityContainer, ChangeAction.Create));
                    toEntityContainer = null;
                    continue;
                }
                if (!fromEntityContainer.getEntity().equals(toEntityContainer.getEntity())) {
                    this.changeSink.process(new ChangeContainer(toEntityContainer, ChangeAction.Modify));
                }
                fromEntityContainer = null;
                toEntityContainer = null;
            }
            while (fromEntityContainer != null || this.fromPostbox.hasNext()) {
                if (fromEntityContainer == null) {
                    fromEntityContainer = (EntityContainer)this.fromPostbox.getNext();
                }
                this.changeSink.process(new ChangeContainer(timestampSetter.updateTimestamp(fromEntityContainer), ChangeAction.Delete));
                fromEntityContainer = null;
            }
            while (toEntityContainer != null || this.toPostbox.hasNext()) {
                if (toEntityContainer == null) {
                    toEntityContainer = (EntityContainer)this.toPostbox.getNext();
                }
                this.changeSink.process(new ChangeContainer(toEntityContainer, ChangeAction.Create));
                toEntityContainer = null;
            }
            this.changeSink.complete();
            this.fromPostbox.outputComplete();
            this.toPostbox.outputComplete();
        }
        finally {
            this.changeSink.close();
            this.fromPostbox.outputRelease();
            this.toPostbox.outputRelease();
        }
    }
}

