/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.merge.common.ConflictResolutionMethod;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.MultiChangeSinkRunnableChangeSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.MultiChangeSinkRunnableChangeSource;
import org.openstreetmap.osmosis.set.v0_6.ChangeMerger;

public class ChangeMergerFactory
extends TaskManagerFactory {
    private static final String ARG_CONFLICT_RESOLUTION_METHOD = "conflictResolutionMethod";
    private static final String DEFAULT_CONFLICT_RESOLUTION_METHOD = "version";
    private static final String ALTERNATIVE_CONFLICT_RESOLUTION_METHOD_1 = "timestamp";
    private static final String ALTERNATIVE_CONFLICT_RESOLUTION_METHOD_2 = "lastSource";
    private static final Map<String, ConflictResolutionMethod> CONFLICT_RESOLUTION_METHOD_MAP = new HashMap<String, ConflictResolutionMethod>();
    private static final String ARG_BUFFER_CAPACITY = "bufferCapacity";
    private static final int DEFAULT_BUFFER_CAPACITY = 20;

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        String conflictResolutionMethod = this.getStringArgument(taskConfig, ARG_CONFLICT_RESOLUTION_METHOD, DEFAULT_CONFLICT_RESOLUTION_METHOD);
        if (!CONFLICT_RESOLUTION_METHOD_MAP.containsKey(conflictResolutionMethod)) {
            throw new OsmosisRuntimeException("Argument conflictResolutionMethod for task " + taskConfig.getId() + " has value \"" + conflictResolutionMethod + "\" which is unrecognised.");
        }
        int bufferCapacity = this.getIntegerArgument(taskConfig, ARG_BUFFER_CAPACITY, this.getDefaultIntegerArgument(taskConfig, 20));
        return new MultiChangeSinkRunnableChangeSourceManager(taskConfig.getId(), (MultiChangeSinkRunnableChangeSource)new ChangeMerger(CONFLICT_RESOLUTION_METHOD_MAP.get(conflictResolutionMethod), bufferCapacity), taskConfig.getPipeArgs());
    }

    static {
        CONFLICT_RESOLUTION_METHOD_MAP.put(DEFAULT_CONFLICT_RESOLUTION_METHOD, ConflictResolutionMethod.Version);
        CONFLICT_RESOLUTION_METHOD_MAP.put(ALTERNATIVE_CONFLICT_RESOLUTION_METHOD_1, ConflictResolutionMethod.Timestamp);
        CONFLICT_RESOLUTION_METHOD_MAP.put(ALTERNATIVE_CONFLICT_RESOLUTION_METHOD_2, ConflictResolutionMethod.LatestSource);
    }
}

