/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.graphics;

import org.mapsforge.core.graphics.Filter;

public final class GraphicUtils {
    public static int filterColor(int color, Filter filter) {
        if (filter == Filter.NONE) {
            return color;
        }
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (filter) {
            case GRAYSCALE: {
                g2 = b = (int)(0.213f * (float)r + 0.715f * (float)g2 + 0.072f * (float)b);
                r = b;
                break;
            }
            case GRAYSCALE_INVERT: {
                g2 = b = 255 - (int)(0.213f * (float)r + 0.715f * (float)g2 + 0.072f * (float)b);
                r = b;
                break;
            }
            case INVERT: {
                r = 255 - r;
                g2 = 255 - g2;
                b = 255 - b;
            }
        }
        return a << 24 | r << 16 | g2 << 8 | b;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static float[] imageSize(float picWidth, float picHeight, float scaleFactor, int width, int height, int percent) {
        float bitmapWidth = picWidth * scaleFactor;
        float bitmapHeight = picHeight * scaleFactor;
        float aspectRatio = picWidth / picHeight;
        if (width != 0 && height != 0) {
            bitmapWidth = width;
            bitmapHeight = height;
        } else if (width == 0 && height != 0) {
            bitmapWidth = (float)height * aspectRatio;
            bitmapHeight = height;
        } else if (width != 0 && height == 0) {
            bitmapHeight = (float)width / aspectRatio;
            bitmapWidth = width;
        }
        if (percent != 100) {
            bitmapWidth *= (float)percent / 100.0f;
            bitmapHeight *= (float)percent / 100.0f;
        }
        return new float[]{bitmapWidth, bitmapHeight};
    }

    private GraphicUtils() {
    }
}

