/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.map.writer.BaseTileBasedDataProcessor;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.RAMTileData;
import org.mapsforge.map.writer.model.MapWriterConfiguration;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDRelation;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.model.TileCoordinate;
import org.mapsforge.map.writer.model.TileData;
import org.mapsforge.map.writer.model.ZoomIntervalConfiguration;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;

public final class RAMTileBasedDataProcessor
extends BaseTileBasedDataProcessor {
    final TLongObjectHashMap<TDWay> ways;
    private final TLongObjectHashMap<TDRelation> multipolygons;
    private final TLongObjectHashMap<TDNode> nodes = new TLongObjectHashMap();
    private final RAMTileData[][][] tileData;

    public static RAMTileBasedDataProcessor newInstance(MapWriterConfiguration configuration) {
        return new RAMTileBasedDataProcessor(configuration);
    }

    private RAMTileBasedDataProcessor(MapWriterConfiguration configuration) {
        super(configuration);
        this.ways = new TLongObjectHashMap();
        this.multipolygons = new TLongObjectHashMap();
        this.tileData = new RAMTileData[this.zoomIntervalConfiguration.getNumberOfZoomIntervals()][][];
        for (int i = 0; i < this.zoomIntervalConfiguration.getNumberOfZoomIntervals(); ++i) {
            this.tileData[i] = new RAMTileData[this.tileGridLayouts[i].getAmountTilesHorizontal()][this.tileGridLayouts[i].getAmountTilesVertical()];
        }
    }

    @Override
    public void addNode(Node node) {
        super.addNode(node);
        TDNode tdNode = TDNode.fromNode(node, this.preferredLanguages);
        this.nodes.put(tdNode.getId(), tdNode);
        this.addPOI(tdNode);
    }

    @Override
    public void addRelation(Relation relation) {
        super.addRelation(relation);
        TDRelation tdRelation = TDRelation.fromRelation(relation, this, this.preferredLanguages);
        if (tdRelation != null) {
            this.multipolygons.put(relation.getId(), tdRelation);
        }
    }

    @Override
    public void addWay(Way way) {
        super.addWay(way);
        TDWay tdWay = TDWay.fromWay(way, this, this.preferredLanguages);
        if (tdWay == null) {
            return;
        }
        this.ways.put(tdWay.getId(), tdWay);
        this.maxWayID = Math.max(this.maxWayID, way.getId());
        this.prepareImplicitWayRelations(tdWay);
    }

    @Override
    public void close() {
    }

    @Override
    public void complete() {
        this.handleImplicitWayRelations();
        LOGGER.info("handle relations...");
        BaseTileBasedDataProcessor.RelationHandler relationHandler = new BaseTileBasedDataProcessor.RelationHandler();
        this.multipolygons.forEachValue(relationHandler);
        LOGGER.info("handle ways...");
        BaseTileBasedDataProcessor.WayHandler wayHandler = new BaseTileBasedDataProcessor.WayHandler();
        this.ways.forEachValue(wayHandler);
        OSMTagMapping.getInstance().optimizePoiOrdering(this.histogramPoiTags);
        OSMTagMapping.getInstance().optimizeWayOrdering(this.histogramWayTags);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingbox;
    }

    @Override
    public Set<TDWay> getCoastLines(TileCoordinate tc) {
        if (tc.getZoomlevel() <= 12) {
            return Collections.emptySet();
        }
        TileCoordinate correspondingOceanTile = tc.translateToZoomLevel((byte)12).get(0);
        TLongHashSet coastlines = (TLongHashSet)this.tilesToCoastlines.get(correspondingOceanTile);
        if (coastlines == null) {
            return Collections.emptySet();
        }
        final HashSet<TDWay> res = new HashSet<TDWay>();
        coastlines.forEach(new TLongProcedure(){

            @Override
            public boolean execute(long id) {
                TDWay way = RAMTileBasedDataProcessor.this.ways.get(id);
                if (way != null) {
                    res.add(way);
                    return true;
                }
                return false;
            }
        });
        return res;
    }

    @Override
    public List<TDWay> getInnerWaysOfMultipolygon(long outerWayID) {
        TLongArrayList innerwayIDs = (TLongArrayList)this.outerToInnerMapping.get(outerWayID);
        if (innerwayIDs == null) {
            return null;
        }
        return this.getInnerWaysOfMultipolygon(innerwayIDs.toArray());
    }

    @Override
    public TDNode getNode(long id) {
        return this.nodes.get(id);
    }

    @Override
    public TileData getTile(int zoom, int tileX, int tileY) {
        return this.getTileImpl(zoom, tileX, tileY);
    }

    @Override
    public TDWay getWay(long id) {
        return this.ways.get(id);
    }

    @Override
    public ZoomIntervalConfiguration getZoomIntervalConfiguration() {
        return this.zoomIntervalConfiguration;
    }

    @Override
    protected RAMTileData getTileImpl(int zoom, int tileX, int tileY) {
        int tileCoordinateXIndex = tileX - this.tileGridLayouts[zoom].getUpperLeft().getX();
        int tileCoordinateYIndex = tileY - this.tileGridLayouts[zoom].getUpperLeft().getY();
        if (tileCoordinateXIndex < 0 || tileCoordinateYIndex < 0 || this.tileData[zoom].length <= tileCoordinateXIndex || this.tileData[zoom][tileCoordinateXIndex].length <= tileCoordinateYIndex) {
            return null;
        }
        RAMTileData td = this.tileData[zoom][tileCoordinateXIndex][tileCoordinateYIndex];
        if (td == null) {
            this.tileData[zoom][tileCoordinateXIndex][tileCoordinateYIndex] = td = new RAMTileData();
        }
        return td;
    }

    @Override
    protected void handleAdditionalRelationTags(TDWay virtualWay, TDRelation relation) {
    }

    @Override
    protected void handleVirtualInnerWay(TDWay virtualWay) {
        this.ways.put(virtualWay.getId(), virtualWay);
    }

    @Override
    protected void handleVirtualOuterWay(TDWay virtualWay) {
    }

    private List<TDWay> getInnerWaysOfMultipolygon(long[] innerWayIDs) {
        if (innerWayIDs == null) {
            return Collections.emptyList();
        }
        ArrayList<TDWay> res = new ArrayList<TDWay>();
        for (long id : innerWayIDs) {
            TDWay current = this.ways.get(id);
            if (current == null) continue;
            res.add(current);
        }
        return res;
    }
}

