/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.model.OSMTag;
import org.mapsforge.map.writer.model.SpecialTagExtractionResult;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.model.WayResolver;
import org.mapsforge.map.writer.util.OSMUtils;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;

public class TDRelation {
    private static final Logger LOGGER = Logger.getLogger(TDRelation.class.getName());
    private final String houseNumber;
    private final long id;
    private final byte layer;
    private final TDWay[] memberWays;
    private final String name;
    private final String ref;
    private final Map<Short, Object> tags;

    public static TDRelation fromRelation(Relation relation, WayResolver resolver, List<String> preferredLanguages) {
        if (relation == null) {
            return null;
        }
        if (relation.getMembers().isEmpty()) {
            return null;
        }
        SpecialTagExtractionResult ster = OSMUtils.extractSpecialFields((Entity)relation, preferredLanguages);
        Map<Short, Object> knownWayTags = OSMUtils.extractKnownWayTags((Entity)relation);
        if (!TDRelation.knownRelationType(ster.getType())) {
            return null;
        }
        List members = relation.getMembers();
        ArrayList<TDWay> wayMembers = new ArrayList<TDWay>();
        for (RelationMember relationMember : members) {
            if (relationMember.getMemberType() != EntityType.Way) continue;
            TDWay member = resolver.getWay(relationMember.getMemberId());
            if (member == null) {
                LOGGER.finest("relation is missing a member, rel-id: " + relation.getId() + " member id: " + relationMember.getMemberId());
                continue;
            }
            wayMembers.add(member);
        }
        if (wayMembers.isEmpty()) {
            LOGGER.finest("relation has no valid members: " + relation.getId());
            return null;
        }
        return new TDRelation(relation.getId(), ster.getLayer(), ster.getName(), ster.getHousenumber(), ster.getRef(), knownWayTags, wayMembers.toArray(new TDWay[wayMembers.size()]));
    }

    public static boolean knownRelationType(String type) {
        return type != null && "multipolygon".equals(type);
    }

    TDRelation(long id, byte layer, String name, String houseNumber, String ref, Map<Short, Object> tags, TDWay[] memberWays) {
        this.id = id;
        this.layer = layer;
        this.name = name;
        this.houseNumber = houseNumber;
        this.ref = ref;
        this.tags = tags;
        this.memberWays = memberWays;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDRelation other = (TDRelation)obj;
        return this.id == other.id;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public long getId() {
        return this.id;
    }

    public byte getLayer() {
        return this.layer;
    }

    public TDWay[] getMemberWays() {
        return this.memberWays;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public Map<Short, Object> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean hasTags() {
        return this.tags != null && this.tags.size() > 0;
    }

    public boolean isCoastline() {
        List<OSMTag> osmTags = OSMTagMapping.getInstance().getWayTags(this.tags.keySet());
        for (OSMTag tag : osmTags) {
            if (!tag.isCoastline()) continue;
            return true;
        }
        return false;
    }

    public boolean isRenderRelevant() {
        return this.hasTags() || this.getName() != null && !this.getName().isEmpty() || this.getRef() != null && !this.getRef().isEmpty();
    }

    public String toString() {
        return "TDRelation [id=" + this.id + ", layer=" + this.layer + ", name=" + this.name + ", ref=" + this.ref + ", tags=" + Arrays.toString(this.tags.keySet().toArray()) + ", members=" + this.memberWays.length + "]";
    }

    public String toStringDetailed() {
        return "TDRelation [id=" + this.id + ", layer=" + this.layer + ", name=" + this.name + ", ref=" + this.ref + ", tags=" + OSMUtils.tagsToString(this.tags, true) + ", members=" + this.memberWays.length + "]";
    }
}

