/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.BufferedRandomAccessFileInputStream;
import org.openstreetmap.osmosis.core.store.StorageStage;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocation;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocationStore;

public class PersistentNodeLocationStore
implements NodeLocationStore {
    private static final Logger LOG = Logger.getLogger(PersistentNodeLocationStore.class.getName());
    private static final int ZERO_BUFFER_SIZE = 0x100000;
    private static final int NODE_DATA_SIZE = 9;
    private File nodeStorageFile;
    private StorageStage stage = StorageStage.NotStarted;
    private long lastNodeId = Long.MIN_VALUE;
    private FileOutputStream fileOutStream;
    private DataOutputStream dataOutStream;
    private BufferedRandomAccessFileInputStream fileInStream;
    private DataInputStream dataInStream;
    private long currentFileOffset;
    private byte[] zeroBuffer = new byte[0x100000];
    private NodeLocation invalidNodeLocation;

    public PersistentNodeLocationStore() {
        Arrays.fill(this.zeroBuffer, (byte)0);
        this.invalidNodeLocation = new NodeLocation();
    }

    private void initializeAddStage() {
        if (this.stage.compareTo((Enum)StorageStage.Add) > 0) {
            throw new OsmosisRuntimeException("Cannot add to storage in stage " + this.stage + ".");
        }
        if (this.stage.compareTo((Enum)StorageStage.Add) < 0) {
            try {
                this.nodeStorageFile = File.createTempFile("nodelatlon", null);
                this.fileOutStream = new FileOutputStream(this.nodeStorageFile);
                this.dataOutStream = new DataOutputStream(new BufferedOutputStream(this.fileOutStream, 65536));
                this.currentFileOffset = 0L;
                this.stage = StorageStage.Add;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to create object stream writing to temporary file " + this.nodeStorageFile + ".", (Throwable)e);
            }
        }
    }

    private void initializeReadingStage() {
        if (this.stage.compareTo((Enum)StorageStage.Reading) == 0) {
            return;
        }
        if (this.stage.compareTo((Enum)StorageStage.Released) >= 0) {
            throw new OsmosisRuntimeException("Cannot read from node storage in stage " + this.stage + ".");
        }
        if (this.stage.compareTo((Enum)StorageStage.NotStarted) <= 0) {
            this.initializeAddStage();
        }
        if (this.stage.compareTo((Enum)StorageStage.Add) == 0) {
            try {
                this.dataOutStream.close();
                this.fileOutStream.close();
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to close output stream.", (Throwable)e);
            }
            finally {
                this.dataOutStream = null;
                this.fileOutStream = null;
            }
            try {
                this.fileInStream = new BufferedRandomAccessFileInputStream(this.nodeStorageFile);
                this.dataInStream = new DataInputStream((InputStream)this.fileInStream);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open the node data file " + this.nodeStorageFile + ".", (Throwable)e);
            }
            this.stage = StorageStage.Reading;
        }
    }

    @Override
    public void addLocation(long nodeId, NodeLocation nodeLocation) {
        this.initializeAddStage();
        if (nodeId <= this.lastNodeId) {
            throw new OsmosisRuntimeException("The node id of " + nodeId + " must be greater than the previous id of " + this.lastNodeId + ".");
        }
        this.lastNodeId = nodeId;
        try {
            long requiredFileOffset = nodeId * 9L;
            if (requiredFileOffset > this.currentFileOffset) {
                while (this.currentFileOffset < requiredFileOffset) {
                    long offsetDifference = requiredFileOffset - this.currentFileOffset;
                    if (offsetDifference > 0x100000L) {
                        offsetDifference = 0x100000L;
                    }
                    this.dataOutStream.write(this.zeroBuffer, 0, (int)offsetDifference);
                    this.currentFileOffset += offsetDifference;
                }
            }
            this.dataOutStream.writeByte(1);
            this.dataOutStream.writeInt(FixedPrecisionCoordinateConvertor.convertToFixed((double)nodeLocation.getLongitude()));
            this.dataOutStream.writeInt(FixedPrecisionCoordinateConvertor.convertToFixed((double)nodeLocation.getLatitude()));
            this.currentFileOffset += 9L;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write node location data to node storage file " + this.nodeStorageFile + ".", (Throwable)e);
        }
    }

    @Override
    public NodeLocation getNodeLocation(long nodeId) {
        this.initializeReadingStage();
        long offset = nodeId * 9L;
        NodeLocation nodeLocation = this.invalidNodeLocation;
        if (offset < this.currentFileOffset) {
            try {
                this.fileInStream.seek(offset);
                byte validFlag = this.dataInStream.readByte();
                if (validFlag != 0) {
                    nodeLocation = new NodeLocation(FixedPrecisionCoordinateConvertor.convertToDouble((int)this.dataInStream.readInt()), FixedPrecisionCoordinateConvertor.convertToDouble((int)this.dataInStream.readInt()));
                }
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read node information from the node storage file.", (Throwable)e);
            }
        }
        return nodeLocation;
    }

    public void close() {
        if (this.fileOutStream != null) {
            try {
                this.fileOutStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to close file output stream.", e);
            }
            this.fileOutStream = null;
        }
        if (this.fileInStream != null) {
            try {
                this.fileInStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to close file input stream.", e);
            }
            this.fileInStream = null;
        }
        if (this.nodeStorageFile != null) {
            if (!this.nodeStorageFile.delete()) {
                LOG.warning("Unable to delete file " + this.nodeStorageFile);
            }
            this.nodeStorageFile = null;
        }
    }
}

