"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fc = require("fast-check");
const scalingcommon = require("../lib");
class ArbitraryCompleteIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(scalingcommon.normalizeIntervals(ret.intervals, ret.absolute));
    }
}
exports.ArbitraryCompleteIntervals = ArbitraryCompleteIntervals;
function arbitrary_complete_intervals() {
    return new ArbitraryCompleteIntervals();
}
exports.arbitrary_complete_intervals = arbitrary_complete_intervals;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxpQ0FBaUM7QUFDakMsd0NBQXdDO0FBRXhDLE1BQWEsMEJBQTJCLFNBQVEsRUFBRSxDQUFDLFNBQWtEO0lBQzVGLFFBQVEsQ0FBQyxJQUFlO1FBQzdCLE1BQU0sR0FBRyxHQUFHLGFBQWEsQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzRCxPQUFPLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMxRixDQUFDO0NBQ0Y7QUFMRCxnRUFLQztBQUVELFNBQWdCLDRCQUE0QjtJQUMxQyxPQUFPLElBQUksMEJBQTBCLEVBQUUsQ0FBQztBQUMxQyxDQUFDO0FBRkQsb0VBRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmYyBmcm9tICdmYXN0LWNoZWNrJztcbmltcG9ydCAqIGFzIHNjYWxpbmdjb21tb24gZnJvbSAnLi4vbGliJztcblxuZXhwb3J0IGNsYXNzIEFyYml0cmFyeUNvbXBsZXRlSW50ZXJ2YWxzIGV4dGVuZHMgZmMuQXJiaXRyYXJ5PHNjYWxpbmdjb21tb24uQ29tcGxldGVTY2FsaW5nSW50ZXJ2YWxbXT4ge1xuICBwdWJsaWMgZ2VuZXJhdGUobXJuZzogZmMuUmFuZG9tKTogZmMuU2hyaW5rYWJsZTxzY2FsaW5nY29tbW9uLkNvbXBsZXRlU2NhbGluZ0ludGVydmFsW10+IHtcbiAgICBjb25zdCByZXQgPSBzY2FsaW5nY29tbW9uLmdlbmVyYXRlQXJiaXRyYXJ5SW50ZXJ2YWxzKG1ybmcpO1xuICAgIHJldHVybiBuZXcgZmMuU2hyaW5rYWJsZShzY2FsaW5nY29tbW9uLm5vcm1hbGl6ZUludGVydmFscyhyZXQuaW50ZXJ2YWxzLCByZXQuYWJzb2x1dGUpKTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gYXJiaXRyYXJ5X2NvbXBsZXRlX2ludGVydmFscygpIHtcbiAgcmV0dXJuIG5ldyBBcmJpdHJhcnlDb21wbGV0ZUludGVydmFscygpO1xufVxuIl19