#      Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#      This program is free software: you can redistribute it and/or modify
#      it under the terms of the GNU Affero General Public License as
#      published by the Free Software Foundation, either version 3 of the
#      License, or (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU Affero General Public License for more details.
#
#      You should have received a copy of the GNU Affero General Public License
#      along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Generated by Django 2.2 on 2019-08-15 09:41

import datetime

import django.db.models.deletion
from django.db import migrations, models

import nobinobi_daily_follow_up.models


class Migration(migrations.Migration):
    dependencies = [
        ('nobinobi_daily_follow_up', '0003_troubleshooting'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='activity',
            options={
                'ordering': ('daily_follow_up', 'type_activity'), 'verbose_name': 'Activité',
                'verbose_name_plural': 'Activités'
            },
        ),
        migrations.AlterModelOptions(
            name='activitygroup',
            options={
                'ordering': ('name',), 'verbose_name': 'Groupe d’activités',
                'verbose_name_plural': 'Groupes d’activités'
            },
        ),
        migrations.AlterModelOptions(
            name='dailyfollowup',
            options={
                'ordering': ('presence',), 'verbose_name': 'Suivi journalier',
                'verbose_name_plural': 'Suivis journaliers'
            },
        ),
        migrations.AlterModelOptions(
            name='diaperchange',
            options={
                'ordering': ('daily_follow_up', 'hour'), 'verbose_name': 'Changement de couche',
                'verbose_name_plural': 'Changements de couches'
            },
        ),
        migrations.AlterModelOptions(
            name='givemedication',
            options={
                'ordering': ('medication',), 'verbose_name': 'Donner médicament',
                'verbose_name_plural': 'Donner médicaments'
            },
        ),
        migrations.AlterModelOptions(
            name='lotion',
            options={'ordering': ('name',), 'verbose_name': 'Crème', 'verbose_name_plural': 'Crèmes'},
        ),
        migrations.AlterModelOptions(
            name='lotiondailyfollowup',
            options={
                'ordering': ('daily_follow_up',), 'verbose_name': 'Suivi des crèmes',
                'verbose_name_plural': 'Suivis des crèmes'
            },
        ),
        migrations.AlterModelOptions(
            name='meal',
            options={'ordering': ('name',), 'verbose_name': 'Repas', 'verbose_name_plural': 'Repas'},
        ),
        migrations.AlterModelOptions(
            name='mealdailyfollowup',
            options={
                'ordering': ('daily_follow_up',), 'verbose_name': 'Suivi journalier des repas',
                'verbose_name_plural': 'Suivi journalier des repas'
            },
        ),
        migrations.AlterModelOptions(
            name='medication',
            options={
                'ordering': ('daily_follow_up', 'type_medication'), 'verbose_name': 'Médicament',
                'verbose_name_plural': 'Médicaments'
            },
        ),
        migrations.AlterModelOptions(
            name='nap',
            options={
                'ordering': ('start_time', 'end_time'), 'verbose_name': 'Sieste', 'verbose_name_plural': 'Siestes'
            },
        ),
        migrations.AlterModelOptions(
            name='presence',
            options={'ordering': ('date',), 'verbose_name': 'Présence', 'verbose_name_plural': 'Présences'},
        ),
        migrations.AlterModelOptions(
            name='reception',
            options={'ordering': ('daily_follow_up',), 'verbose_name': 'Accueil', 'verbose_name_plural': 'Accueils'},
        ),
        migrations.AlterModelOptions(
            name='troubleshooting',
            options={'ordering': ('daily_follow_up',), 'verbose_name': 'Dépannage', 'verbose_name_plural': 'Dépannage'},
        ),
        migrations.AlterModelOptions(
            name='typeactivity',
            options={
                'ordering': ('order', 'name', 'group'), 'verbose_name': "Types d'activité",
                'verbose_name_plural': 'Types d’activités'
            },
        ),
        migrations.AlterModelOptions(
            name='typemedication',
            options={
                'ordering': ('name',), 'verbose_name': 'Type de médicament',
                'verbose_name_plural': 'Types de médicaments'
            },
        ),
        migrations.AlterField(
            model_name='activity',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='activity',
            name='type_activity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='nobinobi_daily_follow_up.TypeActivity', verbose_name="Types d'activité"),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='activities',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Activity',
                                         to='nobinobi_daily_follow_up.TypeActivity', verbose_name='Activités'),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='lotions',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.LotionDailyFollowUp',
                                         to='nobinobi_daily_follow_up.Lotion', verbose_name='Crèmes'),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Medication',
                                         to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Médicaments'),
        ),
        migrations.AlterField(
            model_name='diaperchange',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='diaperchange',
            name='feces',
            field=models.CharField(choices=[('feces', 'caca.png'), ('nothing', 'nothing.png')], default='nothing',
                                   max_length=15, verbose_name='Selles'),
        ),
        migrations.AlterField(
            model_name='diaperchange',
            name='hour',
            field=models.TimeField(verbose_name='Heure'),
        ),
        migrations.AlterField(
            model_name='givemedication',
            name='give_hour',
            field=models.TimeField(verbose_name='Donner à'),
        ),
        migrations.AlterField(
            model_name='givemedication',
            name='given_hour',
            field=models.TimeField(blank=True, null=True, verbose_name='Donné à'),
        ),
        migrations.AlterField(
            model_name='givemedication',
            name='medication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.Medication', verbose_name='Médicament'),
        ),
        migrations.AlterField(
            model_name='lotiondailyfollowup',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='lotiondailyfollowup',
            name='lotion',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='nobinobi_daily_follow_up.Lotion', verbose_name='Crème'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='afternoon_snack_meals',
            field=models.ManyToManyField(blank=True, related_name='afternoon_snack_meals',
                                         to='nobinobi_daily_follow_up.Meal', verbose_name='Goûter'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='afternoon_snack_quality',
            field=models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'),
                                                        ('nothing', 'nothing.png')], max_length=10, null=True,
                                   verbose_name='Bien mangé ?'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='afternoon_snack_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure du goûter'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='lunch_meals',
            field=models.ManyToManyField(blank=True, related_name='lunch_meals', to='nobinobi_daily_follow_up.Meal',
                                         verbose_name='Diner'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='lunch_quality',
            field=models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'),
                                                        ('nothing', 'nothing.png')], max_length=10, null=True,
                                   verbose_name='Bien mangé'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='lunch_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure du diner'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='snack_meals',
            field=models.ManyToManyField(blank=True, related_name='snack_meals', to='nobinobi_daily_follow_up.Meal',
                                         verbose_name='Collation'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='snack_quality',
            field=models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'),
                                                        ('nothing', 'nothing.png')], max_length=10, null=True,
                                   verbose_name='Bien mangé ?'),
        ),
        migrations.AlterField(
            model_name='mealdailyfollowup',
            name='snack_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure de la collation'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='attachment',
            field=models.FileField(blank=True, null=True,
                                   upload_to=nobinobi_daily_follow_up.models.Medication.attachment_file_medication,
                                   verbose_name='Pièce jointe'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='type_medication',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Type de médicament'),
        ),
        migrations.AlterField(
            model_name='nap',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='nap',
            name='end_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure de fin'),
        ),
        migrations.AlterField(
            model_name='nap',
            name='start_time',
            field=models.TimeField(verbose_name='Heure de début'),
        ),
        migrations.AlterField(
            model_name='presence',
            name='arrival_time',
            field=models.TimeField(verbose_name="Heure d'arrivée"),
        ),
        migrations.AlterField(
            model_name='presence',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.Child',
                                    verbose_name='Enfant'),
        ),
        migrations.AlterField(
            model_name='presence',
            name='classroom',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='nobinobi_child.Classroom', verbose_name='Salle de classe'),
        ),
        migrations.AlterField(
            model_name='presence',
            name='departure_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure de départ'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='breakfast',
            field=models.CharField(
                choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')],
                default='very_good', max_length=20, null=True, verbose_name='Petit-déjeuner'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='breakfast_time',
            field=models.TimeField(blank=True, null=True, verbose_name='Heure du petit-déjeuner'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='condition',
            field=models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('sick', 'spook.png')],
                                   default='very_good', max_length=10, null=True, verbose_name="Etat de l'enfant"),
        ),
        migrations.AlterField(
            model_name='reception',
            name='fever',
            field=models.CharField(
                choices=[('no', 'Non'), ('37', '37'), ('37.5', '37.5'), ('38', '38'), ('38.5', '38.5'), ('39', '39'),
                         ('39.5', '39.5'), ('40', '40')], default='no', max_length=10, null=True,
                verbose_name='Fièvre'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='sick',
            field=models.CharField(
                choices=[('no', 'Non'), ('gastroenteritis', 'Gastro-entérite'), ('conjunctivitis', 'Conjonctivite'),
                         ('cough', 'Toux'), ('cold', 'Rhume')], default='no', max_length=25, null=True,
                verbose_name='Malade'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='sleep',
            field=models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('bad', 'spook.png')],
                                   default='very_good', max_length=10, null=True, verbose_name='Sommeil'),
        ),
        migrations.AlterField(
            model_name='reception',
            name='wake_up_time',
            field=models.TimeField(choices=[(datetime.time(5, 0), '05H00'), (datetime.time(5, 15), '05H15'),
                                            (datetime.time(5, 30), '05H30'), (datetime.time(5, 45), '05H45'),
                                            (datetime.time(6, 0), '06H00'), (datetime.time(6, 15), '06H15'),
                                            (datetime.time(6, 30), '06H30'), (datetime.time(6, 45), '06H45'),
                                            (datetime.time(7, 0), '07H00'), (datetime.time(7, 15), '07H15'),
                                            (datetime.time(7, 30), '07H30'), (datetime.time(7, 45), '07H45'),
                                            (datetime.time(8, 0), '08H00')], default=datetime.time(6, 0), null=True,
                                   verbose_name='Heure de réveil'),
        ),
        migrations.AlterField(
            model_name='troubleshooting',
            name='daily_follow_up',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE,
                                       to='nobinobi_daily_follow_up.DailyFollowUp', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='troubleshooting',
            name='periods',
            field=models.ManyToManyField(to='nobinobi_child.Period', verbose_name='Périodes'),
        ),
        migrations.AlterField(
            model_name='typeactivity',
            name='group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='nobinobi_daily_follow_up.ActivityGroup', verbose_name='Groupe'),
        ),
    ]
