import * as ses from '@aws-cdk/aws-ses';
import * as sns from '@aws-cdk/aws-sns';
/**
 * Construction properties for a BounceTemplate.
 *
 * @stability stable
 */
export interface BounceTemplateProps {
    /**
     * Human-readable text to include in the bounce message.
     *
     * @stability stable
     */
    readonly message: string;
    /**
     * The SMTP reply code, as defined by RFC 5321.
     *
     * @see https://tools.ietf.org/html/rfc5321
     * @stability stable
     */
    readonly smtpReplyCode: string;
    /**
     * The SMTP enhanced status code, as defined by RFC 3463.
     *
     * @see https://tools.ietf.org/html/rfc3463
     * @stability stable
     */
    readonly statusCode?: string;
}
/**
 * A bounce template.
 *
 * @stability stable
 */
export declare class BounceTemplate {
    readonly props: BounceTemplateProps;
    /**
     * @stability stable
     */
    static readonly MAILBOX_DOES_NOT_EXIST: BounceTemplate;
    /**
     * @stability stable
     */
    static readonly MESSAGE_TOO_LARGE: BounceTemplate;
    /**
     * @stability stable
     */
    static readonly MAILBOX_FULL: BounceTemplate;
    /**
     * @stability stable
     */
    static readonly MESSAGE_CONTENT_REJECTED: BounceTemplate;
    /**
     * @stability stable
     */
    static readonly TEMPORARY_FAILURE: BounceTemplate;
    /**
     * @stability stable
     */
    constructor(props: BounceTemplateProps);
}
/**
 * Construction properties for a bounce action.
 *
 * @stability stable
 */
export interface BounceProps {
    /**
     * The template containing the message, reply code and status code.
     *
     * @stability stable
     */
    readonly template: BounceTemplate;
    /**
     * The email address of the sender of the bounced email.
     *
     * This is the address
     * from which the bounce message will be sent.
     *
     * @stability stable
     */
    readonly sender: string;
    /**
     * The SNS topic to notify when the bounce action is taken.
     *
     * @default no notification
     * @stability stable
     */
    readonly topic?: sns.ITopic;
}
/**
 * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @stability stable
 */
export declare class Bounce implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: BounceProps);
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
