"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A bounce template.
 *
 * @stability stable
 */
class BounceTemplate {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceTemplateProps(props);
    }
}
exports.BounceTemplate = BounceTemplate;
_a = JSII_RTTI_SYMBOL_1;
BounceTemplate[_a] = { fqn: "@aws-cdk/aws-ses-actions.BounceTemplate", version: "1.144.0" };
/**
 * @stability stable
 */
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
/**
 * @stability stable
 */
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
/**
 * @stability stable
 */
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
/**
 * @stability stable
 */
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
/**
 * @stability stable
 */
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @stability stable
 */
class Bounce {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_BounceProps(props);
    }
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(_rule) {
        var _c;
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: (_c = this.props.topic) === null || _c === void 0 ? void 0 : _c.topicArn,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
_b = JSII_RTTI_SYMBOL_1;
Bounce[_b] = { fqn: "@aws-cdk/aws-ses-actions.Bounce", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,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