"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sns = exports.EmailEncoding = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The type of email encoding to use for a SNS action.
 *
 * @stability stable
 */
var EmailEncoding;
(function (EmailEncoding) {
    EmailEncoding["BASE64"] = "Base64";
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 *
 * @stability stable
 */
class Sns {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_ses_actions_SnsProps(props);
    }
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
_a = JSII_RTTI_SYMBOL_1;
Sns[_a] = { fqn: "@aws-cdk/aws-ses-actions.Sns", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBSUEsSUFBWSxhQU1YO0FBTkQsV0FBWSxhQUFhO0lBRXZCLGtDQUFpQixDQUFBO0lBR2pCLCtCQUFjLENBQUE7QUFDaEIsQ0FBQyxFQU5XLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBTXhCOzs7Ozs7QUFZRCxNQUFhLEdBQUc7Ozs7SUFDZCxZQUE2QixLQUFlO1FBQWYsVUFBSyxHQUFMLEtBQUssQ0FBVTs7S0FDM0M7Ozs7OztJQUVNLElBQUksQ0FBQyxLQUF1QjtRQUNqQyxPQUFPO1lBQ0wsU0FBUyxFQUFFO2dCQUNULFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7Z0JBQzdCLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRO2FBQ3BDO1NBQ0YsQ0FBQztLQUNIOztBQVhILGtCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gRW1haWxFbmNvZGluZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcbiAgQkFTRTY0ID0gJ0Jhc2U2NCcsXG5cbiAgICAgICAgICAgICAgICAgICAgICBcbiAgVVRGOCA9ICdVVEYtOCcsXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU25zUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVuY29kaW5nPzogRW1haWxFbmNvZGluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWM7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNucyBpbXBsZW1lbnRzIHNlcy5JUmVjZWlwdFJ1bGVBY3Rpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTbnNQcm9wcykge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3J1bGU6IHNlcy5JUmVjZWlwdFJ1bGUpOiBzZXMuUmVjZWlwdFJ1bGVBY3Rpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzbnNBY3Rpb246IHtcbiAgICAgICAgZW5jb2Rpbmc6IHRoaXMucHJvcHMuZW5jb2RpbmcsXG4gICAgICAgIHRvcGljQXJuOiB0aGlzLnByb3BzLnRvcGljLnRvcGljQXJuLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=