# mypy-boto3-cloudhsm

[![PyPI - mypy-boto3-cloudhsm](https://img.shields.io/pypi/v/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudHSM 1.14.20](https://boto3.amazonaws.com/v1/documentation/api/1.14.20/reference/services/cloudhsm.html#CloudHSM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudHSM` service.

```bash
python -m pip install boto3-stubs[cloudhsm]
```

## How to use

### Client annotations

`CloudHSMClient` provides annotations for `boto3.client("cloudhsm")`.

```python
import boto3

from mypy_boto3_cloudhsm import CloudHSMClient
from mypy_boto3_cloudhsm.paginator import (
    ListHapgsPaginator,
    ListHsmsPaginator,
    ListLunaClientsPaginator,
)
from mypy_boto3_cloudhsm.type_defs import TagTypeDef, ...

client: CloudHSMClient = boto3.client("cloudhsm")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudHSMClient = session.client("cloudhsm")
```

### Paginators annotations

`mypy_boto3_cloudhsm.paginator` module contains type annotations for all paginators.

```python

client: CloudHSMClient = boto3.client("cloudhsm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_hapgs_paginator: ListHapgsPaginator = client.get_paginator("list_hapgs")
list_hsms_paginator: ListHsmsPaginator = client.get_paginator("list_hsms")
list_luna_clients_paginator: ListLunaClientsPaginator = client.get_paginator("list_luna_clients")
```







### Typed dictionations

`mypy_boto3_cloudhsm.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> TagTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_cloudhsm` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("cloudhsm")

session_client = boto3.Session().client("cloudhsm")
```
