# Generated by Django 2.1.5 on 2019-01-20 10:24

import django.contrib.auth.validators
import django.utils.timezone
from django.db import migrations, models

import isc_common.auth.managers.user_manager
import isc_common.fields.code_field
import isc_common.fields.description_field
import isc_common.fields.name_field
import isc_common.fields.related
from isc_common.fields.code_field import JSONFieldIVC


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('password', isc_common.fields.code_field.CodeField(verbose_name='пароль')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='последний вход')),
                ('username', isc_common.fields.code_field.CodeField(error_messages={'unique': 'Такой пользователь уже существует.'}, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='логин')),
                ('first_name', isc_common.fields.name_field.NameField(verbose_name='имя')),
                ('last_name', isc_common.fields.name_field.NameField(verbose_name='фамилия')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='E-mail')),
                ('middle_name', isc_common.fields.name_field.NameField(verbose_name='отчетво')),
                ('permissions', JSONFieldIVC(default=dict, null=True, blank=True, )),
            ],
            options={
                'verbose_name': 'Пользователь',
                'swappable': 'AUTH_USER_MODEL',
            },
            managers=[
                ('objects', isc_common.auth.managers.user_manager.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('name', isc_common.fields.name_field.NameField()),
                ('description', isc_common.fields.description_field.DescriptionField()),
                ('code', isc_common.fields.code_field.CodeField(unique=True)),
                ('permissions', JSONFieldIVC(default=dict, null=True, blank=True, )),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='isc_common.UserGroup')),
            ],
            options={
                'verbose_name': 'группа',
                'verbose_name_plural': 'группы',
            },
        ),
        migrations.CreateModel(
            name='Widgets_trees',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted', models.BooleanField(db_index=True, default=False, verbose_name='Признак удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('id_widget', isc_common.fields.code_field.CodeField()),
                ('name', isc_common.fields.name_field.NameField()),
                ('class_name', isc_common.fields.name_field.NameField()),
                ('description', isc_common.fields.description_field.DescriptionField()),
                ('structure', JSONFieldIVC()),
            ],
            options={
                'verbose_name': 'Таблица сохранения деревьев виджетов объектов системы',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='usergroup',
            field=models.ManyToManyField(to='isc_common.UserGroup', verbose_name='группы'),
        ),
    ]
