# coding=utf-8
# Licensed Materials - Property of IBM
# Copyright IBM Corp. 2017
from typing import Any, Callable, Dict, List, Union, overload

import streamsx.topology.exop as exop
from streamsx.topology.schema import _AnySchema
from streamsx.topology.topology import Stream, Topology, _AnyStream

_Expr = Union[Expression, str, int, float, bool]
_OpParams = Dict[str,Any]

class Expression(object):
    def __init__(self, _type: Any, _value: _Expr) -> None: ...
    def expression(value: _Expr) -> Expression: ...

class Invoke(exop.ExtensionOperator):
    def __init__(self, topology: Topology, kind: str, inputs: List[_AnyStream]=None, schemas: List[_AnySchema]=None, params: _OpParams=None, name: str=None) -> None: ...
    @propert
    def outputs(self) : List[Stream]
    @property
    def params(self) -> _OpParams: ...
    def attribute(self, stream: Stream, name: str) -> Expression: ...
    def expression(self, value: _Expr) -> Expression: ...
    def output(self, stream: Stream, value: _Expr) -> Expression: ...
    

class Source(exop.ExtensionOperator):
    def __init__(self, topology: Topology, kind: Any, schema: _AnySchema, params: _OpParams=None, name: str=None) -> None: ...
    @property
    def stream(self) -> Stream: ...
    def output(self, value: _Expr) -> Expression: ...

class Map(exop.ExtensionOperator):
    def __init__(self, kind: str, stream: _AnyStream, schema: _AnySchema=None, params: _OpParams=None, name: str=None) -> None: ...
    @property
    def stream(self) -> Stream: ...
    def attribute(self, name: str) -> Expression: ...
    def output(self, value: _Expr) -> Expression: ...
 

class Sink(exop.ExtensionOperator):
    def __init__(self, kind: str, stream: _AnyStream, params: _OpParams=None, name: str=None) -> None: ...


