"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // tslint:disable:max-line-length
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
            // tslint:enable:max-line-length
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
//# sourceMappingURL=data:application/json;base64,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