"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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