"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
    }
    bind(_rule) {
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
            },
        };
    }
}
exports.Stop = Stop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFhQTs7O0dBR0c7QUFDSCxNQUFhLElBQUk7SUFDZixZQUE2QixRQUFtQixFQUFFO1FBQXJCLFVBQUssR0FBTCxLQUFLLENBQWdCO0lBQ2xELENBQUM7SUFFTSxJQUFJLENBQUMsS0FBdUI7UUFDakMsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixLQUFLLEVBQUUsU0FBUztnQkFDaEIsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDbkU7U0FDRixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBWkQsb0JBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzZXMgZnJvbSAnQGF3cy1jZGsvYXdzLXNlcyc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5cbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgZm9yIGEgc3RvcCBhY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBTTlMgdG9waWMgdG8gbm90aWZ5IHdoZW4gdGhlIHN0b3AgYWN0aW9uIGlzIHRha2VuLlxuICAgKi9cbiAgcmVhZG9ubHkgdG9waWM/OiBzbnMuSVRvcGljO1xufVxuXG4vKipcbiAqIFRlcm1pbmF0ZXMgdGhlIGV2YWx1YXRpb24gb2YgdGhlIHJlY2VpcHQgcnVsZSBzZXQgYW5kIG9wdGlvbmFsbHkgcHVibGlzaGVzIGFcbiAqIG5vdGlmaWNhdGlvbiB0byBBbWF6b24gU05TLlxuICovXG5leHBvcnQgY2xhc3MgU3RvcCBpbXBsZW1lbnRzIHNlcy5JUmVjZWlwdFJ1bGVBY3Rpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTdG9wUHJvcHMgPSB7fSkge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3J1bGU6IHNlcy5JUmVjZWlwdFJ1bGUpOiBzZXMuUmVjZWlwdFJ1bGVBY3Rpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzdG9wQWN0aW9uOiB7XG4gICAgICAgIHNjb3BlOiAnUnVsZVNldCcsXG4gICAgICAgIHRvcGljQXJuOiB0aGlzLnByb3BzLnRvcGljID8gdGhpcy5wcm9wcy50b3BpYy50b3BpY0FybiA6IHVuZGVmaW5lZCxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19