import io
import os
import re

from setuptools import find_packages
from setuptools import setup


def read(filename):
    filename = os.path.join(os.path.dirname(__file__), filename)
    text_type = type(u"")
    with io.open(filename, mode="r", encoding='utf-8') as fd:
        return re.sub(text_type(r':[a-z]+:`~?(.*?)`'), text_type(r'``\1``'), fd.read())


setup(
    name="hamsclient",
    version="0.1.4",
    url="https://github.com/websylv/meteoswiss",
    license='MIT',

    author="websylv",
    author_email="div@webhu.org",

    description="Library to get data from meteo swiss",
    long_description=read("README.rst"),

    packages=find_packages(exclude=('tests',)),

    install_requires=[
        "requests>=2.22.0",
        "pandas>=0.25.3",
        "beautifulsoup4>=4.8.2"
        "geopygeopy==1.23.0"
    ],

    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
