"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingConfiguration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The App Runner Auto Scaling Configuration.
 *
 * @resource AWS::AppRunner::AutoScalingConfiguration
 */
let AutoScalingConfiguration = class AutoScalingConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Auto Scaling Configuration from attributes
     */
    static fromAutoScalingConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAutoScalingConfigurationAttributes);
            }
            throw error;
        }
        const autoScalingConfigurationName = attrs.autoScalingConfigurationName;
        const autoScalingConfigurationRevision = attrs.autoScalingConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'autoscalingconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.autoScalingConfigurationName}/${attrs.autoScalingConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Auto Scaling Configuration from its ARN
     */
    static fromArn(scope, id, autoScalingConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', autoScalingConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new cdk.UnscopedValidationError(`Unexpected ARN format: ${autoScalingConfigurationArn}.`);
        }
        const autoScalingConfigurationName = cdk.Fn.select(0, resourceParts);
        const autoScalingConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.autoScalingConfigurationName = autoScalingConfigurationName;
                this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
                this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.autoScalingConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AutoScalingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AutoScalingConfiguration);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        this.validateAutoScalingConfiguration(props);
        const resource = new aws_apprunner_1.CfnAutoScalingConfiguration(this, 'Resource', {
            autoScalingConfigurationName: props.autoScalingConfigurationName,
            maxConcurrency: props.maxConcurrency,
            maxSize: props.maxSize,
            minSize: props.minSize,
        });
        this.autoScalingConfigurationArn = resource.attrAutoScalingConfigurationArn;
        this.autoScalingConfigurationRevision = resource.attrAutoScalingConfigurationRevision;
        this.autoScalingConfigurationName = resource.ref;
    }
    validateAutoScalingConfiguration(props) {
        if (props.autoScalingConfigurationName !== undefined && !cdk.Token.isUnresolved(props.autoScalingConfigurationName)) {
            if (props.autoScalingConfigurationName.length < 4 || props.autoScalingConfigurationName.length > 32) {
                throw new cdk.ValidationError(`\`autoScalingConfigurationName\` must be between 4 and 32 characters, got: ${props.autoScalingConfigurationName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.autoScalingConfigurationName)) {
                throw new cdk.ValidationError(`\`autoScalingConfigurationName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.autoScalingConfigurationName}.`, this);
            }
        }
        const isMinSizeDefined = typeof props.minSize === 'number';
        const isMaxSizeDefined = typeof props.maxSize === 'number';
        const isMaxConcurrencyDefined = typeof props.maxConcurrency === 'number';
        if (isMinSizeDefined && (props.minSize < 1 || props.minSize > 25)) {
            throw new cdk.ValidationError(`minSize must be between 1 and 25, got ${props.minSize}.`, this);
        }
        if (isMaxSizeDefined && (props.maxSize < 1 || props.maxSize > 25)) {
            throw new cdk.ValidationError(`maxSize must be between 1 and 25, got ${props.maxSize}.`, this);
        }
        if (isMinSizeDefined && isMaxSizeDefined && !(props.minSize < props.maxSize)) {
            throw new cdk.ValidationError('maxSize must be greater than minSize.', this);
        }
        if (isMaxConcurrencyDefined && (props.maxConcurrency < 1 || props.maxConcurrency > 200)) {
            throw new cdk.ValidationError(`maxConcurrency must be between 1 and 200, got ${props.maxConcurrency}.`, this);
        }
    }
};
exports.AutoScalingConfiguration = AutoScalingConfiguration;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.AutoScalingConfiguration", version: "2.211.0-alpha.0" };
/** Uniquely identifies this class. */
AutoScalingConfiguration.PROPERTY_INJECTION_ID = '@aws-cdk.aws-apprunner-alpha.AutoScalingConfiguration';
exports.AutoScalingConfiguration = AutoScalingConfiguration = __decorate([
    prop_injectable_1.propertyInjectable
], AutoScalingConfiguration);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0by1zY2FsaW5nLWNvbmZpZ3VyYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhdXRvLXNjYWxpbmctY29uZmlndXJhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7QUFBQSx3Q0FBd0M7QUFFeEMsNkRBQXdFO0FBQ3hFLDhFQUE4RTtBQUM5RSwwRUFBMEU7QUFtRjFFOzs7O0dBSUc7QUFFSSxJQUFNLHdCQUF3QixHQUE5QixNQUFNLHdCQUF5QixTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBSXhEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHNDQUFzQyxDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUMvRSxLQUF5Qzs7Ozs7Ozs7OztRQUN6QyxNQUFNLDRCQUE0QixHQUFHLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQztRQUN4RSxNQUFNLGdDQUFnQyxHQUFHLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQztRQUVoRixNQUFNLE1BQU8sU0FBUSxHQUFHLENBQUMsUUFBUTtZQUFqQzs7Z0JBQ2tCLGlDQUE0QixHQUFHLDRCQUE0QixDQUFDO2dCQUM1RCxxQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztnQkFDcEUsZ0NBQTJCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUN6RSxRQUFRLEVBQUUsMEJBQTBCO29CQUNwQyxPQUFPLEVBQUUsV0FBVztvQkFDcEIsWUFBWSxFQUFFLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixJQUFJLEtBQUssQ0FBQyxnQ0FBZ0MsRUFBRTtpQkFDaEcsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsMkJBQW1DO1FBQ3JGLE1BQU0sYUFBYSxHQUFHLEdBQUcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSwyQkFBMkIsQ0FBQyxDQUFDO1FBRXJFLElBQUksQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUMvQyxNQUFNLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLDBCQUEwQiwyQkFBMkIsR0FBRyxDQUFDLENBQUM7UUFDbEcsQ0FBQztRQUVELE1BQU0sNEJBQTRCLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ3JFLE1BQU0sZ0NBQWdDLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRWpGLE1BQU0sTUFBTyxTQUFRLEdBQUcsQ0FBQyxRQUFRO1lBQWpDOztnQkFDa0IsaUNBQTRCLEdBQUcsNEJBQTRCLENBQUM7Z0JBQzVELHFDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO2dCQUNwRSxnQ0FBMkIsR0FBRywyQkFBMkIsQ0FBQztZQUM1RSxDQUFDO1NBQUE7UUFFRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQW9CRCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUF1QyxFQUFFO1FBQ3hGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyw0QkFBNEI7U0FDakQsQ0FBQyxDQUFDOzs7Ozs7K0NBcEVNLHdCQUF3Qjs7OztRQXFFakMsbUNBQW1DO1FBQ25DLElBQUEsd0NBQW9CLEVBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRWxDLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUU3QyxNQUFNLFFBQVEsR0FBRyxJQUFJLDJDQUEyQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDakUsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLDRCQUE0QjtZQUNoRSxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztTQUN2QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsMkJBQTJCLEdBQUcsUUFBUSxDQUFDLCtCQUErQixDQUFDO1FBQzVFLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxRQUFRLENBQUMsb0NBQW9DLENBQUM7UUFDdEYsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7S0FDbEQ7SUFFTyxnQ0FBZ0MsQ0FBQyxLQUFvQztRQUMzRSxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsS0FBSyxTQUFTLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsNEJBQTRCLENBQUMsRUFBRSxDQUFDO1lBQ3BILElBQUksS0FBSyxDQUFDLDRCQUE0QixDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLDRCQUE0QixDQUFDLE1BQU0sR0FBRyxFQUFFLEVBQUUsQ0FBQztnQkFDcEcsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzNCLDhFQUE4RSxLQUFLLENBQUMsNEJBQTRCLENBQUMsTUFBTSxjQUFjLEVBQUUsSUFBSSxDQUM1SSxDQUFDO1lBQ0osQ0FBQztZQUVELElBQUksQ0FBQyw4QkFBOEIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLDRCQUE0QixDQUFDLEVBQUUsQ0FBQztnQkFDN0UsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzNCLGlLQUFpSyxLQUFLLENBQUMsNEJBQTRCLEdBQUcsRUFBRSxJQUFJLENBQzdNLENBQUM7WUFDSixDQUFDO1FBQ0gsQ0FBQztRQUVELE1BQU0sZ0JBQWdCLEdBQUcsT0FBTyxLQUFLLENBQUMsT0FBTyxLQUFLLFFBQVEsQ0FBQztRQUMzRCxNQUFNLGdCQUFnQixHQUFHLE9BQU8sS0FBSyxDQUFDLE9BQU8sS0FBSyxRQUFRLENBQUM7UUFDM0QsTUFBTSx1QkFBdUIsR0FBRyxPQUFPLEtBQUssQ0FBQyxjQUFjLEtBQUssUUFBUSxDQUFDO1FBRXpFLElBQUksZ0JBQWdCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUM7WUFDbEUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMseUNBQXlDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNqRyxDQUFDO1FBRUQsSUFBSSxnQkFBZ0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsQ0FBQyxJQUFJLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFDLEVBQUUsQ0FBQztZQUNsRSxNQUFNLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyx5Q0FBeUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2pHLENBQUM7UUFFRCxJQUFJLGdCQUFnQixJQUFJLGdCQUFnQixJQUFJLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQzdFLE1BQU0sSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDLHVDQUF1QyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQy9FLENBQUM7UUFFRCxJQUFJLHVCQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLGNBQWMsR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLGNBQWMsR0FBRyxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ3hGLE1BQU0sSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDLGlEQUFpRCxLQUFLLENBQUMsY0FBYyxHQUFHLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDaEgsQ0FBQztLQUNGOztBQXhIVSw0REFBd0I7OztBQUNuQyxzQ0FBc0M7QUFDZiw4Q0FBcUIsR0FBVyx1REFBdUQsQUFBbEUsQ0FBbUU7bUNBRnBHLHdCQUF3QjtJQURwQyxvQ0FBa0I7R0FDTix3QkFBd0IsQ0F5SHBDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5BdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBwcnVubmVyJztcbmltcG9ydCB7IGFkZENvbnN0cnVjdE1ldGFkYXRhIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvbWV0YWRhdGEtcmVzb3VyY2UnO1xuaW1wb3J0IHsgcHJvcGVydHlJbmplY3RhYmxlIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvcHJvcC1pbmplY3RhYmxlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIHRoZSBBcHAgUnVubmVyIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9TY2FsaW5nQ29uZmlndXJhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIGZvciB0aGUgQXV0byBTY2FsaW5nIENvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYSBuYW1lIGdlbmVyYXRlZCBieSBDbG91ZEZvcm1hdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gbnVtYmVyIG9mIGNvbmN1cnJlbnQgcmVxdWVzdHMgdGhhdCBhbiBpbnN0YW5jZSBwcm9jZXNzZXMuXG4gICAqIElmIHRoZSBudW1iZXIgb2YgY29uY3VycmVudCByZXF1ZXN0cyBleGNlZWRzIHRoaXMgbGltaXQsIEFwcCBSdW5uZXIgc2NhbGVzIHRoZSBzZXJ2aWNlIHVwLlxuICAgKlxuICAgKiBNdXN0IGJlIGJldHdlZW4gMSBhbmQgMjAwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAxMDBcbiAgICovXG4gIHJlYWRvbmx5IG1heENvbmN1cnJlbmN5PzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYSBzZXJ2aWNlIHNjYWxlcyB1cCB0by5cbiAgICogQXQgbW9zdCBtYXhTaXplIGluc3RhbmNlcyBhY3RpdmVseSBzZXJ2ZSB0cmFmZmljIGZvciB5b3VyIHNlcnZpY2UuXG4gICAqXG4gICAqIE11c3QgYmUgYmV0d2VlbiAxIGFuZCAyNS5cbiAgICpcbiAgICogQGRlZmF1bHQgMjVcbiAgICovXG4gIHJlYWRvbmx5IG1heFNpemU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBtaW5pbXVtIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBBcHAgUnVubmVyIHByb3Zpc2lvbnMgZm9yIGEgc2VydmljZS5cbiAgICogVGhlIHNlcnZpY2UgYWx3YXlzIGhhcyBhdCBsZWFzdCBtaW5TaXplIHByb3Zpc2lvbmVkIGluc3RhbmNlcy5cbiAgICpcbiAgICpcbiAgICogTXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDI1LlxuICAgKlxuICAgKiBAZGVmYXVsdCAxXG4gICAqL1xuICByZWFkb25seSBtaW5TaXplPzogbnVtYmVyO1xufVxuXG4vKipcbiAqIEF0dHJpYnV0ZXMgZm9yIHRoZSBBcHAgUnVubmVyIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbkF0dHJpYnV0ZXMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmV2aXNpb24gb2YgdGhlIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb246IG51bWJlcjtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBBcHAgUnVubmVyIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElBdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24gZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm46IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIE5hbWUgb2YgdGhlIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZXZpc2lvbiBvZiB0aGUgQXV0byBTY2FsaW5nIENvbmZpZ3VyYXRpb24uXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvblJldmlzaW9uOiBudW1iZXI7XG59XG5cbi8qKlxuICogVGhlIEFwcCBSdW5uZXIgQXV0byBTY2FsaW5nIENvbmZpZ3VyYXRpb24uXG4gKlxuICogQHJlc291cmNlIEFXUzo6QXBwUnVubmVyOjpBdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25cbiAqL1xuQHByb3BlcnR5SW5qZWN0YWJsZVxuZXhwb3J0IGNsYXNzIEF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbiBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElBdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24ge1xuICAvKiogVW5pcXVlbHkgaWRlbnRpZmllcyB0aGlzIGNsYXNzLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBST1BFUlRZX0lOSkVDVElPTl9JRDogc3RyaW5nID0gJ0Bhd3MtY2RrLmF3cy1hcHBydW5uZXItYWxwaGEuQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uJztcblxuICAvKipcbiAgICogSW1wb3J0cyBhbiBBcHAgUnVubmVyIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uIGZyb20gYXR0cmlidXRlc1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLFxuICAgIGF0dHJzOiBBdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25BdHRyaWJ1dGVzKTogSUF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbiB7XG4gICAgY29uc3QgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZSA9IGF0dHJzLmF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWU7XG4gICAgY29uc3QgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb24gPSBhdHRycy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25SZXZpc2lvbjtcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElBdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24ge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWUgPSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvblJldmlzaW9uID0gYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb247XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXJuID0gY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgIHJlc291cmNlOiAnYXV0b3NjYWxpbmdjb25maWd1cmF0aW9uJyxcbiAgICAgICAgc2VydmljZTogJ2FwcHJ1bm5lcicsXG4gICAgICAgIHJlc291cmNlTmFtZTogYCR7YXR0cnMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZX0vJHthdHRycy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25SZXZpc2lvbn1gLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbXBvcnRzIGFuIEFwcCBSdW5uZXIgQXV0byBTY2FsaW5nIENvbmZpZ3VyYXRpb24gZnJvbSBpdHMgQVJOXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXJuOiBzdHJpbmcpOiBJQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uIHtcbiAgICBjb25zdCByZXNvdXJjZVBhcnRzID0gY2RrLkZuLnNwbGl0KCcvJywgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXJuKTtcblxuICAgIGlmICghcmVzb3VyY2VQYXJ0cyB8fCByZXNvdXJjZVBhcnRzLmxlbmd0aCA8IDMpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVW5zY29wZWRWYWxpZGF0aW9uRXJyb3IoYFVuZXhwZWN0ZWQgQVJOIGZvcm1hdDogJHthdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm59LmApO1xuICAgIH1cblxuICAgIGNvbnN0IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWUgPSBjZGsuRm4uc2VsZWN0KDAsIHJlc291cmNlUGFydHMpO1xuICAgIGNvbnN0IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvblJldmlzaW9uID0gTnVtYmVyKGNkay5Gbi5zZWxlY3QoMSwgcmVzb3VyY2VQYXJ0cykpO1xuXG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgY2RrLlJlc291cmNlIGltcGxlbWVudHMgSUF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbiB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZSA9IGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWU7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb24gPSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25SZXZpc2lvbjtcbiAgICAgIHB1YmxpYyByZWFkb25seSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm4gPSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm47XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBBdXRvIFNjYWxpbmcgQ29uZmlndXJhdGlvbi5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBBdXRvIFNjYWxpbmcgQ29uZmlndXJhdGlvbi5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmV2aXNpb24gb2YgdGhlIEF1dG8gU2NhbGluZyBDb25maWd1cmF0aW9uLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25SZXZpc2lvbjogbnVtYmVyO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lLFxuICAgIH0pO1xuICAgIC8vIEVuaGFuY2VkIENESyBBbmFseXRpY3MgVGVsZW1ldHJ5XG4gICAgYWRkQ29uc3RydWN0TWV0YWRhdGEodGhpcywgcHJvcHMpO1xuXG4gICAgdGhpcy52YWxpZGF0ZUF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbihwcm9wcyk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5BdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24odGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZTogcHJvcHMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZSxcbiAgICAgIG1heENvbmN1cnJlbmN5OiBwcm9wcy5tYXhDb25jdXJyZW5jeSxcbiAgICAgIG1heFNpemU6IHByb3BzLm1heFNpemUsXG4gICAgICBtaW5TaXplOiBwcm9wcy5taW5TaXplLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm4gPSByZXNvdXJjZS5hdHRyQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uQXJuO1xuICAgIHRoaXMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb24gPSByZXNvdXJjZS5hdHRyQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUmV2aXNpb247XG4gICAgdGhpcy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lID0gcmVzb3VyY2UucmVmO1xuICB9XG5cbiAgcHJpdmF0ZSB2YWxpZGF0ZUF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbihwcm9wczogQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uUHJvcHMpIHtcbiAgICBpZiAocHJvcHMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZSAhPT0gdW5kZWZpbmVkICYmICFjZGsuVG9rZW4uaXNVbnJlc29sdmVkKHByb3BzLmF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWUpKSB7XG4gICAgICBpZiAocHJvcHMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZS5sZW5ndGggPCA0IHx8IHByb3BzLmF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWUubGVuZ3RoID4gMzIpIHtcbiAgICAgICAgdGhyb3cgbmV3IGNkay5WYWxpZGF0aW9uRXJyb3IoXG4gICAgICAgICAgYFxcYGF1dG9TY2FsaW5nQ29uZmlndXJhdGlvbk5hbWVcXGAgbXVzdCBiZSBiZXR3ZWVuIDQgYW5kIDMyIGNoYXJhY3RlcnMsIGdvdDogJHtwcm9wcy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lLmxlbmd0aH0gY2hhcmFjdGVycy5gLCB0aGlzLFxuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICBpZiAoIS9eW0EtWmEtejAtOV1bQS1aYS16MC05XFwtX10qJC8udGVzdChwcm9wcy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25OYW1lKSkge1xuICAgICAgICB0aHJvdyBuZXcgY2RrLlZhbGlkYXRpb25FcnJvcihcbiAgICAgICAgICBgXFxgYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZVxcYCBtdXN0IHN0YXJ0IHdpdGggYW4gYWxwaGFudW1lcmljIGNoYXJhY3RlciBhbmQgY29udGFpbiBvbmx5IGFscGhhbnVtZXJpYyBjaGFyYWN0ZXJzLCBoeXBoZW5zLCBvciB1bmRlcnNjb3JlcyBhZnRlciB0aGF0LCBnb3Q6ICR7cHJvcHMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uTmFtZX0uYCwgdGhpcyxcbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBjb25zdCBpc01pblNpemVEZWZpbmVkID0gdHlwZW9mIHByb3BzLm1pblNpemUgPT09ICdudW1iZXInO1xuICAgIGNvbnN0IGlzTWF4U2l6ZURlZmluZWQgPSB0eXBlb2YgcHJvcHMubWF4U2l6ZSA9PT0gJ251bWJlcic7XG4gICAgY29uc3QgaXNNYXhDb25jdXJyZW5jeURlZmluZWQgPSB0eXBlb2YgcHJvcHMubWF4Q29uY3VycmVuY3kgPT09ICdudW1iZXInO1xuXG4gICAgaWYgKGlzTWluU2l6ZURlZmluZWQgJiYgKHByb3BzLm1pblNpemUgPCAxIHx8IHByb3BzLm1pblNpemUgPiAyNSkpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKGBtaW5TaXplIG11c3QgYmUgYmV0d2VlbiAxIGFuZCAyNSwgZ290ICR7cHJvcHMubWluU2l6ZX0uYCwgdGhpcyk7XG4gICAgfVxuXG4gICAgaWYgKGlzTWF4U2l6ZURlZmluZWQgJiYgKHByb3BzLm1heFNpemUgPCAxIHx8IHByb3BzLm1heFNpemUgPiAyNSkpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKGBtYXhTaXplIG11c3QgYmUgYmV0d2VlbiAxIGFuZCAyNSwgZ290ICR7cHJvcHMubWF4U2l6ZX0uYCwgdGhpcyk7XG4gICAgfVxuXG4gICAgaWYgKGlzTWluU2l6ZURlZmluZWQgJiYgaXNNYXhTaXplRGVmaW5lZCAmJiAhKHByb3BzLm1pblNpemUgPCBwcm9wcy5tYXhTaXplKSkge1xuICAgICAgdGhyb3cgbmV3IGNkay5WYWxpZGF0aW9uRXJyb3IoJ21heFNpemUgbXVzdCBiZSBncmVhdGVyIHRoYW4gbWluU2l6ZS4nLCB0aGlzKTtcbiAgICB9XG5cbiAgICBpZiAoaXNNYXhDb25jdXJyZW5jeURlZmluZWQgJiYgKHByb3BzLm1heENvbmN1cnJlbmN5IDwgMSB8fCBwcm9wcy5tYXhDb25jdXJyZW5jeSA+IDIwMCkpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKGBtYXhDb25jdXJyZW5jeSBtdXN0IGJlIGJldHdlZW4gMSBhbmQgMjAwLCBnb3QgJHtwcm9wcy5tYXhDb25jdXJyZW5jeX0uYCwgdGhpcyk7XG4gICAgfVxuICB9XG59XG4iXX0=