"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservabilityConfiguration = exports.TraceConfigurationVendor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The implementation provider chosen for tracing App Runner services
 *
 * @see https://docs.aws.amazon.com/apprunner/latest/dg/monitor.html
 */
var TraceConfigurationVendor;
(function (TraceConfigurationVendor) {
    /**
     * Tracing (X-Ray)
     */
    TraceConfigurationVendor["AWSXRAY"] = "AWSXRAY";
})(TraceConfigurationVendor || (exports.TraceConfigurationVendor = TraceConfigurationVendor = {}));
/**
 * The App Runner Observability configuration
 *
 * @resource AWS::AppRunner::ObservabilityConfiguration
 */
let ObservabilityConfiguration = class ObservabilityConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Observability Configuration from attributes.
     */
    static fromObservabilityConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObservabilityConfigurationAttributes);
            }
            throw error;
        }
        const observabilityConfigurationName = attrs.observabilityConfigurationName;
        const observabilityConfigurationRevision = attrs.observabilityConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'observabilityconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.observabilityConfigurationName}/${attrs.observabilityConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Observability Configuration from its ARN
     */
    static fromArn(scope, id, observabilityConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', observabilityConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new cdk.UnscopedValidationError(`Unexpected ARN format: ${observabilityConfigurationArn}.`);
        }
        const observabilityConfigurationName = cdk.Fn.select(0, resourceParts);
        const observabilityConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = observabilityConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.observabilityConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ObservabilityConfiguration);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.observabilityConfigurationName !== undefined && !cdk.Token.isUnresolved(props.observabilityConfigurationName)) {
            if (props.observabilityConfigurationName.length < 4 || props.observabilityConfigurationName.length > 32) {
                throw new cdk.ValidationError(`\`observabilityConfigurationName\` must be between 4 and 32 characters, got: ${props.observabilityConfigurationName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.observabilityConfigurationName)) {
                throw new cdk.ValidationError(`\`observabilityConfigurationName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.observabilityConfigurationName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnObservabilityConfiguration(this, 'Resource', {
            observabilityConfigurationName: props.observabilityConfigurationName,
            traceConfiguration: {
                vendor: props.traceConfigurationVendor,
            },
        });
        this.observabilityConfigurationArn = resource.attrObservabilityConfigurationArn;
        this.observabilityConfigurationRevision = resource.attrObservabilityConfigurationRevision;
        this.observabilityConfigurationName = resource.ref;
    }
};
exports.ObservabilityConfiguration = ObservabilityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
ObservabilityConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.ObservabilityConfiguration", version: "2.211.0-alpha.0" };
/** Uniquely identifies this class. */
ObservabilityConfiguration.PROPERTY_INJECTION_ID = '@aws-cdk.aws-apprunner-alpha.ObservabilityConfiguration';
exports.ObservabilityConfiguration = ObservabilityConfiguration = __decorate([
    prop_injectable_1.propertyInjectable
], ObservabilityConfiguration);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2JzZXJ2YWJpbGl0eS1jb25maWd1cmF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib2JzZXJ2YWJpbGl0eS1jb25maWd1cmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7OztBQUFBLHdDQUF3QztBQUV4Qyw2REFBMEU7QUFDMUUsOEVBQThFO0FBQzlFLDBFQUEwRTtBQUUxRTs7OztHQUlHO0FBQ0gsSUFBWSx3QkFLWDtBQUxELFdBQVksd0JBQXdCO0lBQ2xDOztPQUVHO0lBQ0gsK0NBQW1CLENBQUE7QUFDckIsQ0FBQyxFQUxXLHdCQUF3Qix3Q0FBeEIsd0JBQXdCLFFBS25DO0FBeUREOzs7O0dBSUc7QUFFSSxJQUFNLDBCQUEwQixHQUFoQyxNQUFNLDBCQUEyQixTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBSTFEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHdDQUF3QyxDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUNqRixLQUEyQzs7Ozs7Ozs7OztRQUMzQyxNQUFNLDhCQUE4QixHQUFHLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQztRQUM1RSxNQUFNLGtDQUFrQyxHQUFHLEtBQUssQ0FBQyxrQ0FBa0MsQ0FBQztRQUVwRixNQUFNLE1BQU8sU0FBUSxHQUFHLENBQUMsUUFBUTtZQUFqQzs7Z0JBQ2tCLG1DQUE4QixHQUFHLDhCQUE4QixDQUFDO2dCQUNoRSx1Q0FBa0MsR0FBRyxrQ0FBa0MsQ0FBQztnQkFDeEUsa0NBQTZCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUMzRSxRQUFRLEVBQUUsNEJBQTRCO29CQUN0QyxPQUFPLEVBQUUsV0FBVztvQkFDcEIsWUFBWSxFQUFFLEdBQUcsS0FBSyxDQUFDLDhCQUE4QixJQUFJLEtBQUssQ0FBQyxrQ0FBa0MsRUFBRTtpQkFDcEcsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsNkJBQXFDO1FBQ3ZGLE1BQU0sYUFBYSxHQUFHLEdBQUcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSw2QkFBNkIsQ0FBQyxDQUFDO1FBRXZFLElBQUksQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUMvQyxNQUFNLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLDBCQUEwQiw2QkFBNkIsR0FBRyxDQUFDLENBQUM7UUFDcEcsQ0FBQztRQUVELE1BQU0sOEJBQThCLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ3ZFLE1BQU0sa0NBQWtDLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRW5GLE1BQU0sTUFBTyxTQUFRLEdBQUcsQ0FBQyxRQUFRO1lBQWpDOztnQkFDa0IsbUNBQThCLEdBQUcsOEJBQThCLENBQUM7Z0JBQ2hFLHVDQUFrQyxHQUFHLGtDQUFrQyxDQUFDO2dCQUN4RSxrQ0FBNkIsR0FBRyw2QkFBNkIsQ0FBQztZQUNoRixDQUFDO1NBQUE7UUFFRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQW9CRCxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQztRQUNyRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsOEJBQThCO1NBQ25ELENBQUMsQ0FBQzs7Ozs7OytDQXBFTSwwQkFBMEI7Ozs7UUFxRW5DLG1DQUFtQztRQUNuQyxJQUFBLHdDQUFvQixFQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztRQUVsQyxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsS0FBSyxTQUFTLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsOEJBQThCLENBQUMsRUFBRSxDQUFDO1lBQ3hILElBQUksS0FBSyxDQUFDLDhCQUE4QixDQUFDLE1BQU0sR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLDhCQUE4QixDQUFDLE1BQU0sR0FBRyxFQUFFLEVBQUUsQ0FBQztnQkFDeEcsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzNCLGdGQUFnRixLQUFLLENBQUMsOEJBQThCLENBQUMsTUFBTSxjQUFjLEVBQUUsSUFBSSxDQUNoSixDQUFDO1lBQ0osQ0FBQztZQUVELElBQUksQ0FBQyw4QkFBOEIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLDhCQUE4QixDQUFDLEVBQUUsQ0FBQztnQkFDL0UsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzNCLG1LQUFtSyxLQUFLLENBQUMsOEJBQThCLEdBQUcsRUFBRSxJQUFJLENBQ2pOLENBQUM7WUFDSixDQUFDO1FBQ0gsQ0FBQztRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksNkNBQTZCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuRSw4QkFBOEIsRUFBRSxLQUFLLENBQUMsOEJBQThCO1lBQ3BFLGtCQUFrQixFQUFFO2dCQUNsQixNQUFNLEVBQUUsS0FBSyxDQUFDLHdCQUF3QjthQUN2QztTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyw2QkFBNkIsR0FBRyxRQUFRLENBQUMsaUNBQWlDLENBQUM7UUFDaEYsSUFBSSxDQUFDLGtDQUFrQyxHQUFHLFFBQVEsQ0FBQyxzQ0FBc0MsQ0FBQztRQUMxRixJQUFJLENBQUMsOEJBQThCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztLQUNwRDs7QUFoR1UsZ0VBQTBCOzs7QUFDckMsc0NBQXNDO0FBQ2YsZ0RBQXFCLEdBQVcseURBQXlELEFBQXBFLENBQXFFO3FDQUZ0RywwQkFBMEI7SUFEdEMsb0NBQWtCO0dBQ04sMEJBQTBCLENBaUd0QyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBwcnVubmVyJztcbmltcG9ydCB7IGFkZENvbnN0cnVjdE1ldGFkYXRhIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvbWV0YWRhdGEtcmVzb3VyY2UnO1xuaW1wb3J0IHsgcHJvcGVydHlJbmplY3RhYmxlIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvcHJvcC1pbmplY3RhYmxlJztcblxuLyoqXG4gKiBUaGUgaW1wbGVtZW50YXRpb24gcHJvdmlkZXIgY2hvc2VuIGZvciB0cmFjaW5nIEFwcCBSdW5uZXIgc2VydmljZXNcbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBydW5uZXIvbGF0ZXN0L2RnL21vbml0b3IuaHRtbFxuICovXG5leHBvcnQgZW51bSBUcmFjZUNvbmZpZ3VyYXRpb25WZW5kb3Ige1xuICAvKipcbiAgICogVHJhY2luZyAoWC1SYXkpXG4gICAqL1xuICBBV1NYUkFZID0gJ0FXU1hSQVknLFxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgb2YgdGhlIEFwcFJ1bm5lciBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIGZvciB0aGUgT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYSBuYW1lIGdlbmVyYXRlZCBieSBDbG91ZEZvcm1hdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgaW1wbGVtZW50YXRpb24gcHJvdmlkZXIgY2hvc2VuIGZvciB0cmFjaW5nIEFwcCBSdW5uZXIgc2VydmljZXMuXG4gICAqL1xuICByZWFkb25seSB0cmFjZUNvbmZpZ3VyYXRpb25WZW5kb3I6IFRyYWNlQ29uZmlndXJhdGlvblZlbmRvcjtcbn1cblxuLyoqXG4gKiBBdHRyaWJ1dGVzIGZvciB0aGUgQXBwIFJ1bm5lciBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbkF0dHJpYnV0ZXMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIE9ic2VydmFiaWxpdHkgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmV2aXNpb24gb2YgdGhlIE9ic2VydmFiaWxpdHkgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uUmV2aXNpb246IG51bWJlcjtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBBcHAgUnVubmVyIE9ic2VydmFiaWxpdHkgY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24gZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBOYW1lIG9mIHRoZSBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb24uXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb24uXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZXZpc2lvbiBvZiB0aGUgT2JzZXJ2YWJpbGl0eSBjb25maWd1cmF0aW9uLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uOiBudW1iZXI7XG59XG5cbi8qKlxuICogVGhlIEFwcCBSdW5uZXIgT2JzZXJ2YWJpbGl0eSBjb25maWd1cmF0aW9uXG4gKlxuICogQHJlc291cmNlIEFXUzo6QXBwUnVubmVyOjpPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblxuICovXG5AcHJvcGVydHlJbmplY3RhYmxlXG5leHBvcnQgY2xhc3MgT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24gZXh0ZW5kcyBjZGsuUmVzb3VyY2UgaW1wbGVtZW50cyBJT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24ge1xuICAvKiogVW5pcXVlbHkgaWRlbnRpZmllcyB0aGlzIGNsYXNzLiAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBST1BFUlRZX0lOSkVDVElPTl9JRDogc3RyaW5nID0gJ0Bhd3MtY2RrLmF3cy1hcHBydW5uZXItYWxwaGEuT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24nO1xuXG4gIC8qKlxuICAgKiBJbXBvcnRzIGFuIEFwcCBSdW5uZXIgT2JzZXJ2YWJpbGl0eSBDb25maWd1cmF0aW9uIGZyb20gYXR0cmlidXRlcy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbU9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLFxuICAgIGF0dHJzOiBPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbkF0dHJpYnV0ZXMpOiBJT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24ge1xuICAgIGNvbnN0IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZSA9IGF0dHJzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZTtcbiAgICBjb25zdCBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uID0gYXR0cnMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25SZXZpc2lvbjtcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbiB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lID0gb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lO1xuICAgICAgcHVibGljIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uUmV2aXNpb24gPSBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uO1xuICAgICAgcHVibGljIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuID0gY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgIHJlc291cmNlOiAnb2JzZXJ2YWJpbGl0eWNvbmZpZ3VyYXRpb24nLFxuICAgICAgICBzZXJ2aWNlOiAnYXBwcnVubmVyJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiBgJHthdHRycy5vYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbk5hbWV9LyR7YXR0cnMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25SZXZpc2lvbn1gLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbXBvcnRzIGFuIEFwcCBSdW5uZXIgT2JzZXJ2YWJpbGl0eSBDb25maWd1cmF0aW9uIGZyb20gaXRzIEFSTlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQXJuKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuOiBzdHJpbmcpOiBJT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24ge1xuICAgIGNvbnN0IHJlc291cmNlUGFydHMgPSBjZGsuRm4uc3BsaXQoJy8nLCBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbkFybik7XG5cbiAgICBpZiAoIXJlc291cmNlUGFydHMgfHwgcmVzb3VyY2VQYXJ0cy5sZW5ndGggPCAzKSB7XG4gICAgICB0aHJvdyBuZXcgY2RrLlVuc2NvcGVkVmFsaWRhdGlvbkVycm9yKGBVbmV4cGVjdGVkIEFSTiBmb3JtYXQ6ICR7b2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25Bcm59LmApO1xuICAgIH1cblxuICAgIGNvbnN0IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZSA9IGNkay5Gbi5zZWxlY3QoMCwgcmVzb3VyY2VQYXJ0cyk7XG4gICAgY29uc3Qgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25SZXZpc2lvbiA9IE51bWJlcihjZGsuRm4uc2VsZWN0KDEsIHJlc291cmNlUGFydHMpKTtcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbiB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lID0gb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lO1xuICAgICAgcHVibGljIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uUmV2aXNpb24gPSBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uO1xuICAgICAgcHVibGljIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuID0gb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25Bcm47XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb24uXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZXZpc2lvbiBvZiB0aGUgT2JzZXJ2YWJpbGl0eSBjb25maWd1cmF0aW9uLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uOiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBPYnNlcnZhYmlsaXR5IGNvbmZpZ3VyYXRpb24uXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZTogc3RyaW5nO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5vYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbk5hbWUsXG4gICAgfSk7XG4gICAgLy8gRW5oYW5jZWQgQ0RLIEFuYWx5dGljcyBUZWxlbWV0cnlcbiAgICBhZGRDb25zdHJ1Y3RNZXRhZGF0YSh0aGlzLCBwcm9wcyk7XG5cbiAgICBpZiAocHJvcHMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lICE9PSB1bmRlZmluZWQgJiYgIWNkay5Ub2tlbi5pc1VucmVzb2x2ZWQocHJvcHMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lKSkge1xuICAgICAgaWYgKHByb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZS5sZW5ndGggPCA0IHx8IHByb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZS5sZW5ndGggPiAzMikge1xuICAgICAgICB0aHJvdyBuZXcgY2RrLlZhbGlkYXRpb25FcnJvcihcbiAgICAgICAgICBgXFxgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lXFxgIG11c3QgYmUgYmV0d2VlbiA0IGFuZCAzMiBjaGFyYWN0ZXJzLCBnb3Q6ICR7cHJvcHMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lLmxlbmd0aH0gY2hhcmFjdGVycy5gLCB0aGlzLFxuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICBpZiAoIS9eW0EtWmEtejAtOV1bQS1aYS16MC05XFwtX10qJC8udGVzdChwcm9wcy5vYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbk5hbWUpKSB7XG4gICAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKFxuICAgICAgICAgIGBcXGBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbk5hbWVcXGAgbXVzdCBzdGFydCB3aXRoIGFuIGFscGhhbnVtZXJpYyBjaGFyYWN0ZXIgYW5kIGNvbnRhaW4gb25seSBhbHBoYW51bWVyaWMgY2hhcmFjdGVycywgaHlwaGVucywgb3IgdW5kZXJzY29yZXMgYWZ0ZXIgdGhhdCwgZ290OiAke3Byb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZX0uYCwgdGhpcyxcbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5PYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbk5hbWU6IHByb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uTmFtZSxcbiAgICAgIHRyYWNlQ29uZmlndXJhdGlvbjoge1xuICAgICAgICB2ZW5kb3I6IHByb3BzLnRyYWNlQ29uZmlndXJhdGlvblZlbmRvcixcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuID0gcmVzb3VyY2UuYXR0ck9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuO1xuICAgIHRoaXMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25SZXZpc2lvbiA9IHJlc291cmNlLmF0dHJPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvblJldmlzaW9uO1xuICAgIHRoaXMub2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25OYW1lID0gcmVzb3VyY2UucmVmO1xuICB9XG59XG4iXX0=