"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.IpAddressType = exports.HealthCheck = exports.HealthCheckProtocolType = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib/core");
const core_1 = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType || (exports.ImageRepositoryType = ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) {
        const numericPatterns = ['256', '512', '1024', '2048', '4096'];
        const unitPatterns = ['0.25 vCPU', '0.5 vCPU', '1 vCPU', '2 vCPU', '4 vCPU'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new cdk.UnscopedValidationError('CPU value is invalid');
        }
        return new Cpu(unit);
    }
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.211.0-alpha.0" };
/**
 * 0.25 vCPU
 */
Cpu.QUARTER_VCPU = Cpu.of('0.25 vCPU');
/**
 * 0.5 vCPU
 */
Cpu.HALF_VCPU = Cpu.of('0.5 vCPU');
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * 4 vCPU
 */
Cpu.FOUR_VCPU = Cpu.of('4 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) {
        const numericPatterns = ['512', '1024', '2048', '3072', '4096', '6144', '8192', '10240', '12288'];
        const unitPatterns = ['0.5 GB', '1 GB', '2 GB', '3 GB', '4 GB', '6 GB', '8 GB', '10 GB', '12 GB'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new cdk.UnscopedValidationError('Memory value is invalid');
        }
        return new Memory(unit);
    }
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.211.0-alpha.0" };
/**
 * 0.5 GB(for 0.25 vCPU)
 */
Memory.HALF_GB = Memory.of('0.5 GB');
/**
 * 1 GB(for 0.25 or 0.5 vCPU)
 */
Memory.ONE_GB = Memory.of('1 GB');
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * 6 GB(for 2 vCPU)
 */
Memory.SIX_GB = Memory.of('6 GB');
/**
 * 8 GB(for 4 vCPU)
 */
Memory.EIGHT_GB = Memory.of('8 GB');
/**
 * 10 GB(for 4 vCPU)
 */
Memory.TEN_GB = Memory.of('10 GB');
/**
 * 12 GB(for 4 vCPU)
 */
Memory.TWELVE_GB = Memory.of('12 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.211.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * NodeJS 18
 */
Runtime.NODEJS_18 = Runtime.of('NODEJS_18');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Python 3.11
 */
Runtime.PYTHON_311 = Runtime.of('PYTHON_311');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * NodeJS 22
 */
Runtime.NODEJS_22 = Runtime.of('NODEJS_22');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.211.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.211.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.211.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.211.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.211.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType || (exports.ConfigurationSourceType = ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
    constructor(arn) {
        this.connectionArn = arn;
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.211.0-alpha.0" };
/**
 * The health check protocol type
 */
var HealthCheckProtocolType;
(function (HealthCheckProtocolType) {
    /**
     * HTTP protocol
     */
    HealthCheckProtocolType["HTTP"] = "HTTP";
    /**
     * TCP protocol
     */
    HealthCheckProtocolType["TCP"] = "TCP";
})(HealthCheckProtocolType || (exports.HealthCheckProtocolType = HealthCheckProtocolType = {}));
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.HTTP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold, options.path);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.TCP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold);
    }
    constructor(healthCheckProtocolType, healthyThreshold = 1, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), unhealthyThreshold = 5, path) {
        this.healthCheckProtocolType = healthCheckProtocolType;
        this.healthyThreshold = healthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.unhealthyThreshold = unhealthyThreshold;
        this.path = path;
        if (this.healthCheckProtocolType === HealthCheckProtocolType.HTTP) {
            if (this.path !== undefined && this.path.length === 0) {
                throw new cdk.UnscopedValidationError('path length must be greater than 0');
            }
            if (this.path === undefined) {
                this.path = '/';
            }
        }
        if (this.healthyThreshold < 1 || this.healthyThreshold > 20) {
            throw new cdk.UnscopedValidationError(`healthyThreshold must be between 1 and 20, got ${this.healthyThreshold}`);
        }
        if (this.unhealthyThreshold < 1 || this.unhealthyThreshold > 20) {
            throw new cdk.UnscopedValidationError(`unhealthyThreshold must be between 1 and 20, got ${this.unhealthyThreshold}`);
        }
        if (this.interval.toSeconds() < 1 || this.interval.toSeconds() > 20) {
            throw new cdk.UnscopedValidationError(`interval must be between 1 and 20 seconds, got ${this.interval.toSeconds()}`);
        }
        if (this.timeout.toSeconds() < 1 || this.timeout.toSeconds() > 20) {
            throw new cdk.UnscopedValidationError(`timeout must be between 1 and 20 seconds, got ${this.timeout.toSeconds()}`);
        }
    }
    bind() {
        return {
            healthyThreshold: this.healthyThreshold,
            interval: this.interval?.toSeconds(),
            path: this.path,
            protocol: this.healthCheckProtocolType,
            timeout: this.timeout?.toSeconds(),
            unhealthyThreshold: this.unhealthyThreshold,
        };
    }
}
exports.HealthCheck = HealthCheck;
_k = JSII_RTTI_SYMBOL_1;
HealthCheck[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.HealthCheck", version: "2.211.0-alpha.0" };
/**
 * The IP address type for your incoming public network configuration.
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * IPV4
     */
    IpAddressType["IPV4"] = "IPV4";
    /**
     * DUAL_STACK
     */
    IpAddressType["DUAL_STACK"] = "DUAL_STACK";
})(IpAddressType || (exports.IpAddressType = IpAddressType = {}));
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_l = JSII_RTTI_SYMBOL_1;
Secret[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.211.0-alpha.0" };
/**
 * The App Runner Service.
 */
let Service = class Service extends cdk.Resource {
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole ?? this.createInstanceRole();
        this.grantPrincipal = this.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new cdk.ValidationError('configurationValues cannot be provided if the ConfigurationSource is Repository', this);
        }
        if (props.serviceName !== undefined && !cdk.Token.isUnresolved(props.serviceName)) {
            if (props.serviceName.length < 4 || props.serviceName.length > 40) {
                throw new cdk.ValidationError(`\`serviceName\` must be between 4 and 40 characters, got: ${props.serviceName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.serviceName)) {
                throw new cdk.ValidationError(`\`serviceName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.serviceName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            serviceName: this.props.serviceName,
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: core_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                autoDeploymentsEnabled: this.props.autoDeploymentsEnabled,
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            encryptionConfiguration: this.props.kmsKey ? {
                kmsKey: this.props.kmsKey.keyArn,
            } : undefined,
            autoScalingConfigurationArn: this.props.autoScalingConfiguration?.autoScalingConfigurationArn,
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
                ingressConfiguration: props.isPubliclyAccessible !== undefined ? { isPubliclyAccessible: props.isPubliclyAccessible } : undefined,
                ipAddressType: this.props.ipAddressType,
            },
            healthCheckConfiguration: this.props.healthCheck ?
                this.props.healthCheck.bind() :
                undefined,
            observabilityConfiguration: props.observabilityConfiguration ? {
                observabilityEnabled: true,
                observabilityConfigurationArn: props.observabilityConfiguration.observabilityConfigurationArn,
            } : undefined,
        });
        // grant required privileges for the role to access an image in Amazon ECR
        // See https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
            this.source.ecrRepository.grant(this.accessRole, 'ecr:DescribeImages');
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        /**
         * Cloudformaton does not return the serviceName attribute so we extract it from the serviceArn.
         * The ARN comes with this format:
         * arn:aws:apprunner:us-east-1:123456789012:service/SERVICE_NAME/SERVICE_ID
         */
        // First, get the last element by splitting with ':'
        const resourceFullName = cdk.Fn.select(5, cdk.Fn.split(':', this.serviceArn));
        // Now, split the resourceFullName with '/' to get the serviceName
        this.serviceName = cdk.Fn.select(1, cdk.Fn.split('/', resourceFullName));
    }
    /**
     * Adds a statement to the instance role.
     */
    addToRolePolicy(statement) {
        this.instanceRole.addToPrincipalPolicy(statement);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new cdk.ValidationError(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`, this);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new cdk.ValidationError(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`, this);
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new cdk.ValidationError([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '), this);
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
};
exports.Service = Service;
_m = JSII_RTTI_SYMBOL_1;
Service[_m] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.211.0-alpha.0" };
/** Uniquely identifies this class. */
Service.PROPERTY_INJECTION_ID = '@aws-cdk.aws-apprunner-alpha.Service';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addToRolePolicy", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addEnvironmentVariable", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addSecret", null);
exports.Service = Service = __decorate([
    prop_injectable_1.propertyInjectable
], Service);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7O0FBRUEsMkNBQTJDO0FBSTNDLHdDQUF3QztBQUN4QywyQ0FBd0M7QUFFeEMsNkRBQXVEO0FBSXZELDhFQUE4RjtBQUM5RiwwRUFBMEU7QUFFMUU7O0dBRUc7QUFDSCxJQUFZLG1CQVVYO0FBVkQsV0FBWSxtQkFBbUI7SUFDN0I7O09BRUc7SUFDSCxnREFBeUIsQ0FBQTtJQUV6Qjs7T0FFRztJQUNILGtDQUFXLENBQUE7QUFDYixDQUFDLEVBVlcsbUJBQW1CLG1DQUFuQixtQkFBbUIsUUFVOUI7QUFFRDs7O0dBR0c7QUFDSCxNQUFhLEdBQUc7SUEwQmQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLEVBQUUsQ0FBQyxJQUFZO1FBQzNCLE1BQU0sZUFBZSxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQy9ELE1BQU0sWUFBWSxHQUFHLENBQUMsV0FBVyxFQUFFLFVBQVUsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQzdFLE1BQU0sZUFBZSxHQUFHLGVBQWUsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDN0QsTUFBTSxZQUFZLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FDdkMsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLE9BQU8sS0FBSyxJQUFJLENBQzlCLENBQUM7UUFDRixJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDbEIsTUFBTSxJQUFJLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hFLENBQUM7UUFFRCxPQUFPLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3RCO0lBRUQ7OztPQUdHO0lBQ0gsWUFBb0MsSUFBWTtRQUFaLFNBQUksR0FBSixJQUFJLENBQVE7S0FBSzs7QUFuRHZELGtCQW9EQzs7O0FBbkRDOztHQUVHO0FBQ29CLGdCQUFZLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztBQUUxRDs7R0FFRztBQUNvQixhQUFTLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUV0RDs7R0FFRztBQUNvQixZQUFRLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUVuRDs7R0FFRztBQUNvQixZQUFRLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUVuRDs7R0FFRztBQUNvQixhQUFTLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQThCdEQ7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUE4Q2pCOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsSUFBWTtRQUMzQixNQUFNLGVBQWUsR0FBRyxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDbEcsTUFBTSxZQUFZLEdBQUcsQ0FBQyxRQUFRLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQ2xHLE1BQU0sZUFBZSxHQUFHLGVBQWUsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDN0QsTUFBTSxZQUFZLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FDdkMsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLE9BQU8sS0FBSyxJQUFJLENBQzlCLENBQUM7UUFDRixJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDbEIsTUFBTSxJQUFJLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1FBQ25FLENBQUM7UUFFRCxPQUFPLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ3pCO0lBRUQ7OztPQUdHO0lBQ0gsWUFBb0MsSUFBWTtRQUFaLFNBQUksR0FBSixJQUFJLENBQVE7S0FBSzs7QUF2RXZELHdCQXdFQzs7O0FBdkVDOztHQUVHO0FBQ29CLGNBQU8sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBRXJEOztHQUVHO0FBQ29CLGFBQU0sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRWxEOztHQUVHO0FBQ29CLGFBQU0sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRWxEOztHQUVHO0FBQ29CLGVBQVEsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRXBEOztHQUVHO0FBQ29CLGNBQU8sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRW5EOztHQUVHO0FBQ29CLGFBQU0sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRWxEOztHQUVHO0FBQ29CLGVBQVEsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRXBEOztHQUVHO0FBQ29CLGFBQU0sR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBRW5EOztHQUVHO0FBQ29CLGdCQUFTLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQztBQThCeEQ7O0dBRUc7QUFDSCxNQUFhLE9BQU87SUFrRWxCOzs7Ozs7O09BT0c7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLElBQVksSUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUU7SUFFNUQ7OztPQUdHO0lBQ0gsWUFBb0MsSUFBWTtRQUFaLFNBQUksR0FBSixJQUFJLENBQVE7S0FBSzs7QUFoRnZELDBCQWlGQzs7O0FBaEZDOztHQUVHO0FBQ29CLGtCQUFVLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUU3RDs7R0FFRztBQUNvQixtQkFBVyxHQUFHLE9BQU8sQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7QUFFL0Q7O0dBRUc7QUFDb0IsZ0JBQVEsR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0FBRXpEOztHQUVHO0FBQ29CLFlBQUksR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRWpEOztHQUVHO0FBQ29CLGlCQUFTLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztBQUUzRDs7R0FFRztBQUNvQixpQkFBUyxHQUFHLE9BQU8sQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7QUFFM0Q7O0dBRUc7QUFDb0IsaUJBQVMsR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0FBRTNEOztHQUVHO0FBQ29CLGlCQUFTLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztBQUUzRDs7R0FFRztBQUNvQixjQUFNLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUVyRDs7R0FFRztBQUNvQixnQkFBUSxHQUFHLE9BQU8sQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7QUFFekQ7O0dBRUc7QUFDb0Isa0JBQVUsR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLFlBQVksQ0FBQyxDQUFDO0FBRTdEOztHQUVHO0FBQ29CLGVBQU8sR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBRXZEOztHQUVHO0FBQ29CLGlCQUFTLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztBQWlMN0Q7O0dBRUc7QUFDSCxNQUFzQixNQUFNO0lBQzFCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUE0Qjs7Ozs7Ozs7OztRQUNuRCxPQUFPLElBQUksWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ2hDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQWU7Ozs7Ozs7Ozs7UUFDbkMsT0FBTyxJQUFJLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUM3QjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFxQjs7Ozs7Ozs7OztRQUMvQyxPQUFPLElBQUksZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ25DO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsU0FBUyxDQUFDLEtBQWlCOzs7Ozs7Ozs7O1FBQ3ZDLE9BQU8sSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDL0I7O0FBM0JILHdCQWlDQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxNQUFNO0lBRXRDLFlBQVksS0FBNEI7UUFDdEMsS0FBSyxFQUFFLENBQUM7Ozs7OzsrQ0FIQyxZQUFZOzs7O1FBSXJCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0tBQ3BCO0lBQ00sSUFBSSxDQUFDLE1BQWlCO1FBQzNCLE9BQU87WUFDTCxjQUFjLEVBQUU7Z0JBQ2QsaUJBQWlCLEVBQUU7b0JBQ2pCLG1CQUFtQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CO29CQUNuRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLHVCQUF1QjtpQkFDeEQ7Z0JBQ0QsYUFBYSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYTtnQkFDdkMsaUJBQWlCLEVBQUU7b0JBQ2pCLElBQUksRUFBRSxRQUFRO29CQUNkLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sSUFBSSxNQUFNO2lCQUNuQztnQkFDRCxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVO2FBQ2xDO1NBQ0YsQ0FBQztLQUNIOztBQXJCSCxvQ0FzQkM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsTUFBTTtJQUVuQyxZQUFZLEtBQWU7UUFDekIsS0FBSyxFQUFFLENBQUM7Ozs7OzsrQ0FIQyxTQUFTOzs7O1FBSWxCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0tBQ3BCO0lBQ00sSUFBSSxDQUFDLE1BQWlCO1FBQzNCLE9BQU87WUFDTCxlQUFlLEVBQUU7Z0JBQ2Ysa0JBQWtCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7Z0JBQ2pELGVBQWUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FDaEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLElBQUksUUFBUSxDQUNyRDtnQkFDRCxtQkFBbUIsRUFBRSxtQkFBbUIsQ0FBQyxHQUFHO2FBQzdDO1lBQ0QsYUFBYSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtTQUNyQyxDQUFDO0tBQ0g7O0FBakJILDhCQWtCQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsTUFBTTtJQUV6QyxZQUFZLEtBQXFCO1FBQy9CLEtBQUssRUFBRSxDQUFDOzs7Ozs7K0NBSEMsZUFBZTs7OztRQUl4QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztLQUNwQjtJQUNNLElBQUksQ0FBQyxNQUFpQjtRQUMzQixPQUFPO1lBQ0wsZUFBZSxFQUFFO2dCQUNmLGtCQUFrQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCO2dCQUNqRCxlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlO2dCQUMzQyxtQkFBbUIsRUFBRSxtQkFBbUIsQ0FBQyxVQUFVO2FBQ3BEO1NBQ0YsQ0FBQztLQUNIOztBQWRILDBDQWVDOzs7QUFFRDs7R0FFRztBQUNILE1BQWEsV0FBWSxTQUFRLE1BQU07SUFFckMsWUFBWSxLQUFpQjtRQUMzQixLQUFLLEVBQUUsQ0FBQzs7Ozs7OytDQUhDLFdBQVc7Ozs7UUFJcEIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7S0FDcEI7SUFDTSxJQUFJLENBQUMsTUFBaUI7UUFDM0IsT0FBTztZQUNMLGVBQWUsRUFBRTtnQkFDZixrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQjtnQkFDakQsZUFBZSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLFFBQVE7Z0JBQzFDLG1CQUFtQixFQUFFLG1CQUFtQixDQUFDLEdBQUc7YUFDN0M7WUFDRCxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsVUFBVTtTQUMzQyxDQUFDO0tBQ0g7O0FBZkgsa0NBZ0JDOzs7QUFvUEQ7O0dBRUc7QUFDSCxJQUFZLHVCQVlYO0FBWkQsV0FBWSx1QkFBdUI7SUFDakM7OztPQUdHO0lBQ0gsb0RBQXlCLENBQUE7SUFFekI7OztPQUdHO0lBQ0gsc0NBQVcsQ0FBQTtBQUNiLENBQUMsRUFaVyx1QkFBdUIsdUNBQXZCLHVCQUF1QixRQVlsQztBQXNHRDs7O0dBR0c7QUFDSCxNQUFhLGdCQUFnQjtJQUMzQjs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLGlCQUFpQixDQUFDLEdBQVc7UUFDekMsT0FBTyxJQUFJLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxDQUFDO0tBQ2xDO0lBTUQsWUFBWSxHQUFXO1FBQ3JCLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxDQUFDO0tBQzFCOztBQWhCSCw0Q0FpQkM7OztBQUVEOztHQUVHO0FBQ0gsSUFBWSx1QkFVWDtBQVZELFdBQVksdUJBQXVCO0lBQ2pDOztPQUVHO0lBQ0gsd0NBQWEsQ0FBQTtJQUViOztPQUVHO0lBQ0gsc0NBQVcsQ0FBQTtBQUNiLENBQUMsRUFWVyx1QkFBdUIsdUNBQXZCLHVCQUF1QixRQVVsQztBQW9ERDs7R0FFRztBQUNILE1BQWEsV0FBVztJQUN0Qjs7T0FFRztJQUNJLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBa0MsRUFBRTs7Ozs7Ozs7OztRQUNyRCxPQUFPLElBQUksV0FBVyxDQUNwQix1QkFBdUIsQ0FBQyxJQUFJLEVBQzVCLE9BQU8sQ0FBQyxnQkFBZ0IsRUFDeEIsT0FBTyxDQUFDLFFBQVEsRUFDaEIsT0FBTyxDQUFDLE9BQU8sRUFDZixPQUFPLENBQUMsa0JBQWtCLEVBQzFCLE9BQU8sQ0FBQyxJQUFJLENBQ2IsQ0FBQztLQUNIO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQWlDLEVBQUU7Ozs7Ozs7Ozs7UUFDbkQsT0FBTyxJQUFJLFdBQVcsQ0FDcEIsdUJBQXVCLENBQUMsR0FBRyxFQUMzQixPQUFPLENBQUMsZ0JBQWdCLEVBQ3hCLE9BQU8sQ0FBQyxRQUFRLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLEVBQ2YsT0FBTyxDQUFDLGtCQUFrQixDQUMzQixDQUFDO0tBQ0g7SUFFRCxZQUNrQix1QkFBZ0QsRUFDaEQsbUJBQTJCLENBQUMsRUFDNUIsV0FBeUIsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQ2hELFVBQXdCLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUMvQyxxQkFBNkIsQ0FBQyxFQUM5QixJQUFhO1FBTGIsNEJBQXVCLEdBQXZCLHVCQUF1QixDQUF5QjtRQUNoRCxxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQVk7UUFDNUIsYUFBUSxHQUFSLFFBQVEsQ0FBd0M7UUFDaEQsWUFBTyxHQUFQLE9BQU8sQ0FBd0M7UUFDL0MsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFZO1FBQzlCLFNBQUksR0FBSixJQUFJLENBQVM7UUFFN0IsSUFBSSxJQUFJLENBQUMsdUJBQXVCLEtBQUssdUJBQXVCLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDbEUsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztnQkFDdEQsTUFBTSxJQUFJLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO1lBQzlFLENBQUM7WUFDRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssU0FBUyxFQUFFLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxJQUFJLEdBQUcsR0FBRyxDQUFDO1lBQ2xCLENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxFQUFFLEVBQUUsQ0FBQztZQUM1RCxNQUFNLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLGtEQUFrRCxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO1FBQ25ILENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLGtCQUFrQixHQUFHLEVBQUUsRUFBRSxDQUFDO1lBQ2hFLE1BQU0sSUFBSSxHQUFHLENBQUMsdUJBQXVCLENBQUMsb0RBQW9ELElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLENBQUM7UUFDdkgsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQztZQUNwRSxNQUFNLElBQUksR0FBRyxDQUFDLHVCQUF1QixDQUFDLGtEQUFrRCxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUN2SCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsRUFBRSxHQUFHLEVBQUUsRUFBRSxDQUFDO1lBQ2xFLE1BQU0sSUFBSSxHQUFHLENBQUMsdUJBQXVCLENBQUMsaURBQWlELElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3JILENBQUM7S0FDRjtJQUVNLElBQUk7UUFDVCxPQUFPO1lBQ0wsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLEVBQUU7WUFDcEMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsUUFBUSxFQUFFLElBQUksQ0FBQyx1QkFBdUI7WUFDdEMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPLEVBQUUsU0FBUyxFQUFFO1lBQ2xDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7U0FDNUMsQ0FBQztLQUNIOztBQXBFSCxrQ0FxRUM7OztBQUVEOztHQUVHO0FBQ0gsSUFBWSxhQVVYO0FBVkQsV0FBWSxhQUFhO0lBQ3ZCOztPQUVHO0lBQ0gsOEJBQWEsQ0FBQTtJQUViOztPQUVHO0lBQ0gsMENBQXlCLENBQUE7QUFDM0IsQ0FBQyxFQVZXLGFBQWEsNkJBQWIsYUFBYSxRQVV4QjtBQTJDRDs7R0FFRztBQUNILE1BQXNCLE1BQU07SUFDMUI7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLGdCQUFnQixDQUFDLFNBQXlCO1FBQ3RELE9BQU87WUFDTCxHQUFHLEVBQUUsU0FBUyxDQUFDLFlBQVk7WUFDM0IsU0FBUyxFQUFFLE9BQU8sQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUM7U0FDbkQsQ0FBQztLQUNIO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLGtCQUFrQixDQUFDLE1BQThCLEVBQUUsS0FBYztRQUM3RSxPQUFPO1lBQ0wsR0FBRyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLENBQUMsU0FBUyxJQUFJLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsU0FBUztZQUNoRSxRQUFRLEVBQUUsQ0FBQyxDQUFDLEtBQUs7WUFDakIsU0FBUyxFQUFFLE9BQU8sQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUM7U0FDaEQsQ0FBQztLQUNIO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxNQUE4QixFQUFFLFdBQThCLEVBQUUsS0FBYzs7Ozs7Ozs7OztRQUNwSCxPQUFPO1lBQ0wsR0FBRyxFQUFFLEdBQUcsTUFBTSxDQUFDLFNBQVMsSUFBSSxLQUFLLElBQUksRUFBRSxJQUFJLFdBQVcsQ0FBQyxZQUFZLElBQUksRUFBRSxJQUFJLFdBQVcsQ0FBQyxTQUFTLElBQUksRUFBRSxFQUFFO1lBQzFHLFFBQVEsRUFBRSxDQUFDLENBQUMsS0FBSztZQUNqQixTQUFTLEVBQUUsT0FBTyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQztTQUNoRCxDQUFDO0tBQ0g7O0FBL0NILHdCQStEQzs7O0FBRUQ7O0dBRUc7QUFFSSxJQUFNLE9BQU8sR0FBYixNQUFNLE9BQVEsU0FBUSxHQUFHLENBQUMsUUFBUTtJQUl2Qzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxlQUFlLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsV0FBbUI7UUFDN0UsTUFBTSxNQUFPLFNBQVEsR0FBRyxDQUFDLFFBQVE7WUFBakM7O2dCQUNTLGdCQUFXLEdBQUcsV0FBVyxDQUFDO2dCQUMxQixlQUFVLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUMvQyxRQUFRLEVBQUUsU0FBUztvQkFDbkIsT0FBTyxFQUFFLFdBQVc7b0JBQ3BCLFlBQVksRUFBRSxXQUFXO2lCQUMxQixDQUFDLENBQUM7WUFDTCxDQUFDO1NBQUE7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHFCQUFxQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCOzs7Ozs7Ozs7O1FBQ3hGLE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDcEMsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUN0QyxNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ3BDLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFFMUMsTUFBTSxNQUFPLFNBQVEsR0FBRyxDQUFDLFFBQVE7WUFBakM7O2dCQUNrQixlQUFVLEdBQUcsVUFBVSxDQUFDO2dCQUN4QixnQkFBVyxHQUFHLFdBQVcsQ0FBQztnQkFDMUIsZUFBVSxHQUFHLFVBQVUsQ0FBQztnQkFDeEIsa0JBQWEsR0FBRyxhQUFhLENBQUM7WUFDaEQsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7SUFxREQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQS9DbkI7Ozs7V0FJRztRQUNNLGdCQUFXLEdBQThCLEVBQUUsQ0FBQztRQUVyRDs7V0FFRztRQUNjLFlBQU8sR0FBd0IsRUFBRSxDQUFDO1FBRW5EOztXQUVHO1FBQ2MsY0FBUyxHQUEwQixFQUFFLENBQUM7Ozs7OzsrQ0ExRDVDLE9BQU87Ozs7UUEyRmhCLG1DQUFtQztRQUNuQyxJQUFBLHdDQUFvQixFQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztRQUVsQyxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN2QyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUVuQixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1FBQ3pFLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUV4QyxNQUFNLG9CQUFvQixHQUFHLElBQUksQ0FBQyx1QkFBdUIsRUFBRSxDQUFDO1FBQzVELE1BQU0sa0JBQWtCLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixFQUFFLENBQUM7UUFFeEQsS0FBSyxNQUFNLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsRUFBRSxDQUFDO1lBQ2hFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDMUMsQ0FBQztRQUNELEtBQUssTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLEVBQUUsQ0FBQztZQUM5RCxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUM3QixDQUFDO1FBRUQsOEZBQThGO1FBQzlGLElBQUksQ0FBQyxVQUFVLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxtQkFBbUIsSUFBSSxtQkFBbUIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQy9GLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7UUFFbEUsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRSxpQkFBaUIsQ0FBQyxtQkFBbUIsSUFBSSx1QkFBdUIsQ0FBQyxVQUFVO1lBQ3pHLElBQUksQ0FBQyxNQUFNLENBQUMsY0FBYyxFQUFFLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLENBQUM7WUFDcEUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsaUZBQWlGLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDekgsQ0FBQztRQUVELElBQUksS0FBSyxDQUFDLFdBQVcsS0FBSyxTQUFTLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQztZQUNsRixJQUFJLEtBQUssQ0FBQyxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsV0FBVyxDQUFDLE1BQU0sR0FBRyxFQUFFLEVBQUUsQ0FBQztnQkFDbEUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzNCLDZEQUE2RCxLQUFLLENBQUMsV0FBVyxDQUFDLE1BQU0sY0FBYyxFQUFFLElBQUksQ0FDMUcsQ0FBQztZQUNKLENBQUM7WUFFRCxJQUFJLENBQUMsOEJBQThCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDO2dCQUM1RCxNQUFNLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FDM0IsZ0pBQWdKLEtBQUssQ0FBQyxXQUFXLEdBQUcsRUFBRSxJQUFJLENBQzNLLENBQUM7WUFDSixDQUFDO1FBQ0gsQ0FBQztRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksMEJBQVUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2hELFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVc7WUFDbkMscUJBQXFCLEVBQUU7Z0JBQ3JCLEdBQUcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxJQUFJO2dCQUN6QixNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsSUFBSTtnQkFDL0IsZUFBZSxFQUFFLFdBQUksQ0FBQyxNQUFNLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRSxPQUFPLEVBQUUsQ0FBQzthQUM1RTtZQUNELG1CQUFtQixFQUFFO2dCQUNuQiwyQkFBMkIsRUFBRSxJQUFJLENBQUMsaUNBQWlDLEVBQUU7Z0JBQ3JFLHNCQUFzQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsc0JBQXNCO2dCQUN6RCxlQUFlLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQztvQkFDNUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZ0IsQ0FBQyxDQUFDLENBQUM7b0JBQzFELFNBQVM7Z0JBQ1gsY0FBYyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUM7b0JBQzFDLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWUsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBb0IsQ0FBQyxDQUFDLENBQUM7b0JBQ2xHLFNBQVM7YUFDWjtZQUNELHVCQUF1QixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztnQkFDM0MsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLE1BQU07YUFDakMsQ0FBQyxDQUFDLENBQUMsU0FBUztZQUNiLDJCQUEyQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsd0JBQXdCLEVBQUUsMkJBQTJCO1lBQzdGLG9CQUFvQixFQUFFO2dCQUNwQixtQkFBbUIsRUFBRTtvQkFDbkIsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFNBQVM7b0JBQ3ZELGVBQWUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxlQUFlO2lCQUMxRDtnQkFDRCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsb0JBQW9CLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0IsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUNqSSxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhO2FBQ3hDO1lBQ0Qsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQztnQkFDaEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztnQkFDL0IsU0FBUztZQUNYLDBCQUEwQixFQUFFLEtBQUssQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUM7Z0JBQzdELG9CQUFvQixFQUFFLElBQUk7Z0JBQzFCLDZCQUE2QixFQUFFLEtBQUssQ0FBQywwQkFBMEIsQ0FBQyw2QkFBNkI7YUFDOUYsQ0FBQyxDQUFDLENBQUMsU0FBUztTQUNkLENBQUMsQ0FBQztRQUVILDBFQUEwRTtRQUMxRSw2SEFBNkg7UUFDN0gsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDakQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBQ3pFLENBQUM7UUFFRCxJQUFJLENBQUMsVUFBVSxHQUFHLFFBQVEsQ0FBQyxjQUFjLENBQUM7UUFDMUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDO1FBQ3hDLElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLGNBQWMsQ0FBQztRQUMxQyxJQUFJLENBQUMsYUFBYSxHQUFHLFFBQVEsQ0FBQyxVQUFVLENBQUM7UUFDekM7Ozs7V0FJRztRQUNILG9EQUFvRDtRQUNwRCxNQUFNLGdCQUFnQixHQUFHLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7UUFDOUUsa0VBQWtFO1FBQ2xFLElBQUksQ0FBQyxXQUFXLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7S0FDMUU7SUFFRDs7T0FFRztJQUVJLGVBQWUsQ0FBQyxTQUE4QjtRQUNuRCxJQUFJLENBQUMsWUFBWSxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0tBQ25EO0lBRUQ7O09BRUc7SUFFSSxzQkFBc0IsQ0FBQyxJQUFZLEVBQUUsS0FBYTtRQUN2RCxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQztZQUNwQyxNQUFNLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQyw0QkFBNEIsSUFBSSwrQ0FBK0MsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN2SCxDQUFDO1FBQ0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO0tBQ25EO0lBRUQ7O09BRUc7SUFFSSxTQUFTLENBQUMsSUFBWSxFQUFFLE1BQWM7Ozs7Ozs7Ozs7UUFDM0MsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUM7WUFDcEMsTUFBTSxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsMEJBQTBCLElBQUksK0NBQStDLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDckgsQ0FBQztRQUNELE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUUsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7S0FDdEQ7SUFFRDs7O09BR0c7SUFDSyxrQkFBa0I7UUFDeEIsT0FBTyxJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUN4QyxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsK0JBQStCLENBQUM7WUFDcEUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxZQUFZLENBQUMsa0JBQWtCO1NBQzlDLENBQUMsQ0FBQztLQUNKO0lBRUQ7OztPQUdHO0lBQ0ssbUJBQW1CO1FBQ3pCLE1BQU0sVUFBVSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ2xELFNBQVMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQywrQkFBK0IsQ0FBQztTQUNyRSxDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsb0JBQW9CLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ3RELE9BQU8sRUFBRSxDQUFDLDJCQUEyQixDQUFDO1lBQ3RDLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztTQUNqQixDQUFDLENBQUMsQ0FBQztRQUNKLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDO1FBQzdCLE9BQU8sVUFBVSxDQUFDO0tBQ25CO0lBRU8scUJBQXFCO1FBQzNCLElBQUksT0FBTyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsY0FBYyxFQUFFLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLGtCQUFrQjtZQUNqRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxrQkFBa0IsRUFBRSxrQkFBa0IsQ0FBQztRQUV0RSxPQUFPLE9BQU8sSUFBSSxFQUFFLENBQUM7S0FDdEI7SUFFTyx1QkFBdUI7UUFDN0IsSUFBSSxPQUFPLEdBQUc7WUFDWixJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWMsRUFBRSxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxvQkFBb0I7WUFDdkYsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLEVBQUUsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsV0FBVztTQUMvRSxDQUFDO1FBQ0YsSUFBSSxRQUFRLEdBQUc7WUFDYixJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxrQkFBa0IsRUFBRSxvQkFBb0I7WUFDckUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsa0JBQWtCLEVBQUUsV0FBVztTQUM3RCxDQUFDO1FBRUYsSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxLQUFLLFNBQVMsQ0FBQyxJQUFJLFFBQVEsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEtBQUssU0FBUyxDQUFDLEVBQUUsQ0FBQztZQUNwRixNQUFNLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDNUIsOEVBQThFO2dCQUM5RSxxRUFBcUU7YUFDdEUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDckIsQ0FBQztRQUVELE9BQU8sT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsS0FBSyxTQUFTLENBQUMsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxLQUFLLFNBQVMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztLQUM1RjtJQUVPLGlDQUFpQztRQUN2QyxPQUFPO1lBQ0wsYUFBYSxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUUsT0FBTztZQUN2QyxhQUFhLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLEVBQUUsVUFBVSxFQUFFLGFBQWE7U0FDckUsQ0FBQztLQUNIO0lBRU8sdUJBQXVCLENBQUMsS0FBOEI7UUFDNUQsT0FBTztZQUNMLGlCQUFpQixFQUFFO2dCQUNqQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWUsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUI7Z0JBQ3RGLCtFQUErRTtnQkFDL0UsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFlLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztvQkFDMUYsSUFBSSxDQUFDLDZCQUE2QixDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7b0JBQzNDLFNBQVM7YUFDWjtZQUNELGFBQWEsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLGNBQWUsQ0FBQyxhQUFhO1lBQ3hELGlCQUFpQixFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsY0FBZSxDQUFDLGlCQUFpQjtTQUNqRSxDQUFDO0tBQ0g7SUFFTyw2QkFBNkIsQ0FBQyxLQUE4QjtRQUNsRSxPQUFPO1lBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJO1lBQzNCLDJCQUEyQixFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLDBCQUEwQixFQUFFLEVBQUUsQ0FBQztZQUMzRix5QkFBeUIsRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsRUFBRSxFQUFFLENBQUM7WUFDdkYsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1NBQ2pDLENBQUM7S0FDSDtJQUVPLDBCQUEwQjtRQUNoQyxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQzlCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUN4QixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sU0FBUyxDQUFDO1FBQ25CLENBQUM7S0FDRjtJQUVPLHdCQUF3QjtRQUM5QixJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDakQsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQ3RCLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxTQUFTLENBQUM7UUFDbkIsQ0FBQztLQUNGO0lBRU8scUJBQXFCLENBQUMsSUFBcUI7UUFDakQsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRTtZQUN6QixrQkFBa0IsRUFBRTtnQkFDbEIsSUFBSSxFQUFFLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFO2dCQUMvQyxZQUFZLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixFQUFFLFlBQVk7Z0JBQ25ELDJCQUEyQixFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLDBCQUEwQixFQUFFLEVBQUUsQ0FBQztnQkFDM0YseUJBQXlCLEVBQUUsV0FBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLEVBQUUsRUFBRSxDQUFDO2FBQ3hGO1NBQ0YsQ0FBQyxDQUFDO0tBQ0o7O0FBaFZVLDBCQUFPOzs7QUFDbEIsc0NBQXNDO0FBQ2YsNkJBQXFCLEdBQVcsc0NBQXNDLEFBQWpELENBQWtEO0FBb012RjtJQUROLElBQUEsa0NBQWMsR0FBRTs4Q0FHaEI7QUFNTTtJQUROLElBQUEsa0NBQWMsR0FBRTtxREFNaEI7QUFNTTtJQUROLElBQUEsa0NBQWMsR0FBRTt3Q0FPaEI7a0JBL05VLE9BQU87SUFEbkIsb0NBQWtCO0dBQ04sT0FBTyxDQWlWbkIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlY3IgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjcic7XG5pbXBvcnQgKiBhcyBhc3NldHMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjci1hc3NldHMnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMga21zIGZyb20gJ2F3cy1jZGstbGliL2F3cy1rbXMnO1xuaW1wb3J0ICogYXMgc2VjcmV0c21hbmFnZXIgZnJvbSAnYXdzLWNkay1saWIvYXdzLXNlY3JldHNtYW5hZ2VyJztcbmltcG9ydCAqIGFzIHNzbSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3NtJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IExhenkgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuU2VydmljZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcHBydW5uZXInO1xuaW1wb3J0IHsgSVZwY0Nvbm5lY3RvciB9IGZyb20gJy4vdnBjLWNvbm5lY3Rvcic7XG5pbXBvcnQgeyBJQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uIH0gZnJvbSAnLi9hdXRvLXNjYWxpbmctY29uZmlndXJhdGlvbic7XG5pbXBvcnQgeyBJT2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb24gfSBmcm9tICcuL29ic2VydmFiaWxpdHktY29uZmlndXJhdGlvbic7XG5pbXBvcnQgeyBhZGRDb25zdHJ1Y3RNZXRhZGF0YSwgTWV0aG9kTWV0YWRhdGEgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlL2xpYi9tZXRhZGF0YS1yZXNvdXJjZSc7XG5pbXBvcnQgeyBwcm9wZXJ0eUluamVjdGFibGUgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlL2xpYi9wcm9wLWluamVjdGFibGUnO1xuXG4vKipcbiAqIFRoZSBpbWFnZSByZXBvc2l0b3J5IHR5cGVzXG4gKi9cbmV4cG9ydCBlbnVtIEltYWdlUmVwb3NpdG9yeVR5cGUge1xuICAvKipcbiAgICogQW1hem9uIEVDUiBQdWJsaWNcbiAgICovXG4gIEVDUl9QVUJMSUMgPSAnRUNSX1BVQkxJQycsXG5cbiAgLyoqXG4gICAqIEFtYXpvbiBFQ1JcbiAgICovXG4gIEVDUiA9ICdFQ1InLFxufVxuXG4vKipcbiAqIFRoZSBudW1iZXIgb2YgQ1BVIHVuaXRzIHJlc2VydmVkIGZvciBlYWNoIGluc3RhbmNlIG9mIHlvdXIgQXBwIFJ1bm5lciBzZXJ2aWNlLlxuICpcbiAqL1xuZXhwb3J0IGNsYXNzIENwdSB7XG4gIC8qKlxuICAgKiAwLjI1IHZDUFVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUVVBUlRFUl9WQ1BVID0gQ3B1Lm9mKCcwLjI1IHZDUFUnKTtcblxuICAvKipcbiAgICogMC41IHZDUFVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgSEFMRl9WQ1BVID0gQ3B1Lm9mKCcwLjUgdkNQVScpO1xuXG4gIC8qKlxuICAgKiAxIHZDUFVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgT05FX1ZDUFUgPSBDcHUub2YoJzEgdkNQVScpO1xuXG4gIC8qKlxuICAgKiAyIHZDUFVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVFdPX1ZDUFUgPSBDcHUub2YoJzIgdkNQVScpO1xuXG4gIC8qKlxuICAgKiA0IHZDUFVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRk9VUl9WQ1BVID0gQ3B1Lm9mKCc0IHZDUFUnKTtcblxuICAvKipcbiAgICogQ3VzdG9tIENQVSB1bml0XG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBwcnVubmVyLXNlcnZpY2UtaW5zdGFuY2Vjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWFwcHJ1bm5lci1zZXJ2aWNlLWluc3RhbmNlY29uZmlndXJhdGlvbi1jcHVcbiAgICpcbiAgICogQHBhcmFtIHVuaXQgY3VzdG9tIENQVSB1bml0XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKHVuaXQ6IHN0cmluZyk6IENwdSB7XG4gICAgY29uc3QgbnVtZXJpY1BhdHRlcm5zID0gWycyNTYnLCAnNTEyJywgJzEwMjQnLCAnMjA0OCcsICc0MDk2J107XG4gICAgY29uc3QgdW5pdFBhdHRlcm5zID0gWycwLjI1IHZDUFUnLCAnMC41IHZDUFUnLCAnMSB2Q1BVJywgJzIgdkNQVScsICc0IHZDUFUnXTtcbiAgICBjb25zdCBhbGxvd2VkUGF0dGVybnMgPSBudW1lcmljUGF0dGVybnMuY29uY2F0KHVuaXRQYXR0ZXJucyk7XG4gICAgY29uc3QgaXNWYWxpZFZhbHVlID0gYWxsb3dlZFBhdHRlcm5zLnNvbWUoXG4gICAgICAocGF0dGVybikgPT4gcGF0dGVybiA9PT0gdW5pdCxcbiAgICApO1xuICAgIGlmICghaXNWYWxpZFZhbHVlKSB7XG4gICAgICB0aHJvdyBuZXcgY2RrLlVuc2NvcGVkVmFsaWRhdGlvbkVycm9yKCdDUFUgdmFsdWUgaXMgaW52YWxpZCcpO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgQ3B1KHVuaXQpO1xuICB9XG5cbiAgLyoqXG4gICAqXG4gICAqIEBwYXJhbSB1bml0IFRoZSB1bml0IG9mIENQVS5cbiAgICovXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IHVuaXQ6IHN0cmluZykgeyB9XG59XG5cbi8qKlxuICogVGhlIGFtb3VudCBvZiBtZW1vcnkgcmVzZXJ2ZWQgZm9yIGVhY2ggaW5zdGFuY2Ugb2YgeW91ciBBcHAgUnVubmVyIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBjbGFzcyBNZW1vcnkge1xuICAvKipcbiAgICogMC41IEdCKGZvciAwLjI1IHZDUFUpXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEhBTEZfR0IgPSBNZW1vcnkub2YoJzAuNSBHQicpO1xuXG4gIC8qKlxuICAgKiAxIEdCKGZvciAwLjI1IG9yIDAuNSB2Q1BVKVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBPTkVfR0IgPSBNZW1vcnkub2YoJzEgR0InKTtcblxuICAvKipcbiAgICogMiBHQihmb3IgMSB2Q1BVKVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUV09fR0IgPSBNZW1vcnkub2YoJzIgR0InKTtcblxuICAvKipcbiAgICogMyBHQihmb3IgMSB2Q1BVKVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBUSFJFRV9HQiA9IE1lbW9yeS5vZignMyBHQicpO1xuXG4gIC8qKlxuICAgKiA0IEdCKGZvciAxIG9yIDIgdkNQVSlcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRk9VUl9HQiA9IE1lbW9yeS5vZignNCBHQicpO1xuXG4gIC8qKlxuICAgKiA2IEdCKGZvciAyIHZDUFUpXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNJWF9HQiA9IE1lbW9yeS5vZignNiBHQicpO1xuXG4gIC8qKlxuICAgKiA4IEdCKGZvciA0IHZDUFUpXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVJR0hUX0dCID0gTWVtb3J5Lm9mKCc4IEdCJyk7XG5cbiAgLyoqXG4gICAqIDEwIEdCKGZvciA0IHZDUFUpXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFRFTl9HQiA9IE1lbW9yeS5vZignMTAgR0InKTtcblxuICAvKipcbiAgICogMTIgR0IoZm9yIDQgdkNQVSlcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVFdFTFZFX0dCID0gTWVtb3J5Lm9mKCcxMiBHQicpO1xuXG4gIC8qKlxuICAgKiBDdXN0b20gTWVtb3J5IHVuaXRcbiAgICpcbiAgICogQHBhcmFtIHVuaXQgY3VzdG9tIE1lbW9yeSB1bml0XG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBwcnVubmVyLXNlcnZpY2UtaW5zdGFuY2Vjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWFwcHJ1bm5lci1zZXJ2aWNlLWluc3RhbmNlY29uZmlndXJhdGlvbi1tZW1vcnlcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgb2YodW5pdDogc3RyaW5nKTogTWVtb3J5IHtcbiAgICBjb25zdCBudW1lcmljUGF0dGVybnMgPSBbJzUxMicsICcxMDI0JywgJzIwNDgnLCAnMzA3MicsICc0MDk2JywgJzYxNDQnLCAnODE5MicsICcxMDI0MCcsICcxMjI4OCddO1xuICAgIGNvbnN0IHVuaXRQYXR0ZXJucyA9IFsnMC41IEdCJywgJzEgR0InLCAnMiBHQicsICczIEdCJywgJzQgR0InLCAnNiBHQicsICc4IEdCJywgJzEwIEdCJywgJzEyIEdCJ107XG4gICAgY29uc3QgYWxsb3dlZFBhdHRlcm5zID0gbnVtZXJpY1BhdHRlcm5zLmNvbmNhdCh1bml0UGF0dGVybnMpO1xuICAgIGNvbnN0IGlzVmFsaWRWYWx1ZSA9IGFsbG93ZWRQYXR0ZXJucy5zb21lKFxuICAgICAgKHBhdHRlcm4pID0+IHBhdHRlcm4gPT09IHVuaXQsXG4gICAgKTtcbiAgICBpZiAoIWlzVmFsaWRWYWx1ZSkge1xuICAgICAgdGhyb3cgbmV3IGNkay5VbnNjb3BlZFZhbGlkYXRpb25FcnJvcignTWVtb3J5IHZhbHVlIGlzIGludmFsaWQnKTtcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IE1lbW9yeSh1bml0KTtcbiAgfVxuXG4gIC8qKlxuICAgKlxuICAgKiBAcGFyYW0gdW5pdCBUaGUgdW5pdCBvZiBtZW1vcnkuXG4gICAqL1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHB1YmxpYyByZWFkb25seSB1bml0OiBzdHJpbmcpIHsgfVxufVxuXG4vKipcbiAqIFRoZSBjb2RlIHJ1bnRpbWVzXG4gKi9cbmV4cG9ydCBjbGFzcyBSdW50aW1lIHtcbiAgLyoqXG4gICAqIENPUlJFVFRPIDhcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09SUkVUVE9fOCA9IFJ1bnRpbWUub2YoJ0NPUlJFVFRPXzgnKTtcblxuICAvKipcbiAgICogQ09SUkVUVE8gMTFcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ09SUkVUVE9fMTEgPSBSdW50aW1lLm9mKCdDT1JSRVRUT18xMScpO1xuXG4gIC8qKlxuICAgKiAuTkVUIDZcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRE9UTkVUXzYgPSBSdW50aW1lLm9mKCdET1RORVRfNicpO1xuXG4gIC8qKlxuICAgKiBHbyAxLjE4XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdPXzEgPSBSdW50aW1lLm9mKCdHT18xJyk7XG5cbiAgLyoqXG4gICAqIE5vZGVKUyAxMlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT0RFSlNfMTIgPSBSdW50aW1lLm9mKCdOT0RFSlNfMTInKTtcblxuICAvKipcbiAgICogTm9kZUpTIDE0XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE5PREVKU18xNCA9IFJ1bnRpbWUub2YoJ05PREVKU18xNCcpO1xuXG4gIC8qKlxuICAgKiBOb2RlSlMgMTZcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTk9ERUpTXzE2ID0gUnVudGltZS5vZignTk9ERUpTXzE2Jyk7XG5cbiAgLyoqXG4gICAqIE5vZGVKUyAxOFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT0RFSlNfMTggPSBSdW50aW1lLm9mKCdOT0RFSlNfMTgnKTtcblxuICAvKipcbiAgICogUEhQIDguMVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQSFBfODEgPSBSdW50aW1lLm9mKCdQSFBfODEnKTtcblxuICAvKipcbiAgICogUHl0aG9uIDNcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUFlUSE9OXzMgPSBSdW50aW1lLm9mKCdQWVRIT05fMycpO1xuXG4gIC8qKlxuICAgKiBQeXRob24gMy4xMVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQWVRIT05fMzExID0gUnVudGltZS5vZignUFlUSE9OXzMxMScpO1xuXG4gIC8qKlxuICAgKiBSdWJ5IDMuMVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBSVUJZXzMxID0gUnVudGltZS5vZignUlVCWV8zMScpO1xuXG4gIC8qKlxuICAgKiBOb2RlSlMgMjJcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTk9ERUpTXzIyID0gUnVudGltZS5vZignTk9ERUpTXzIyJyk7XG5cbiAgLyoqXG4gICAqIE90aGVyIHJ1bnRpbWVzXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBwcnVubmVyLXNlcnZpY2UtY29kZWNvbmZpZ3VyYXRpb252YWx1ZXMuaHRtbCNjZm4tYXBwcnVubmVyLXNlcnZpY2UtY29kZWNvbmZpZ3VyYXRpb252YWx1ZXMtcnVudGltZSBmb3IgYWxsIGF2YWlsYWJsZSBydW50aW1lcy5cbiAgICpcbiAgICogQHBhcmFtIG5hbWUgcnVudGltZSBuYW1lXG4gICAqXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9mKG5hbWU6IHN0cmluZykgeyByZXR1cm4gbmV3IFJ1bnRpbWUobmFtZSk7IH1cblxuICAvKipcbiAgICpcbiAgICogQHBhcmFtIG5hbWUgVGhlIHJ1bnRpbWUgbmFtZS5cbiAgICovXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IG5hbWU6IHN0cmluZykgeyB9XG59XG5cbi8qKlxuICogVGhlIGVudmlyb25tZW50IHNlY3JldCBmb3IgdGhlIHNlcnZpY2UuXG4gKi9cbmludGVyZmFjZSBFbnZpcm9ubWVudFNlY3JldCB7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBUaGUgZW52aXJvbm1lbnQgdmFyaWFibGUgZm9yIHRoZSBzZXJ2aWNlLlxuICovXG5pbnRlcmZhY2UgRW52aXJvbm1lbnRWYXJpYWJsZSB7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXN1bHQgb2YgYmluZGluZyBgU291cmNlYCBpbnRvIGEgYFNlcnZpY2VgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNvdXJjZUNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgaW1hZ2UgcmVwb3NpdG9yeSBjb25maWd1cmF0aW9uIChtdXR1YWxseSBleGNsdXNpdmUgIHdpdGggYGNvZGVSZXBvc2l0b3J5YCkuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gaW1hZ2UgcmVwb3NpdG9yeS5cbiAgICovXG4gIHJlYWRvbmx5IGltYWdlUmVwb3NpdG9yeT86IEltYWdlUmVwb3NpdG9yeTtcblxuICAvKipcbiAgICogVGhlIEVDUiByZXBvc2l0b3J5IChyZXF1aXJlZCB0byBncmFudCB0aGUgcHVsbCBwcml2aWxlZ2VzIGZvciB0aGUgaWFtIHJvbGUpLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIEVDUiByZXBvc2l0b3J5LlxuICAgKi9cbiAgcmVhZG9ubHkgZWNyUmVwb3NpdG9yeT86IGVjci5JUmVwb3NpdG9yeTtcblxuICAvKipcbiAgICogVGhlIGNvZGUgcmVwb3NpdG9yeSBjb25maWd1cmF0aW9uIChtdXR1YWxseSBleGNsdXNpdmUgIHdpdGggYGltYWdlUmVwb3NpdG9yeWApLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGNvZGUgcmVwb3NpdG9yeS5cbiAgICovXG4gIHJlYWRvbmx5IGNvZGVSZXBvc2l0b3J5PzogQ29kZVJlcG9zaXRvcnlQcm9wcztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIHRoZSBHaXRodWIgcmVwb3NpdG9yeSBmb3IgYFNvdXJjZS5mcm9tR2l0SHViKClgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgR2l0aHViUmVwb3NpdG9yeVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBjb2RlIGNvbmZpZ3VyYXRpb24gdmFsdWVzLiBXaWxsIGJlIGlnbm9yZWQgaWYgY29uZmlndXJhdGlvblNvdXJjZSBpcyBgUkVQT1NJVE9SWWAuXG4gICAqIEBkZWZhdWx0IC0gbm8gdmFsdWVzIHdpbGwgYmUgcGFzc2VkLiBUaGUgYGFwcHJ1bm5lci55YW1sYCBmcm9tIHRoZSBnaXRodWIgcmVvcHNpdG9yeSB3aWxsIGJlIHVzZWQgaW5zdGVhZC5cbiAgICovXG4gIHJlYWRvbmx5IGNvZGVDb25maWd1cmF0aW9uVmFsdWVzPzogQ29kZUNvbmZpZ3VyYXRpb25WYWx1ZXM7XG5cbiAgLyoqXG4gICAqIFRoZSBzb3VyY2Ugb2YgdGhlIEFwcCBSdW5uZXIgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25Tb3VyY2U6IENvbmZpZ3VyYXRpb25Tb3VyY2VUeXBlO1xuXG4gIC8qKlxuICAgKiBUaGUgbG9jYXRpb24gb2YgdGhlIHJlcG9zaXRvcnkgdGhhdCBjb250YWlucyB0aGUgc291cmNlIGNvZGUuXG4gICAqL1xuICByZWFkb25seSByZXBvc2l0b3J5VXJsOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBicmFuY2ggbmFtZSB0aGF0IHJlcHJlc2VudHMgYSBzcGVjaWZpYyB2ZXJzaW9uIGZvciB0aGUgcmVwb3NpdG9yeS5cbiAgICpcbiAgICogQGRlZmF1bHQgbWFpblxuICAgKi9cbiAgcmVhZG9ubHkgYnJhbmNoPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBUk4gb2YgdGhlIGNvbm5lY3Rpb24gdG8gR2l0aHViLiBPbmx5IHJlcXVpcmVkIGZvciBHaXRodWIgc291cmNlLlxuICAgKi9cbiAgcmVhZG9ubHkgY29ubmVjdGlvbjogR2l0SHViQ29ubmVjdGlvbjtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIHRoZSBpbWFnZSByZXBvc2l0b3J5IGZvciBgU291cmNlLmZyb21FY3JQdWJsaWMoKWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFY3JQdWJsaWNQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgaW1hZ2UgY29uZmlndXJhdGlvbiBmb3IgdGhlIGltYWdlIGZyb20gRUNSIFB1YmxpYy5cbiAgICogQGRlZmF1bHQgLSBubyBpbWFnZSBjb25maWd1cmF0aW9uIHdpbGwgYmUgcGFzc2VkLiBUaGUgZGVmYXVsdCBgcG9ydGAgd2lsbCBiZSA4MDgwLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFwcHJ1bm5lci1zZXJ2aWNlLWltYWdlY29uZmlndXJhdGlvbi5odG1sI2Nmbi1hcHBydW5uZXItc2VydmljZS1pbWFnZWNvbmZpZ3VyYXRpb24tcG9ydFxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2VDb25maWd1cmF0aW9uPzogSW1hZ2VDb25maWd1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgRUNSIFB1YmxpYyBpbWFnZSBVUkkuXG4gICAqL1xuICByZWFkb25seSBpbWFnZUlkZW50aWZpZXI6IHN0cmluZztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIHRoZSBpbWFnZSByZXBvc2l0b3J5IGZvciBgU291cmNlLmZyb21FY3IoKWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFY3JQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgaW1hZ2UgY29uZmlndXJhdGlvbiBmb3IgdGhlIGltYWdlIGZyb20gRUNSLlxuICAgKiBAZGVmYXVsdCAtIG5vIGltYWdlIGNvbmZpZ3VyYXRpb24gd2lsbCBiZSBwYXNzZWQuIFRoZSBkZWZhdWx0IGBwb3J0YCB3aWxsIGJlIDgwODAuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBwcnVubmVyLXNlcnZpY2UtaW1hZ2Vjb25maWd1cmF0aW9uLmh0bWwjY2ZuLWFwcHJ1bm5lci1zZXJ2aWNlLWltYWdlY29uZmlndXJhdGlvbi1wb3J0XG4gICAqL1xuICByZWFkb25seSBpbWFnZUNvbmZpZ3VyYXRpb24/OiBJbWFnZUNvbmZpZ3VyYXRpb247XG5cbiAgLyoqXG4gICAqIFJlcHJlc2VudHMgdGhlIEVDUiByZXBvc2l0b3J5LlxuICAgKi9cbiAgcmVhZG9ubHkgcmVwb3NpdG9yeTogZWNyLklSZXBvc2l0b3J5O1xuXG4gIC8qKlxuICAgKiBJbWFnZSB0YWcuXG4gICAqIEBkZWZhdWx0IC0gJ2xhdGVzdCdcbiAgICogQGRlcHJlY2F0ZWQgdXNlIGB0YWdPckRpZ2VzdGBcbiAgICovXG4gIHJlYWRvbmx5IHRhZz86IHN0cmluZztcblxuICAvKipcbiAgICogSW1hZ2UgdGFnIG9yIGRpZ2VzdCAoZGlnZXN0cyBtdXN0IHN0YXJ0IHdpdGggYHNoYTI1NjpgKS5cbiAgICogQGRlZmF1bHQgLSAnbGF0ZXN0J1xuICAgKi9cbiAgcmVhZG9ubHkgdGFnT3JEaWdlc3Q/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBvZiB0aGUgaW1hZ2UgcmVwb3NpdG9yeSBmb3IgYFNvdXJjZS5mcm9tQXNzZXQoKWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBc3NldFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBpbWFnZSBjb25maWd1cmF0aW9uIGZvciB0aGUgaW1hZ2UgYnVpbHQgZnJvbSB0aGUgYXNzZXQuXG4gICAqIEBkZWZhdWx0IC0gbm8gaW1hZ2UgY29uZmlndXJhdGlvbiB3aWxsIGJlIHBhc3NlZC4gVGhlIGRlZmF1bHQgYHBvcnRgIHdpbGwgYmUgODA4MC5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcHBydW5uZXItc2VydmljZS1pbWFnZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXBwcnVubmVyLXNlcnZpY2UtaW1hZ2Vjb25maWd1cmF0aW9uLXBvcnRcbiAgICovXG4gIHJlYWRvbmx5IGltYWdlQ29uZmlndXJhdGlvbj86IEltYWdlQ29uZmlndXJhdGlvbjtcblxuICAvKipcbiAgICogUmVwcmVzZW50cyB0aGUgZG9ja2VyIGltYWdlIGFzc2V0LlxuICAgKi9cbiAgcmVhZG9ubHkgYXNzZXQ6IGFzc2V0cy5Eb2NrZXJJbWFnZUFzc2V0O1xufVxuXG4vKipcbiAqIFNwZWNpZnkgdGhlIHNlY3JldCdzIHZlcnNpb24gaWQgb3IgdmVyc2lvbiBzdGFnZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlY3JldFZlcnNpb25JbmZvIHtcbiAgLyoqXG4gICAqIHZlcnNpb24gaWQgb2YgdGhlIHNlY3JldFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHVzZSBkZWZhdWx0IHZlcnNpb24gaWRcbiAgICovXG4gIHJlYWRvbmx5IHZlcnNpb25JZD86IHN0cmluZztcblxuICAvKipcbiAgICogdmVyc2lvbiBzdGFnZSBvZiB0aGUgc2VjcmV0XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdXNlIGRlZmF1bHQgdmVyc2lvbiBzdGFnZVxuICAgKi9cbiAgcmVhZG9ubHkgdmVyc2lvblN0YWdlPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIEFwcCBSdW5uZXIgc2VydmljZSBzb3VyY2UuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTb3VyY2Uge1xuICAvKipcbiAgICogU291cmNlIGZyb20gdGhlIEdpdEh1YiByZXBvc2l0b3J5LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tR2l0SHViKHByb3BzOiBHaXRodWJSZXBvc2l0b3J5UHJvcHMpOiBHaXRodWJTb3VyY2Uge1xuICAgIHJldHVybiBuZXcgR2l0aHViU291cmNlKHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTb3VyY2UgZnJvbSB0aGUgRUNSIHJlcG9zaXRvcnkuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21FY3IocHJvcHM6IEVjclByb3BzKTogRWNyU291cmNlIHtcbiAgICByZXR1cm4gbmV3IEVjclNvdXJjZShwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogU291cmNlIGZyb20gdGhlIEVDUiBQdWJsaWMgcmVwb3NpdG9yeS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUVjclB1YmxpYyhwcm9wczogRWNyUHVibGljUHJvcHMpOiBFY3JQdWJsaWNTb3VyY2Uge1xuICAgIHJldHVybiBuZXcgRWNyUHVibGljU291cmNlKHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTb3VyY2UgZnJvbSBsb2NhbCBhc3NldHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Bc3NldChwcm9wczogQXNzZXRQcm9wcyk6IEFzc2V0U291cmNlIHtcbiAgICByZXR1cm4gbmV3IEFzc2V0U291cmNlKHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxsZWQgd2hlbiB0aGUgSm9iIGlzIGluaXRpYWxpemVkIHRvIGFsbG93IHRoaXMgb2JqZWN0IHRvIGJpbmQuXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgYmluZChzY29wZTogQ29uc3RydWN0KTogU291cmNlQ29uZmlnO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHNlcnZpY2Ugc291cmNlIGZyb20gYSBHaXRodWIgcmVwb3NpdG9yeS5cbiAqL1xuZXhwb3J0IGNsYXNzIEdpdGh1YlNvdXJjZSBleHRlbmRzIFNvdXJjZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEdpdGh1YlJlcG9zaXRvcnlQcm9wcztcbiAgY29uc3RydWN0b3IocHJvcHM6IEdpdGh1YlJlcG9zaXRvcnlQcm9wcykge1xuICAgIHN1cGVyKCk7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0KTogU291cmNlQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgY29kZVJlcG9zaXRvcnk6IHtcbiAgICAgICAgY29kZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICBjb25maWd1cmF0aW9uU291cmNlOiB0aGlzLnByb3BzLmNvbmZpZ3VyYXRpb25Tb3VyY2UsXG4gICAgICAgICAgY29uZmlndXJhdGlvblZhbHVlczogdGhpcy5wcm9wcy5jb2RlQ29uZmlndXJhdGlvblZhbHVlcyxcbiAgICAgICAgfSxcbiAgICAgICAgcmVwb3NpdG9yeVVybDogdGhpcy5wcm9wcy5yZXBvc2l0b3J5VXJsLFxuICAgICAgICBzb3VyY2VDb2RlVmVyc2lvbjoge1xuICAgICAgICAgIHR5cGU6ICdCUkFOQ0gnLFxuICAgICAgICAgIHZhbHVlOiB0aGlzLnByb3BzLmJyYW5jaCA/PyAnbWFpbicsXG4gICAgICAgIH0sXG4gICAgICAgIGNvbm5lY3Rpb246IHRoaXMucHJvcHMuY29ubmVjdGlvbixcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHNlcnZpY2Ugc291cmNlIGZyb20gRUNSLlxuICovXG5leHBvcnQgY2xhc3MgRWNyU291cmNlIGV4dGVuZHMgU291cmNlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogRWNyUHJvcHM7XG4gIGNvbnN0cnVjdG9yKHByb3BzOiBFY3JQcm9wcykge1xuICAgIHN1cGVyKCk7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG4gIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0KTogU291cmNlQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaW1hZ2VSZXBvc2l0b3J5OiB7XG4gICAgICAgIGltYWdlQ29uZmlndXJhdGlvbjogdGhpcy5wcm9wcy5pbWFnZUNvbmZpZ3VyYXRpb24sXG4gICAgICAgIGltYWdlSWRlbnRpZmllcjogdGhpcy5wcm9wcy5yZXBvc2l0b3J5LnJlcG9zaXRvcnlVcmlGb3JUYWdPckRpZ2VzdChcbiAgICAgICAgICB0aGlzLnByb3BzLnRhZ09yRGlnZXN0IHx8IHRoaXMucHJvcHMudGFnIHx8ICdsYXRlc3QnLFxuICAgICAgICApLFxuICAgICAgICBpbWFnZVJlcG9zaXRvcnlUeXBlOiBJbWFnZVJlcG9zaXRvcnlUeXBlLkVDUixcbiAgICAgIH0sXG4gICAgICBlY3JSZXBvc2l0b3J5OiB0aGlzLnByb3BzLnJlcG9zaXRvcnksXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHNlcnZpY2Ugc291cmNlIGZyb20gRUNSIFB1YmxpYy5cbiAqL1xuZXhwb3J0IGNsYXNzIEVjclB1YmxpY1NvdXJjZSBleHRlbmRzIFNvdXJjZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEVjclB1YmxpY1Byb3BzO1xuICBjb25zdHJ1Y3Rvcihwcm9wczogRWNyUHVibGljUHJvcHMpIHtcbiAgICBzdXBlcigpO1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgfVxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFNvdXJjZUNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGltYWdlUmVwb3NpdG9yeToge1xuICAgICAgICBpbWFnZUNvbmZpZ3VyYXRpb246IHRoaXMucHJvcHMuaW1hZ2VDb25maWd1cmF0aW9uLFxuICAgICAgICBpbWFnZUlkZW50aWZpZXI6IHRoaXMucHJvcHMuaW1hZ2VJZGVudGlmaWVyLFxuICAgICAgICBpbWFnZVJlcG9zaXRvcnlUeXBlOiBJbWFnZVJlcG9zaXRvcnlUeXBlLkVDUl9QVUJMSUMsXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBzb3VyY2UgZnJvbSBsb2NhbCBhc3NldHMuXG4gKi9cbmV4cG9ydCBjbGFzcyBBc3NldFNvdXJjZSBleHRlbmRzIFNvdXJjZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEFzc2V0UHJvcHM7XG4gIGNvbnN0cnVjdG9yKHByb3BzOiBBc3NldFByb3BzKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QpOiBTb3VyY2VDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBpbWFnZVJlcG9zaXRvcnk6IHtcbiAgICAgICAgaW1hZ2VDb25maWd1cmF0aW9uOiB0aGlzLnByb3BzLmltYWdlQ29uZmlndXJhdGlvbixcbiAgICAgICAgaW1hZ2VJZGVudGlmaWVyOiB0aGlzLnByb3BzLmFzc2V0LmltYWdlVXJpLFxuICAgICAgICBpbWFnZVJlcG9zaXRvcnlUeXBlOiBJbWFnZVJlcG9zaXRvcnlUeXBlLkVDUixcbiAgICAgIH0sXG4gICAgICBlY3JSZXBvc2l0b3J5OiB0aGlzLnByb3BzLmFzc2V0LnJlcG9zaXRvcnksXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIERlc2NyaWJlcyB0aGUgY29uZmlndXJhdGlvbiB0aGF0IEFXUyBBcHAgUnVubmVyIHVzZXMgdG8gcnVuIGFuIEFwcCBSdW5uZXIgc2VydmljZVxuICogdXNpbmcgYW4gaW1hZ2UgcHVsbGVkIGZyb20gYSBzb3VyY2UgaW1hZ2UgcmVwb3NpdG9yeS5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFwcHJ1bm5lci1zZXJ2aWNlLWltYWdlY29uZmlndXJhdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW1hZ2VDb25maWd1cmF0aW9uIHtcbiAgLyoqXG4gICAqIFRoZSBwb3J0IHRoYXQgeW91ciBhcHBsaWNhdGlvbiBsaXN0ZW5zIHRvIGluIHRoZSBjb250YWluZXIuXG4gICAqXG4gICAqIEBkZWZhdWx0IDgwODBcbiAgICovXG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IHZhcmlhYmxlcyB0aGF0IGFyZSBhdmFpbGFibGUgdG8geW91ciBydW5uaW5nIEFwcCBSdW5uZXIgc2VydmljZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBlbnZpcm9ubWVudCB2YXJpYWJsZXNcbiAgICogQGRlcHJlY2F0ZWQgdXNlIGVudmlyb25tZW50VmFyaWFibGVzLlxuICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnQ/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gIC8qKlxuICAgKiBFbnZpcm9ubWVudCB2YXJpYWJsZXMgdGhhdCBhcmUgYXZhaWxhYmxlIHRvIHlvdXIgcnVubmluZyBBcHAgUnVubmVyIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gZW52aXJvbm1lbnQgdmFyaWFibGVzXG4gICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudFZhcmlhYmxlcz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IHNlY3JldHMgdGhhdCBhcmUgYXZhaWxhYmxlIHRvIHlvdXIgcnVubmluZyBBcHAgUnVubmVyIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gZW52aXJvbm1lbnQgc2VjcmV0c1xuICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRTZWNyZXRzPzogeyBba2V5OiBzdHJpbmddOiBTZWNyZXQgfTtcblxuICAvKipcbiAgICogQW4gb3B0aW9uYWwgY29tbWFuZCB0aGF0IEFwcCBSdW5uZXIgcnVucyB0byBzdGFydCB0aGUgYXBwbGljYXRpb24gaW4gdGhlIHNvdXJjZSBpbWFnZS5cbiAgICogSWYgc3BlY2lmaWVkLCB0aGlzIGNvbW1hbmQgb3ZlcnJpZGVzIHRoZSBEb2NrZXIgaW1hZ2XigJlzIGRlZmF1bHQgc3RhcnQgY29tbWFuZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBzdGFydCBjb21tYW5kXG4gICAqL1xuICByZWFkb25seSBzdGFydENvbW1hbmQ/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGVzY3JpYmVzIGEgc291cmNlIGltYWdlIHJlcG9zaXRvcnkuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcHBydW5uZXItc2VydmljZS1pbWFnZXJlcG9zaXRvcnkuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEltYWdlUmVwb3NpdG9yeSB7XG4gIC8qKlxuICAgKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgaW1hZ2UuIEZvciBgRUNSX1BVQkxJQ2AgaW1hZ2VSZXBvc2l0b3J5VHlwZSwgdGhlIGlkZW50aWZpZXIgZG9tYWluIHNob3VsZFxuICAgKiBhbHdheXMgYmUgYHB1YmxpYy5lY3IuYXdzYC4gRm9yIGBFQ1JgLCB0aGUgcGF0dGVybiBzaG91bGQgYmVcbiAgICogYChbMC05XXsxMn0uZGtyLmVjci5bYS16XFwtXSstWzAtOV17MX0uYW1hem9uYXdzLmNvbVxcLy4qKWAuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBwcnVubmVyLXNlcnZpY2UtaW1hZ2VyZXBvc2l0b3J5Lmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IGltYWdlSWRlbnRpZmllcjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgdHlwZSBvZiB0aGUgaW1hZ2UgcmVwb3NpdG9yeS4gVGhpcyByZWZsZWN0cyB0aGUgcmVwb3NpdG9yeSBwcm92aWRlciBhbmQgd2hldGhlclxuICAgKiB0aGUgcmVwb3NpdG9yeSBpcyBwcml2YXRlIG9yIHB1YmxpYy5cbiAgICovXG4gIHJlYWRvbmx5IGltYWdlUmVwb3NpdG9yeVR5cGU6IEltYWdlUmVwb3NpdG9yeVR5cGU7XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyYXRpb24gZm9yIHJ1bm5pbmcgdGhlIGlkZW50aWZpZWQgaW1hZ2UuXG4gICAqIEBkZWZhdWx0IC0gbm8gaW1hZ2UgY29uZmlndXJhdGlvbiB3aWxsIGJlIHBhc3NlZC4gVGhlIGRlZmF1bHQgYHBvcnRgIHdpbGwgYmUgODA4MC5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcHBydW5uZXItc2VydmljZS1pbWFnZWNvbmZpZ3VyYXRpb24uaHRtbCNjZm4tYXBwcnVubmVyLXNlcnZpY2UtaW1hZ2Vjb25maWd1cmF0aW9uLXBvcnRcbiAgICovXG4gIHJlYWRvbmx5IGltYWdlQ29uZmlndXJhdGlvbj86IEltYWdlQ29uZmlndXJhdGlvbjtcbn1cblxuLyoqXG4gKiBJZGVudGlmaWVzIGEgdmVyc2lvbiBvZiBjb2RlIHRoYXQgQVdTIEFwcCBSdW5uZXIgcmVmZXJzIHRvIHdpdGhpbiBhIHNvdXJjZSBjb2RlIHJlcG9zaXRvcnkuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcHBydW5uZXItc2VydmljZS1zb3VyY2Vjb2RldmVyc2lvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU291cmNlQ29kZVZlcnNpb24ge1xuICAvKipcbiAgICogVGhlIHR5cGUgb2YgdmVyc2lvbiBpZGVudGlmaWVyLlxuICAgKi9cbiAgcmVhZG9ubHkgdHlwZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIHNvdXJjZSBjb2RlIHZlcnNpb24uXG4gICAqL1xuICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgb2YgdGhlIENvZGVSZXBvc2l0b3J5LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENvZGVSZXBvc2l0b3J5UHJvcHMge1xuICAvKipcbiAgICogQ29uZmlndXJhdGlvbiBmb3IgYnVpbGRpbmcgYW5kIHJ1bm5pbmcgdGhlIHNlcnZpY2UgZnJvbSBhIHNvdXJjZSBjb2RlIHJlcG9zaXRvcnkuXG4gICAqL1xuICByZWFkb25seSBjb2RlQ29uZmlndXJhdGlvbjogQ29kZUNvbmZpZ3VyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBsb2NhdGlvbiBvZiB0aGUgcmVwb3NpdG9yeSB0aGF0IGNvbnRhaW5zIHRoZSBzb3VyY2UgY29kZS5cbiAgICovXG4gIHJlYWRvbmx5IHJlcG9zaXRvcnlVcmw6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHZlcnNpb24gdGhhdCBzaG91bGQgYmUgdXNlZCB3aXRoaW4gdGhlIHNvdXJjZSBjb2RlIHJlcG9zaXRvcnkuXG4gICAqL1xuICByZWFkb25seSBzb3VyY2VDb2RlVmVyc2lvbjogU291cmNlQ29kZVZlcnNpb247XG5cbiAgLyoqXG4gICAqIFRoZSBBcHAgUnVubmVyIGNvbm5lY3Rpb24gZm9yIEdpdEh1Yi5cbiAgICovXG4gIHJlYWRvbmx5IGNvbm5lY3Rpb246IEdpdEh1YkNvbm5lY3Rpb247XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBvZiB0aGUgQXBwUnVubmVyIFNlcnZpY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZXJ2aWNlUHJvcHMge1xuICAvKipcbiAgICogVGhlIHNvdXJjZSBvZiB0aGUgcmVwb3NpdG9yeSBmb3IgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBzb3VyY2U6IFNvdXJjZTtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGNvbnRpbnVvdXMgaW50ZWdyYXRpb24gZnJvbSB0aGUgc291cmNlIHJlcG9zaXRvcnkuXG4gICAqXG4gICAqIElmIHRydWUsIGNvbnRpbnVvdXMgaW50ZWdyYXRpb24gZnJvbSB0aGUgc291cmNlIHJlcG9zaXRvcnkgaXMgZW5hYmxlZCBmb3IgdGhlIEFwcCBSdW5uZXIgc2VydmljZS5cbiAgICogRWFjaCByZXBvc2l0b3J5IGNoYW5nZSAoaW5jbHVkaW5nIGFueSBzb3VyY2UgY29kZSBjb21taXQgb3IgbmV3IGltYWdlIHZlcnNpb24pIHN0YXJ0cyBhIGRlcGxveW1lbnQuXG4gICAqIEJ5IGRlZmF1bHQsIEFwcCBSdW5uZXIgc2V0cyB0byBmYWxzZSBmb3IgYSBzb3VyY2UgaW1hZ2UgdGhhdCB1c2VzIGFuIEVDUiBQdWJsaWMgcmVwb3NpdG9yeSBvciBhbiBFQ1IgcmVwb3NpdG9yeSB0aGF0J3MgaW4gYW4gQVdTIGFjY291bnQgb3RoZXIgdGhhbiB0aGUgb25lIHRoYXQgdGhlIHNlcnZpY2UgaXMgaW4uXG4gICAqIEFwcCBSdW5uZXIgc2V0cyB0byB0cnVlIGluIGFsbCBvdGhlciBjYXNlcyAod2hpY2ggY3VycmVudGx5IGluY2x1ZGUgYSBzb3VyY2UgY29kZSByZXBvc2l0b3J5IG9yIGEgc291cmNlIGltYWdlIHVzaW5nIGEgc2FtZS1hY2NvdW50IEVDUiByZXBvc2l0b3J5KS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyB2YWx1ZSB3aWxsIGJlIHBhc3NlZC5cbiAgICovXG4gIHJlYWRvbmx5IGF1dG9EZXBsb3ltZW50c0VuYWJsZWQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgYW4gQXBwIFJ1bm5lciBBdXRvIFNjYWxpbmcgQ29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQSBkZWZhdWx0IGNvbmZpZ3VyYXRpb24gaXMgZWl0aGVyIHRoZSBBV1MgcmVjb21tZW5kZWQgY29uZmlndXJhdGlvbixcbiAgICogb3IgdGhlIGNvbmZpZ3VyYXRpb24geW91IHNldCBhcyB0aGUgZGVmYXVsdC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwcnVubmVyL2xhdGVzdC9kZy9tYW5hZ2UtYXV0b3NjYWxpbmcuaHRtbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRoZSBsYXRlc3QgcmV2aXNpb24gb2YgYSBkZWZhdWx0IGF1dG8gc2NhbGluZyBjb25maWd1cmF0aW9uIGlzIHVzZWQuXG4gICAqL1xuICByZWFkb25seSBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb24/OiBJQXV0b1NjYWxpbmdDb25maWd1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIENQVSB1bml0cyByZXNlcnZlZCBmb3IgZWFjaCBpbnN0YW5jZSBvZiB5b3VyIEFwcCBSdW5uZXIgc2VydmljZS5cbiAgICpcbiAgICogQGRlZmF1bHQgQ3B1Lk9ORV9WQ1BVXG4gICAqL1xuICByZWFkb25seSBjcHU/OiBDcHU7XG5cbiAgLyoqXG4gICAqIFRoZSBhbW91bnQgb2YgbWVtb3J5IHJlc2VydmVkIGZvciBlYWNoIGluc3RhbmNlIG9mIHlvdXIgQXBwIFJ1bm5lciBzZXJ2aWNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBNZW1vcnkuVFdPX0dCXG4gICAqL1xuICByZWFkb25seSBtZW1vcnk/OiBNZW1vcnk7XG5cbiAgLyoqXG4gICAqIFRoZSBJQU0gcm9sZSB0aGF0IGdyYW50cyB0aGUgQXBwIFJ1bm5lciBzZXJ2aWNlIGFjY2VzcyB0byBhIHNvdXJjZSByZXBvc2l0b3J5LlxuICAgKiBJdCdzIHJlcXVpcmVkIGZvciBFQ1IgaW1hZ2UgcmVwb3NpdG9yaWVzIChidXQgbm90IGZvciBFQ1IgUHVibGljIHJlcG9zaXRvcmllcykuXG4gICAqXG4gICAqIFRoZSByb2xlIG11c3QgYmUgYXNzdW1hYmxlIGJ5IHRoZSAnYnVpbGQuYXBwcnVubmVyLmFtYXpvbmF3cy5jb20nIHNlcnZpY2UgcHJpbmNpcGFsLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBydW5uZXIvbGF0ZXN0L2RnL3NlY3VyaXR5X2lhbV9zZXJ2aWNlLXdpdGgtaWFtLmh0bWwjc2VjdXJpdHlfaWFtX3NlcnZpY2Utd2l0aC1pYW0tcm9sZXMtc2VydmljZS5hY2Nlc3NcbiAgICpcbiAgICogQGRlZmF1bHQgLSBnZW5lcmF0ZSBhIG5ldyBhY2Nlc3Mgcm9sZS5cbiAgICovXG4gIHJlYWRvbmx5IGFjY2Vzc1JvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoZSBJQU0gcm9sZSB0aGF0IHByb3ZpZGVzIHBlcm1pc3Npb25zIHRvIHlvdXIgQXBwIFJ1bm5lciBzZXJ2aWNlLlxuICAgKiBUaGVzZSBhcmUgcGVybWlzc2lvbnMgdGhhdCB5b3VyIGNvZGUgbmVlZHMgd2hlbiBpdCBjYWxscyBhbnkgQVdTIEFQSXMuXG4gICAqXG4gICAqIFRoZSByb2xlIG11c3QgYmUgYXNzdW1hYmxlIGJ5IHRoZSAndGFza3MuYXBwcnVubmVyLmFtYXpvbmF3cy5jb20nIHNlcnZpY2UgcHJpbmNpcGFsLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBydW5uZXIvbGF0ZXN0L2RnL3NlY3VyaXR5X2lhbV9zZXJ2aWNlLXdpdGgtaWFtLmh0bWwjc2VjdXJpdHlfaWFtX3NlcnZpY2Utd2l0aC1pYW0tcm9sZXMtc2VydmljZS5pbnN0YW5jZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGdlbmVyYXRlIGEgbmV3IGluc3RhbmNlIHJvbGUuXG4gICAqL1xuICByZWFkb25seSBpbnN0YW5jZVJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIE5hbWUgb2YgdGhlIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYXV0by1nZW5lcmF0ZWQgaWYgdW5kZWZpbmVkLlxuICAgKi9cbiAgcmVhZG9ubHkgc2VydmljZU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNldHRpbmdzIGZvciBhbiBBcHAgUnVubmVyIFZQQyBjb25uZWN0b3IgdG8gYXNzb2NpYXRlIHdpdGggdGhlIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gVlBDIGNvbm5lY3RvciwgdXNlcyB0aGUgREVGQVVMVCBlZ3Jlc3MgdHlwZSBpbnN0ZWFkXG4gICAqL1xuICByZWFkb25seSB2cGNDb25uZWN0b3I/OiBJVnBjQ29ubmVjdG9yO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgd2hldGhlciB5b3VyIEFwcCBSdW5uZXIgc2VydmljZSBpcyBwdWJsaWNseSBhY2Nlc3NpYmxlLlxuICAgKlxuICAgKiBJZiB5b3UgdXNlIGBWcGNJbmdyZXNzQ29ubmVjdGlvbmAsIHlvdSBtdXN0IHNldCB0aGlzIHByb3BlcnR5IHRvIGBmYWxzZWAuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGlzUHVibGljbHlBY2Nlc3NpYmxlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogU2V0dGluZ3MgZm9yIHRoZSBoZWFsdGggY2hlY2sgdGhhdCBBV1MgQXBwIFJ1bm5lciBwZXJmb3JtcyB0byBtb25pdG9yIHRoZSBoZWFsdGggb2YgYSBzZXJ2aWNlLlxuICAgKlxuICAgKiBZb3UgY2FuIHNwZWNpZnkgaXQgYnkgc3RhdGljIG1ldGhvZHMgYEhlYWx0aENoZWNrLmh0dHBgIG9yIGBIZWFsdGhDaGVjay50Y3BgLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGhlYWx0aCBjaGVjayBjb25maWd1cmF0aW9uXG4gICAqL1xuICByZWFkb25seSBoZWFsdGhDaGVjaz86IEhlYWx0aENoZWNrO1xuXG4gIC8qKlxuICAgKiBUaGUgY3VzdG9tZXIgbWFuYWdlZCBrZXkgdGhhdCBBV1MgQXBwIFJ1bm5lciB1c2VzIHRvIGVuY3J5cHQgY29waWVzIG9mIHRoZSBzb3VyY2UgcmVwb3NpdG9yeSBhbmQgc2VydmljZSBsb2dzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVzZSBhbiBBV1MgbWFuYWdlZCBrZXlcbiAgICovXG4gIHJlYWRvbmx5IGttc0tleT86IGttcy5JS2V5O1xuXG4gIC8qKlxuICAgKiBUaGUgSVAgYWRkcmVzcyB0eXBlIGZvciB5b3VyIGluY29taW5nIHB1YmxpYyBuZXR3b3JrIGNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gSXBBZGRyZXNzVHlwZS5JUFY0XG4gICAqL1xuICByZWFkb25seSBpcEFkZHJlc3NUeXBlPzogSXBBZGRyZXNzVHlwZTtcblxuICAvKipcbiAgICogU2V0dGluZ3MgZm9yIGFuIEFwcCBSdW5uZXIgb2JzZXJ2YWJpbGl0eSBjb25maWd1cmF0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIG9ic2VydmFiaWxpdHkgY29uZmlndXJhdGlvbiByZXNvdXJjZSBpcyBhc3NvY2lhdGVkIHdpdGggdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBvYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbj86IElPYnNlcnZhYmlsaXR5Q29uZmlndXJhdGlvbjtcblxufVxuXG4vKipcbiAqIFRoZSBzb3VyY2Ugb2YgdGhlIEFwcCBSdW5uZXIgY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGVudW0gQ29uZmlndXJhdGlvblNvdXJjZVR5cGUge1xuICAvKipcbiAgICogQXBwIFJ1bm5lciByZWFkcyBjb25maWd1cmF0aW9uIHZhbHVlcyBmcm9tIGB0aGUgYXBwcnVubmVyLnlhbWxgIGZpbGUgaW4gdGhlIHNvdXJjZSBjb2RlIHJlcG9zaXRvcnlcbiAgICogYW5kIGlnbm9yZXMgYGNvbmZpZ3VyYXRpb25WYWx1ZXNgLlxuICAgKi9cbiAgUkVQT1NJVE9SWSA9ICdSRVBPU0lUT1JZJyxcblxuICAvKipcbiAgICogQXBwIFJ1bm5lciB1c2VzIGNvbmZpZ3VyYXRpb24gdmFsdWVzIHByb3ZpZGVkIGluIGBjb25maWd1cmF0aW9uVmFsdWVzYCBhbmQgaWdub3JlcyB0aGUgYGFwcHJ1bm5lci55YW1sYFxuICAgKiBmaWxlIGluIHRoZSBzb3VyY2UgY29kZSByZXBvc2l0b3J5LlxuICAgKi9cbiAgQVBJID0gJ0FQSScsXG59XG5cbi8qKlxuICogRGVzY3JpYmVzIHRoZSBjb25maWd1cmF0aW9uIHRoYXQgQVdTIEFwcCBSdW5uZXIgdXNlcyB0byBidWlsZCBhbmQgcnVuIGFuIEFwcCBSdW5uZXIgc2VydmljZVxuICogZnJvbSBhIHNvdXJjZSBjb2RlIHJlcG9zaXRvcnkuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1hcHBydW5uZXItc2VydmljZS1jb2RlY29uZmlndXJhdGlvbi5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZUNvbmZpZ3VyYXRpb24ge1xuICAvKipcbiAgICogVGhlIGJhc2ljIGNvbmZpZ3VyYXRpb24gZm9yIGJ1aWxkaW5nIGFuZCBydW5uaW5nIHRoZSBBcHAgUnVubmVyIHNlcnZpY2UuXG4gICAqIFVzZSBpdCB0byBxdWlja2x5IGxhdW5jaCBhbiBBcHAgUnVubmVyIHNlcnZpY2Ugd2l0aG91dCBwcm92aWRpbmcgYSBhcHBydW5uZXIueWFtbCBmaWxlIGluIHRoZVxuICAgKiBzb3VyY2UgY29kZSByZXBvc2l0b3J5IChvciBpZ25vcmluZyB0aGUgZmlsZSBpZiBpdCBleGlzdHMpLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vdCBzcGVjaWZpZWQuIFVzZSBgYXBwcnVubmVyLnlhbWxgIGluc3RlYWQuXG4gICAqL1xuICByZWFkb25seSBjb25maWd1cmF0aW9uVmFsdWVzPzogQ29kZUNvbmZpZ3VyYXRpb25WYWx1ZXM7XG5cbiAgLyoqXG4gICAqIFRoZSBzb3VyY2Ugb2YgdGhlIEFwcCBSdW5uZXIgY29uZmlndXJhdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb25Tb3VyY2U6IENvbmZpZ3VyYXRpb25Tb3VyY2VUeXBlO1xufVxuXG4vKipcbiAqIERlc2NyaWJlcyByZXNvdXJjZXMgbmVlZGVkIHRvIGF1dGhlbnRpY2F0ZSBhY2Nlc3MgdG8gc29tZSBzb3VyY2UgcmVwb3NpdG9yaWVzLlxuICogVGhlIHNwZWNpZmljIHJlc291cmNlIGRlcGVuZHMgb24gdGhlIHJlcG9zaXRvcnkgcHJvdmlkZXIuXG4gKi9cbmludGVyZmFjZSBBdXRoZW50aWNhdGlvbkNvbmZpZ3VyYXRpb24ge1xuICAvKipcbiAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBJQU0gcm9sZSB0aGF0IGdyYW50cyB0aGUgQXBwIFJ1bm5lciBzZXJ2aWNlIGFjY2VzcyB0byBhXG4gICAqIHNvdXJjZSByZXBvc2l0b3J5LiBJdCdzIHJlcXVpcmVkIGZvciBFQ1IgaW1hZ2UgcmVwb3NpdG9yaWVzIChidXQgbm90IGZvciBFQ1IgUHVibGljIHJlcG9zaXRvcmllcykuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gYWNjZXNzIHJvbGUuXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NSb2xlQXJuPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIEFwcCBSdW5uZXIgY29ubmVjdGlvbiB0aGF0IGVuYWJsZXMgdGhlIEFwcCBSdW5uZXIgc2VydmljZVxuICAgKiB0byBjb25uZWN0IHRvIGEgc291cmNlIHJlcG9zaXRvcnkuIEl0J3MgcmVxdWlyZWQgZm9yIEdpdEh1YiBjb2RlIHJlcG9zaXRvcmllcy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBjb25uZWN0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgY29ubmVjdGlvbkFybj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBEZXNjcmliZXMgdGhlIGJhc2ljIGNvbmZpZ3VyYXRpb24gbmVlZGVkIGZvciBidWlsZGluZyBhbmQgcnVubmluZyBhbiBBV1MgQXBwIFJ1bm5lciBzZXJ2aWNlLlxuICogVGhpcyB0eXBlIGRvZXNuJ3Qgc3VwcG9ydCB0aGUgZnVsbCBzZXQgb2YgcG9zc2libGUgY29uZmlndXJhdGlvbiBvcHRpb25zLiBGdXIgZnVsbCBjb25maWd1cmF0aW9uIGNhcGFiaWxpdGllcyxcbiAqIHVzZSBhIGBhcHBydW5uZXIueWFtbGAgZmlsZSBpbiB0aGUgc291cmNlIGNvZGUgcmVwb3NpdG9yeS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDb2RlQ29uZmlndXJhdGlvblZhbHVlcyB7XG4gIC8qKlxuICAgKiBUaGUgY29tbWFuZCBBcHAgUnVubmVyIHJ1bnMgdG8gYnVpbGQgeW91ciBhcHBsaWNhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBidWlsZCBjb21tYW5kLlxuICAgKi9cbiAgcmVhZG9ubHkgYnVpbGRDb21tYW5kPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcG9ydCB0aGF0IHlvdXIgYXBwbGljYXRpb24gbGlzdGVucyB0byBpbiB0aGUgY29udGFpbmVyLlxuICAgKlxuICAgKiBAZGVmYXVsdCA4MDgwXG4gICAqL1xuICByZWFkb25seSBwb3J0Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIHJ1bnRpbWUgZW52aXJvbm1lbnQgdHlwZSBmb3IgYnVpbGRpbmcgYW5kIHJ1bm5pbmcgYW4gQXBwIFJ1bm5lciBzZXJ2aWNlLiBJdCByZXByZXNlbnRzXG4gICAqIGEgcHJvZ3JhbW1pbmcgbGFuZ3VhZ2UgcnVudGltZS5cbiAgICovXG4gIHJlYWRvbmx5IHJ1bnRpbWU6IFJ1bnRpbWU7XG5cbiAgLyoqXG4gICAqIFRoZSBlbnZpcm9ubWVudCB2YXJpYWJsZXMgdGhhdCBhcmUgYXZhaWxhYmxlIHRvIHlvdXIgcnVubmluZyBBcHAgUnVubmVyIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gZW52aXJvbm1lbnQgdmFyaWFibGVzLlxuICAgKiBAZGVwcmVjYXRlZCB1c2UgZW52aXJvbm1lbnRWYXJpYWJsZXMuXG4gICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudD86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIFRoZSBlbnZpcm9ubWVudCB2YXJpYWJsZXMgdGhhdCBhcmUgYXZhaWxhYmxlIHRvIHlvdXIgcnVubmluZyBBcHAgUnVubmVyIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gZW52aXJvbm1lbnQgdmFyaWFibGVzLlxuICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRWYXJpYWJsZXM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gIC8qKlxuICAgKiBUaGUgZW52aXJvbm1lbnQgc2VjcmV0cyB0aGF0IGFyZSBhdmFpbGFibGUgdG8geW91ciBydW5uaW5nIEFwcCBSdW5uZXIgc2VydmljZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBlbnZpcm9ubWVudCBzZWNyZXRzLlxuICAgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRTZWNyZXRzPzogeyBba2V5OiBzdHJpbmddOiBTZWNyZXQgfTtcblxuICAvKipcbiAgICogVGhlIGNvbW1hbmQgQXBwIFJ1bm5lciBydW5zIHRvIHN0YXJ0IHlvdXIgYXBwbGljYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gc3RhcnQgY29tbWFuZC5cbiAgICovXG4gIHJlYWRvbmx5IHN0YXJ0Q29tbWFuZD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBBcHAgUnVubmVyIGNvbm5lY3Rpb24gdGhhdCBlbmFibGVzIHRoZSBBcHAgUnVubmVyIHNlcnZpY2UgdG8gY29ubmVjdFxuICogdG8gYSBzb3VyY2UgcmVwb3NpdG9yeS4gSXQncyByZXF1aXJlZCBmb3IgR2l0SHViIGNvZGUgcmVwb3NpdG9yaWVzLlxuICovXG5leHBvcnQgY2xhc3MgR2l0SHViQ29ubmVjdGlvbiB7XG4gIC8qKlxuICAgKiBVc2luZyBleGlzdGluZyBBcHAgUnVubmVyIGNvbm5lY3Rpb24gYnkgc3BlY2lmeWluZyB0aGUgY29ubmVjdGlvbiBBUk4uXG4gICAqIEBwYXJhbSBhcm4gY29ubmVjdGlvbiBBUk5cbiAgICogQHJldHVybnMgQ29ubmVjdGlvblxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQ29ubmVjdGlvbkFybihhcm46IHN0cmluZyk6IEdpdEh1YkNvbm5lY3Rpb24ge1xuICAgIHJldHVybiBuZXcgR2l0SHViQ29ubmVjdGlvbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIENvbm5lY3Rpb24gZm9yIEFwcCBSdW5uZXIgc2VydmljZSB0byBjb25uZWN0IHRvIHRoZSByZXBvc2l0b3J5LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3Rpb25Bcm46IHN0cmluZztcbiAgY29uc3RydWN0b3IoYXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmNvbm5lY3Rpb25Bcm4gPSBhcm47XG4gIH1cbn1cblxuLyoqXG4gKiBUaGUgaGVhbHRoIGNoZWNrIHByb3RvY29sIHR5cGVcbiAqL1xuZXhwb3J0IGVudW0gSGVhbHRoQ2hlY2tQcm90b2NvbFR5cGUge1xuICAvKipcbiAgICogSFRUUCBwcm90b2NvbFxuICAgKi9cbiAgSFRUUCA9ICdIVFRQJyxcblxuICAvKipcbiAgICogVENQIHByb3RvY29sXG4gICAqL1xuICBUQ1AgPSAnVENQJyxcbn1cblxuLyoqXG4gKiBEZXNjcmliZXMgdGhlIHNldHRpbmdzIGZvciB0aGUgaGVhbHRoIGNoZWNrIHRoYXQgQVdTIEFwcCBSdW5uZXIgcGVyZm9ybXMgdG8gbW9uaXRvciB0aGUgaGVhbHRoIG9mIGEgc2VydmljZS5cbiAqL1xuaW50ZXJmYWNlIEhlYWx0aENoZWNrQ29tbW9uT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIGNvbnNlY3V0aXZlIGNoZWNrcyB0aGF0IG11c3Qgc3VjY2VlZCBiZWZvcmUgQXBwIFJ1bm5lciBkZWNpZGVzIHRoYXQgdGhlIHNlcnZpY2UgaXMgaGVhbHRoeS5cbiAgICpcbiAgICogQGRlZmF1bHQgMVxuICAgKi9cbiAgcmVhZG9ubHkgaGVhbHRoeVRocmVzaG9sZD86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIHRpbWUgaW50ZXJ2YWwsIGluIHNlY29uZHMsIGJldHdlZW4gaGVhbHRoIGNoZWNrcy5cbiAgICpcbiAgICogQGRlZmF1bHQgRHVyYXRpb24uc2Vjb25kcyg1KVxuICAgKi9cbiAgcmVhZG9ubHkgaW50ZXJ2YWw/OiBjZGsuRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSB0aW1lLCBpbiBzZWNvbmRzLCB0byB3YWl0IGZvciBhIGhlYWx0aCBjaGVjayByZXNwb25zZSBiZWZvcmUgZGVjaWRpbmcgaXQgZmFpbGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBEdXJhdGlvbi5zZWNvbmRzKDIpXG4gICAqL1xuICByZWFkb25seSB0aW1lb3V0PzogY2RrLkR1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIGNvbnNlY3V0aXZlIGNoZWNrcyB0aGF0IG11c3QgZmFpbCBiZWZvcmUgQXBwIFJ1bm5lciBkZWNpZGVzIHRoYXQgdGhlIHNlcnZpY2UgaXMgdW5oZWFsdGh5LlxuICAgKlxuICAgKiBAZGVmYXVsdCA1XG4gICAqL1xuICByZWFkb25seSB1bmhlYWx0aHlUaHJlc2hvbGQ/OiBudW1iZXI7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB1c2VkIHRvIGRlZmluZSBIVFRQIEJhc2VkIGhlYWx0aGNoZWNrcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwSGVhbHRoQ2hlY2tPcHRpb25zIGV4dGVuZHMgSGVhbHRoQ2hlY2tDb21tb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBVUkwgdGhhdCBoZWFsdGggY2hlY2sgcmVxdWVzdHMgYXJlIHNlbnQgdG8uXG4gICAqXG4gICAqIEBkZWZhdWx0IC9cbiAgICovXG4gIHJlYWRvbmx5IHBhdGg/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB1c2VkIHRvIGRlZmluZSBUQ1AgQmFzZWQgaGVhbHRoY2hlY2tzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRjcEhlYWx0aENoZWNrT3B0aW9ucyBleHRlbmRzIEhlYWx0aENoZWNrQ29tbW9uT3B0aW9ucyB7IH1cblxuLyoqXG4gKiBDb250YWlucyBzdGF0aWMgZmFjdG9yeSBtZXRob2RzIGZvciBjcmVhdGluZyBoZWFsdGggY2hlY2tzIGZvciBkaWZmZXJlbnQgcHJvdG9jb2xzXG4gKi9cbmV4cG9ydCBjbGFzcyBIZWFsdGhDaGVjayB7XG4gIC8qKlxuICAgKiBDb25zdHJ1Y3QgYSBIVFRQIGhlYWx0aCBjaGVja1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBodHRwKG9wdGlvbnM6IEh0dHBIZWFsdGhDaGVja09wdGlvbnMgPSB7fSk6IEhlYWx0aENoZWNrIHtcbiAgICByZXR1cm4gbmV3IEhlYWx0aENoZWNrKFxuICAgICAgSGVhbHRoQ2hlY2tQcm90b2NvbFR5cGUuSFRUUCxcbiAgICAgIG9wdGlvbnMuaGVhbHRoeVRocmVzaG9sZCxcbiAgICAgIG9wdGlvbnMuaW50ZXJ2YWwsXG4gICAgICBvcHRpb25zLnRpbWVvdXQsXG4gICAgICBvcHRpb25zLnVuaGVhbHRoeVRocmVzaG9sZCxcbiAgICAgIG9wdGlvbnMucGF0aCxcbiAgICApO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdCBhIFRDUCBoZWFsdGggY2hlY2tcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgdGNwKG9wdGlvbnM6IFRjcEhlYWx0aENoZWNrT3B0aW9ucyA9IHt9KTogSGVhbHRoQ2hlY2sge1xuICAgIHJldHVybiBuZXcgSGVhbHRoQ2hlY2soXG4gICAgICBIZWFsdGhDaGVja1Byb3RvY29sVHlwZS5UQ1AsXG4gICAgICBvcHRpb25zLmhlYWx0aHlUaHJlc2hvbGQsXG4gICAgICBvcHRpb25zLmludGVydmFsLFxuICAgICAgb3B0aW9ucy50aW1lb3V0LFxuICAgICAgb3B0aW9ucy51bmhlYWx0aHlUaHJlc2hvbGQsXG4gICAgKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoXG4gICAgcHVibGljIHJlYWRvbmx5IGhlYWx0aENoZWNrUHJvdG9jb2xUeXBlOiBIZWFsdGhDaGVja1Byb3RvY29sVHlwZSxcbiAgICBwdWJsaWMgcmVhZG9ubHkgaGVhbHRoeVRocmVzaG9sZDogbnVtYmVyID0gMSxcbiAgICBwdWJsaWMgcmVhZG9ubHkgaW50ZXJ2YWw6IGNkay5EdXJhdGlvbiA9IGNkay5EdXJhdGlvbi5zZWNvbmRzKDUpLFxuICAgIHB1YmxpYyByZWFkb25seSB0aW1lb3V0OiBjZGsuRHVyYXRpb24gPSBjZGsuRHVyYXRpb24uc2Vjb25kcygyKSxcbiAgICBwdWJsaWMgcmVhZG9ubHkgdW5oZWFsdGh5VGhyZXNob2xkOiBudW1iZXIgPSA1LFxuICAgIHB1YmxpYyByZWFkb25seSBwYXRoPzogc3RyaW5nLFxuICApIHtcbiAgICBpZiAodGhpcy5oZWFsdGhDaGVja1Byb3RvY29sVHlwZSA9PT0gSGVhbHRoQ2hlY2tQcm90b2NvbFR5cGUuSFRUUCkge1xuICAgICAgaWYgKHRoaXMucGF0aCAhPT0gdW5kZWZpbmVkICYmIHRoaXMucGF0aC5sZW5ndGggPT09IDApIHtcbiAgICAgICAgdGhyb3cgbmV3IGNkay5VbnNjb3BlZFZhbGlkYXRpb25FcnJvcigncGF0aCBsZW5ndGggbXVzdCBiZSBncmVhdGVyIHRoYW4gMCcpO1xuICAgICAgfVxuICAgICAgaWYgKHRoaXMucGF0aCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIHRoaXMucGF0aCA9ICcvJztcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAodGhpcy5oZWFsdGh5VGhyZXNob2xkIDwgMSB8fCB0aGlzLmhlYWx0aHlUaHJlc2hvbGQgPiAyMCkge1xuICAgICAgdGhyb3cgbmV3IGNkay5VbnNjb3BlZFZhbGlkYXRpb25FcnJvcihgaGVhbHRoeVRocmVzaG9sZCBtdXN0IGJlIGJldHdlZW4gMSBhbmQgMjAsIGdvdCAke3RoaXMuaGVhbHRoeVRocmVzaG9sZH1gKTtcbiAgICB9XG4gICAgaWYgKHRoaXMudW5oZWFsdGh5VGhyZXNob2xkIDwgMSB8fCB0aGlzLnVuaGVhbHRoeVRocmVzaG9sZCA+IDIwKSB7XG4gICAgICB0aHJvdyBuZXcgY2RrLlVuc2NvcGVkVmFsaWRhdGlvbkVycm9yKGB1bmhlYWx0aHlUaHJlc2hvbGQgbXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDIwLCBnb3QgJHt0aGlzLnVuaGVhbHRoeVRocmVzaG9sZH1gKTtcbiAgICB9XG4gICAgaWYgKHRoaXMuaW50ZXJ2YWwudG9TZWNvbmRzKCkgPCAxIHx8IHRoaXMuaW50ZXJ2YWwudG9TZWNvbmRzKCkgPiAyMCkge1xuICAgICAgdGhyb3cgbmV3IGNkay5VbnNjb3BlZFZhbGlkYXRpb25FcnJvcihgaW50ZXJ2YWwgbXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDIwIHNlY29uZHMsIGdvdCAke3RoaXMuaW50ZXJ2YWwudG9TZWNvbmRzKCl9YCk7XG4gICAgfVxuICAgIGlmICh0aGlzLnRpbWVvdXQudG9TZWNvbmRzKCkgPCAxIHx8IHRoaXMudGltZW91dC50b1NlY29uZHMoKSA+IDIwKSB7XG4gICAgICB0aHJvdyBuZXcgY2RrLlVuc2NvcGVkVmFsaWRhdGlvbkVycm9yKGB0aW1lb3V0IG11c3QgYmUgYmV0d2VlbiAxIGFuZCAyMCBzZWNvbmRzLCBnb3QgJHt0aGlzLnRpbWVvdXQudG9TZWNvbmRzKCl9YCk7XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGJpbmQoKTogQ2ZuU2VydmljZS5IZWFsdGhDaGVja0NvbmZpZ3VyYXRpb25Qcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGhlYWx0aHlUaHJlc2hvbGQ6IHRoaXMuaGVhbHRoeVRocmVzaG9sZCxcbiAgICAgIGludGVydmFsOiB0aGlzLmludGVydmFsPy50b1NlY29uZHMoKSxcbiAgICAgIHBhdGg6IHRoaXMucGF0aCxcbiAgICAgIHByb3RvY29sOiB0aGlzLmhlYWx0aENoZWNrUHJvdG9jb2xUeXBlLFxuICAgICAgdGltZW91dDogdGhpcy50aW1lb3V0Py50b1NlY29uZHMoKSxcbiAgICAgIHVuaGVhbHRoeVRocmVzaG9sZDogdGhpcy51bmhlYWx0aHlUaHJlc2hvbGQsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIFRoZSBJUCBhZGRyZXNzIHR5cGUgZm9yIHlvdXIgaW5jb21pbmcgcHVibGljIG5ldHdvcmsgY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGVudW0gSXBBZGRyZXNzVHlwZSB7XG4gIC8qKlxuICAgKiBJUFY0XG4gICAqL1xuICBJUFY0ID0gJ0lQVjQnLFxuXG4gIC8qKlxuICAgKiBEVUFMX1NUQUNLXG4gICAqL1xuICBEVUFMX1NUQUNLID0gJ0RVQUxfU1RBQ0snLFxufVxuXG4vKipcbiAqIEF0dHJpYnV0ZXMgZm9yIHRoZSBBcHAgUnVubmVyIFNlcnZpY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZXJ2aWNlQXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgc2VydmljZS5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBVUkwgb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlVXJsOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBzdGF0dXMgb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlU3RhdHVzOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgQXBwIFJ1bm5lciBTZXJ2aWNlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElTZXJ2aWNlIGV4dGVuZHMgY2RrLklSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgTmFtZSBvZiB0aGUgc2VydmljZS5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIHNlcnZpY2UuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VBcm46IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIHNlY3JldCBlbnZpcm9ubWVudCB2YXJpYWJsZS5cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFNlY3JldCB7XG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuIGVudmlyb25tZW50IHZhcmlhYmxlIHZhbHVlIGZyb20gYSBwYXJhbWV0ZXIgc3RvcmVkIGluIEFXU1xuICAgKiBTeXN0ZW1zIE1hbmFnZXIgUGFyYW1ldGVyIFN0b3JlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tU3NtUGFyYW1ldGVyKHBhcmFtZXRlcjogc3NtLklQYXJhbWV0ZXIpOiBTZWNyZXQge1xuICAgIHJldHVybiB7XG4gICAgICBhcm46IHBhcmFtZXRlci5wYXJhbWV0ZXJBcm4sXG4gICAgICBncmFudFJlYWQ6IGdyYW50ZWUgPT4gcGFyYW1ldGVyLmdyYW50UmVhZChncmFudGVlKSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBlbnZpcm9ubWVudCB2YXJpYWJsZSB2YWx1ZSBmcm9tIGEgc2VjcmV0IHN0b3JlZCBpbiBBV1MgU2VjcmV0c1xuICAgKiBNYW5hZ2VyLlxuICAgKlxuICAgKiBAcGFyYW0gc2VjcmV0IHRoZSBzZWNyZXQgc3RvcmVkIGluIEFXUyBTZWNyZXRzIE1hbmFnZXJcbiAgICogQHBhcmFtIGZpZWxkIHRoZSBuYW1lIG9mIHRoZSBmaWVsZCB3aXRoIHRoZSB2YWx1ZSB0aGF0IHlvdSB3YW50IHRvIHNldCBhc1xuICAgKiB0aGUgZW52aXJvbm1lbnQgdmFyaWFibGUgdmFsdWUuIE9ubHkgdmFsdWVzIGluIEpTT04gZm9ybWF0IGFyZSBzdXBwb3J0ZWQuXG4gICAqIElmIHlvdSBkbyBub3Qgc3BlY2lmeSBhIEpTT04gZmllbGQsIHRoZW4gdGhlIGZ1bGwgY29udGVudCBvZiB0aGUgc2VjcmV0IGlzXG4gICAqIHVzZWQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21TZWNyZXRzTWFuYWdlcihzZWNyZXQ6IHNlY3JldHNtYW5hZ2VyLklTZWNyZXQsIGZpZWxkPzogc3RyaW5nKTogU2VjcmV0IHtcbiAgICByZXR1cm4ge1xuICAgICAgYXJuOiBmaWVsZCA/IGAke3NlY3JldC5zZWNyZXRBcm59OiR7ZmllbGR9OjpgIDogc2VjcmV0LnNlY3JldEFybixcbiAgICAgIGhhc0ZpZWxkOiAhIWZpZWxkLFxuICAgICAgZ3JhbnRSZWFkOiBncmFudGVlID0+IHNlY3JldC5ncmFudFJlYWQoZ3JhbnRlZSksXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgZW52aXJvbm1lbnQgdmFyaWFibGUgdmFsdWUgZnJvbSBhIHNlY3JldCBzdG9yZWQgaW4gQVdTIFNlY3JldHNcbiAgICogTWFuYWdlci5cbiAgICpcbiAgICogQHBhcmFtIHNlY3JldCB0aGUgc2VjcmV0IHN0b3JlZCBpbiBBV1MgU2VjcmV0cyBNYW5hZ2VyXG4gICAqIEBwYXJhbSB2ZXJzaW9uSW5mbyB0aGUgdmVyc2lvbiBpbmZvcm1hdGlvbiB0byByZWZlcmVuY2UgdGhlIHNlY3JldFxuICAgKiBAcGFyYW0gZmllbGQgdGhlIG5hbWUgb2YgdGhlIGZpZWxkIHdpdGggdGhlIHZhbHVlIHRoYXQgeW91IHdhbnQgdG8gc2V0IGFzXG4gICAqIHRoZSBlbnZpcm9ubWVudCB2YXJpYWJsZSB2YWx1ZS4gT25seSB2YWx1ZXMgaW4gSlNPTiBmb3JtYXQgYXJlIHN1cHBvcnRlZC5cbiAgICogSWYgeW91IGRvIG5vdCBzcGVjaWZ5IGEgSlNPTiBmaWVsZCwgdGhlbiB0aGUgZnVsbCBjb250ZW50IG9mIHRoZSBzZWNyZXQgaXNcbiAgICogdXNlZC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNlY3JldHNNYW5hZ2VyVmVyc2lvbihzZWNyZXQ6IHNlY3JldHNtYW5hZ2VyLklTZWNyZXQsIHZlcnNpb25JbmZvOiBTZWNyZXRWZXJzaW9uSW5mbywgZmllbGQ/OiBzdHJpbmcpOiBTZWNyZXQge1xuICAgIHJldHVybiB7XG4gICAgICBhcm46IGAke3NlY3JldC5zZWNyZXRBcm59OiR7ZmllbGQgPz8gJyd9OiR7dmVyc2lvbkluZm8udmVyc2lvblN0YWdlID8/ICcnfToke3ZlcnNpb25JbmZvLnZlcnNpb25JZCA/PyAnJ31gLFxuICAgICAgaGFzRmllbGQ6ICEhZmllbGQsXG4gICAgICBncmFudFJlYWQ6IGdyYW50ZWUgPT4gc2VjcmV0LmdyYW50UmVhZChncmFudGVlKSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIHNlY3JldFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoaXMgc2VjcmV0IHVzZXMgYSBzcGVjaWZpYyBKU09OIGZpZWxkXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgaGFzRmllbGQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBHcmFudHMgcmVhZGluZyB0aGUgc2VjcmV0IHRvIGEgcHJpbmNpcGFsXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgZ3JhbnRSZWFkKGdyYW50ZWU6IGlhbS5JR3JhbnRhYmxlKTogaWFtLkdyYW50O1xufVxuXG4vKipcbiAqIFRoZSBBcHAgUnVubmVyIFNlcnZpY2UuXG4gKi9cbkBwcm9wZXJ0eUluamVjdGFibGVcbmV4cG9ydCBjbGFzcyBTZXJ2aWNlIGV4dGVuZHMgY2RrLlJlc291cmNlIGltcGxlbWVudHMgSVNlcnZpY2UsIGlhbS5JR3JhbnRhYmxlIHtcbiAgLyoqIFVuaXF1ZWx5IGlkZW50aWZpZXMgdGhpcyBjbGFzcy4gKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBQUk9QRVJUWV9JTkpFQ1RJT05fSUQ6IHN0cmluZyA9ICdAYXdzLWNkay5hd3MtYXBwcnVubmVyLWFscGhhLlNlcnZpY2UnO1xuXG4gIC8qKlxuICAgKiBJbXBvcnQgZnJvbSBzZXJ2aWNlIG5hbWUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21TZXJ2aWNlTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBzZXJ2aWNlTmFtZTogc3RyaW5nKTogSVNlcnZpY2Uge1xuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIGNkay5SZXNvdXJjZSB7XG4gICAgICBwdWJsaWMgc2VydmljZU5hbWUgPSBzZXJ2aWNlTmFtZTtcbiAgICAgIHB1YmxpYyBzZXJ2aWNlQXJuID0gY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgIHJlc291cmNlOiAnc2VydmljZScsXG4gICAgICAgIHNlcnZpY2U6ICdhcHBydW5uZXInLFxuICAgICAgICByZXNvdXJjZU5hbWU6IHNlcnZpY2VOYW1lLFxuICAgICAgfSk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gIH1cblxuICAvKipcbiAgICogSW1wb3J0IGZyb20gc2VydmljZSBhdHRyaWJ1dGVzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tU2VydmljZUF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IFNlcnZpY2VBdHRyaWJ1dGVzKTogSVNlcnZpY2Uge1xuICAgIGNvbnN0IHNlcnZpY2VBcm4gPSBhdHRycy5zZXJ2aWNlQXJuO1xuICAgIGNvbnN0IHNlcnZpY2VOYW1lID0gYXR0cnMuc2VydmljZU5hbWU7XG4gICAgY29uc3Qgc2VydmljZVVybCA9IGF0dHJzLnNlcnZpY2VVcmw7XG4gICAgY29uc3Qgc2VydmljZVN0YXR1cyA9IGF0dHJzLnNlcnZpY2VTdGF0dXM7XG5cbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBjZGsuUmVzb3VyY2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IHNlcnZpY2VBcm4gPSBzZXJ2aWNlQXJuO1xuICAgICAgcHVibGljIHJlYWRvbmx5IHNlcnZpY2VOYW1lID0gc2VydmljZU5hbWU7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZVVybCA9IHNlcnZpY2VVcmw7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgc2VydmljZVN0YXR1cyA9IHNlcnZpY2VTdGF0dXM7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuICBwdWJsaWMgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWw6IGlhbS5JUHJpbmNpcGFsO1xuICBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTZXJ2aWNlUHJvcHM7XG4gIHByaXZhdGUgYWNjZXNzUm9sZT86IGlhbS5JUm9sZTtcbiAgcHJpdmF0ZSBpbnN0YW5jZVJvbGU6IGlhbS5JUm9sZTtcbiAgcHJpdmF0ZSBzb3VyY2U6IFNvdXJjZUNvbmZpZztcblxuICAvKipcbiAgICogRW52aXJvbm1lbnQgdmFyaWFibGVzIGZvciB0aGlzIHNlcnZpY2UuXG4gICAqXG4gICAqIEBkZXByZWNhdGVkIHVzZSBlbnZpcm9ubWVudFZhcmlhYmxlcy5cbiAgICovXG4gIHJlYWRvbmx5IGVudmlyb25tZW50OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9ID0ge307XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IHNlY3JldHMgZm9yIHRoaXMgc2VydmljZS5cbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgc2VjcmV0czogRW52aXJvbm1lbnRTZWNyZXRbXSA9IFtdO1xuXG4gIC8qKlxuICAgKiBFbnZpcm9ubWVudCB2YXJpYWJsZXMgZm9yIHRoaXMgc2VydmljZS5cbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgdmFyaWFibGVzOiBFbnZpcm9ubWVudFZhcmlhYmxlW10gPSBbXTtcblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgU2VydmljZS5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgc2VydmljZUFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgSUQgb2YgdGhlIFNlcnZpY2UuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgVVJMIG9mIHRoZSBTZXJ2aWNlLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlVXJsOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBzdGF0dXMgb2YgdGhlIFNlcnZpY2UuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VTdGF0dXM6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlTmFtZTogc3RyaW5nO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VydmljZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAvLyBFbmhhbmNlZCBDREsgQW5hbHl0aWNzIFRlbGVtZXRyeVxuICAgIGFkZENvbnN0cnVjdE1ldGFkYXRhKHRoaXMsIHByb3BzKTtcblxuICAgIGNvbnN0IHNvdXJjZSA9IHByb3BzLnNvdXJjZS5iaW5kKHRoaXMpO1xuICAgIHRoaXMuc291cmNlID0gc291cmNlO1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcblxuICAgIHRoaXMuaW5zdGFuY2VSb2xlID0gdGhpcy5wcm9wcy5pbnN0YW5jZVJvbGUgPz8gdGhpcy5jcmVhdGVJbnN0YW5jZVJvbGUoKTtcbiAgICB0aGlzLmdyYW50UHJpbmNpcGFsID0gdGhpcy5pbnN0YW5jZVJvbGU7XG5cbiAgICBjb25zdCBlbnZpcm9ubWVudFZhcmlhYmxlcyA9IHRoaXMuZ2V0RW52aXJvbm1lbnRWYXJpYWJsZXMoKTtcbiAgICBjb25zdCBlbnZpcm9ubWVudFNlY3JldHMgPSB0aGlzLmdldEVudmlyb25tZW50U2VjcmV0cygpO1xuXG4gICAgZm9yIChjb25zdCBba2V5LCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMoZW52aXJvbm1lbnRWYXJpYWJsZXMpKSB7XG4gICAgICB0aGlzLmFkZEVudmlyb25tZW50VmFyaWFibGUoa2V5LCB2YWx1ZSk7XG4gICAgfVxuICAgIGZvciAoY29uc3QgW2tleSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGVudmlyb25tZW50U2VjcmV0cykpIHtcbiAgICAgIHRoaXMuYWRkU2VjcmV0KGtleSwgdmFsdWUpO1xuICAgIH1cblxuICAgIC8vIGdlbmVyYXRlIGFuIElBTSByb2xlIG9ubHkgd2hlbiBJbWFnZVJlcG9zaXRvcnlUeXBlIGlzIEVDUiBhbmQgcHJvcHMuYWNjZXNzUm9sZSBpcyB1bmRlZmluZWRcbiAgICB0aGlzLmFjY2Vzc1JvbGUgPSAodGhpcy5zb3VyY2UuaW1hZ2VSZXBvc2l0b3J5Py5pbWFnZVJlcG9zaXRvcnlUeXBlID09IEltYWdlUmVwb3NpdG9yeVR5cGUuRUNSKSA/XG4gICAgICB0aGlzLnByb3BzLmFjY2Vzc1JvbGUgPz8gdGhpcy5nZW5lcmF0ZURlZmF1bHRSb2xlKCkgOiB1bmRlZmluZWQ7XG5cbiAgICBpZiAodGhpcy5zb3VyY2UuY29kZVJlcG9zaXRvcnk/LmNvZGVDb25maWd1cmF0aW9uLmNvbmZpZ3VyYXRpb25Tb3VyY2UgPT0gQ29uZmlndXJhdGlvblNvdXJjZVR5cGUuUkVQT1NJVE9SWSAmJlxuICAgICAgdGhpcy5zb3VyY2UuY29kZVJlcG9zaXRvcnk/LmNvZGVDb25maWd1cmF0aW9uLmNvbmZpZ3VyYXRpb25WYWx1ZXMpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKCdjb25maWd1cmF0aW9uVmFsdWVzIGNhbm5vdCBiZSBwcm92aWRlZCBpZiB0aGUgQ29uZmlndXJhdGlvblNvdXJjZSBpcyBSZXBvc2l0b3J5JywgdGhpcyk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnNlcnZpY2VOYW1lICE9PSB1bmRlZmluZWQgJiYgIWNkay5Ub2tlbi5pc1VucmVzb2x2ZWQocHJvcHMuc2VydmljZU5hbWUpKSB7XG4gICAgICBpZiAocHJvcHMuc2VydmljZU5hbWUubGVuZ3RoIDwgNCB8fCBwcm9wcy5zZXJ2aWNlTmFtZS5sZW5ndGggPiA0MCkge1xuICAgICAgICB0aHJvdyBuZXcgY2RrLlZhbGlkYXRpb25FcnJvcihcbiAgICAgICAgICBgXFxgc2VydmljZU5hbWVcXGAgbXVzdCBiZSBiZXR3ZWVuIDQgYW5kIDQwIGNoYXJhY3RlcnMsIGdvdDogJHtwcm9wcy5zZXJ2aWNlTmFtZS5sZW5ndGh9IGNoYXJhY3RlcnMuYCwgdGhpcyxcbiAgICAgICAgKTtcbiAgICAgIH1cblxuICAgICAgaWYgKCEvXltBLVphLXowLTldW0EtWmEtejAtOVxcLV9dKiQvLnRlc3QocHJvcHMuc2VydmljZU5hbWUpKSB7XG4gICAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKFxuICAgICAgICAgIGBcXGBzZXJ2aWNlTmFtZVxcYCBtdXN0IHN0YXJ0IHdpdGggYW4gYWxwaGFudW1lcmljIGNoYXJhY3RlciBhbmQgY29udGFpbiBvbmx5IGFscGhhbnVtZXJpYyBjaGFyYWN0ZXJzLCBoeXBoZW5zLCBvciB1bmRlcnNjb3JlcyBhZnRlciB0aGF0LCBnb3Q6ICR7cHJvcHMuc2VydmljZU5hbWV9LmAsIHRoaXMsXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuU2VydmljZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlTmFtZTogdGhpcy5wcm9wcy5zZXJ2aWNlTmFtZSxcbiAgICAgIGluc3RhbmNlQ29uZmlndXJhdGlvbjoge1xuICAgICAgICBjcHU6IHRoaXMucHJvcHMuY3B1Py51bml0LFxuICAgICAgICBtZW1vcnk6IHRoaXMucHJvcHMubWVtb3J5Py51bml0LFxuICAgICAgICBpbnN0YW5jZVJvbGVBcm46IExhenkuc3RyaW5nKHsgcHJvZHVjZTogKCkgPT4gdGhpcy5pbnN0YW5jZVJvbGU/LnJvbGVBcm4gfSksXG4gICAgICB9LFxuICAgICAgc291cmNlQ29uZmlndXJhdGlvbjoge1xuICAgICAgICBhdXRoZW50aWNhdGlvbkNvbmZpZ3VyYXRpb246IHRoaXMucmVuZGVyQXV0aGVudGljYXRpb25Db25maWd1cmF0aW9uKCksXG4gICAgICAgIGF1dG9EZXBsb3ltZW50c0VuYWJsZWQ6IHRoaXMucHJvcHMuYXV0b0RlcGxveW1lbnRzRW5hYmxlZCxcbiAgICAgICAgaW1hZ2VSZXBvc2l0b3J5OiB0aGlzLnNvdXJjZS5pbWFnZVJlcG9zaXRvcnkgP1xuICAgICAgICAgIHRoaXMucmVuZGVySW1hZ2VSZXBvc2l0b3J5KHRoaXMuc291cmNlLmltYWdlUmVwb3NpdG9yeSEpIDpcbiAgICAgICAgICB1bmRlZmluZWQsXG4gICAgICAgIGNvZGVSZXBvc2l0b3J5OiB0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeSA/XG4gICAgICAgICAgdGhpcy5yZW5kZXJDb2RlQ29uZmlndXJhdGlvbih0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeSEuY29kZUNvbmZpZ3VyYXRpb24uY29uZmlndXJhdGlvblZhbHVlcyEpIDpcbiAgICAgICAgICB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgICAgZW5jcnlwdGlvbkNvbmZpZ3VyYXRpb246IHRoaXMucHJvcHMua21zS2V5ID8ge1xuICAgICAgICBrbXNLZXk6IHRoaXMucHJvcHMua21zS2V5LmtleUFybixcbiAgICAgIH0gOiB1bmRlZmluZWQsXG4gICAgICBhdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm46IHRoaXMucHJvcHMuYXV0b1NjYWxpbmdDb25maWd1cmF0aW9uPy5hdXRvU2NhbGluZ0NvbmZpZ3VyYXRpb25Bcm4sXG4gICAgICBuZXR3b3JrQ29uZmlndXJhdGlvbjoge1xuICAgICAgICBlZ3Jlc3NDb25maWd1cmF0aW9uOiB7XG4gICAgICAgICAgZWdyZXNzVHlwZTogdGhpcy5wcm9wcy52cGNDb25uZWN0b3IgPyAnVlBDJyA6ICdERUZBVUxUJyxcbiAgICAgICAgICB2cGNDb25uZWN0b3JBcm46IHRoaXMucHJvcHMudnBjQ29ubmVjdG9yPy52cGNDb25uZWN0b3JBcm4sXG4gICAgICAgIH0sXG4gICAgICAgIGluZ3Jlc3NDb25maWd1cmF0aW9uOiBwcm9wcy5pc1B1YmxpY2x5QWNjZXNzaWJsZSAhPT0gdW5kZWZpbmVkID8geyBpc1B1YmxpY2x5QWNjZXNzaWJsZTogcHJvcHMuaXNQdWJsaWNseUFjY2Vzc2libGUgfSA6IHVuZGVmaW5lZCxcbiAgICAgICAgaXBBZGRyZXNzVHlwZTogdGhpcy5wcm9wcy5pcEFkZHJlc3NUeXBlLFxuICAgICAgfSxcbiAgICAgIGhlYWx0aENoZWNrQ29uZmlndXJhdGlvbjogdGhpcy5wcm9wcy5oZWFsdGhDaGVjayA/XG4gICAgICAgIHRoaXMucHJvcHMuaGVhbHRoQ2hlY2suYmluZCgpIDpcbiAgICAgICAgdW5kZWZpbmVkLFxuICAgICAgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb246IHByb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uID8ge1xuICAgICAgICBvYnNlcnZhYmlsaXR5RW5hYmxlZDogdHJ1ZSxcbiAgICAgICAgb2JzZXJ2YWJpbGl0eUNvbmZpZ3VyYXRpb25Bcm46IHByb3BzLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uLm9ic2VydmFiaWxpdHlDb25maWd1cmF0aW9uQXJuLFxuICAgICAgfSA6IHVuZGVmaW5lZCxcbiAgICB9KTtcblxuICAgIC8vIGdyYW50IHJlcXVpcmVkIHByaXZpbGVnZXMgZm9yIHRoZSByb2xlIHRvIGFjY2VzcyBhbiBpbWFnZSBpbiBBbWF6b24gRUNSXG4gICAgLy8gU2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBydW5uZXIvbGF0ZXN0L2RnL3NlY3VyaXR5X2lhbV9zZXJ2aWNlLXdpdGgtaWFtLmh0bWwjc2VjdXJpdHlfaWFtX3NlcnZpY2Utd2l0aC1pYW0tcm9sZXNcbiAgICBpZiAodGhpcy5zb3VyY2UuZWNyUmVwb3NpdG9yeSAmJiB0aGlzLmFjY2Vzc1JvbGUpIHtcbiAgICAgIHRoaXMuc291cmNlLmVjclJlcG9zaXRvcnkuZ3JhbnRQdWxsKHRoaXMuYWNjZXNzUm9sZSk7XG4gICAgICB0aGlzLnNvdXJjZS5lY3JSZXBvc2l0b3J5LmdyYW50KHRoaXMuYWNjZXNzUm9sZSwgJ2VjcjpEZXNjcmliZUltYWdlcycpO1xuICAgIH1cblxuICAgIHRoaXMuc2VydmljZUFybiA9IHJlc291cmNlLmF0dHJTZXJ2aWNlQXJuO1xuICAgIHRoaXMuc2VydmljZUlkID0gcmVzb3VyY2UuYXR0clNlcnZpY2VJZDtcbiAgICB0aGlzLnNlcnZpY2VVcmwgPSByZXNvdXJjZS5hdHRyU2VydmljZVVybDtcbiAgICB0aGlzLnNlcnZpY2VTdGF0dXMgPSByZXNvdXJjZS5hdHRyU3RhdHVzO1xuICAgIC8qKlxuICAgICAqIENsb3VkZm9ybWF0b24gZG9lcyBub3QgcmV0dXJuIHRoZSBzZXJ2aWNlTmFtZSBhdHRyaWJ1dGUgc28gd2UgZXh0cmFjdCBpdCBmcm9tIHRoZSBzZXJ2aWNlQXJuLlxuICAgICAqIFRoZSBBUk4gY29tZXMgd2l0aCB0aGlzIGZvcm1hdDpcbiAgICAgKiBhcm46YXdzOmFwcHJ1bm5lcjp1cy1lYXN0LTE6MTIzNDU2Nzg5MDEyOnNlcnZpY2UvU0VSVklDRV9OQU1FL1NFUlZJQ0VfSURcbiAgICAgKi9cbiAgICAvLyBGaXJzdCwgZ2V0IHRoZSBsYXN0IGVsZW1lbnQgYnkgc3BsaXR0aW5nIHdpdGggJzonXG4gICAgY29uc3QgcmVzb3VyY2VGdWxsTmFtZSA9IGNkay5Gbi5zZWxlY3QoNSwgY2RrLkZuLnNwbGl0KCc6JywgdGhpcy5zZXJ2aWNlQXJuKSk7XG4gICAgLy8gTm93LCBzcGxpdCB0aGUgcmVzb3VyY2VGdWxsTmFtZSB3aXRoICcvJyB0byBnZXQgdGhlIHNlcnZpY2VOYW1lXG4gICAgdGhpcy5zZXJ2aWNlTmFtZSA9IGNkay5Gbi5zZWxlY3QoMSwgY2RrLkZuLnNwbGl0KCcvJywgcmVzb3VyY2VGdWxsTmFtZSkpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSBzdGF0ZW1lbnQgdG8gdGhlIGluc3RhbmNlIHJvbGUuXG4gICAqL1xuICBATWV0aG9kTWV0YWRhdGEoKVxuICBwdWJsaWMgYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudDogaWFtLlBvbGljeVN0YXRlbWVudCkge1xuICAgIHRoaXMuaW5zdGFuY2VSb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KHN0YXRlbWVudCk7XG4gIH1cblxuICAvKipcbiAgICogVGhpcyBtZXRob2QgYWRkcyBhbiBlbnZpcm9ubWVudCB2YXJpYWJsZSB0byB0aGUgQXBwIFJ1bm5lciBzZXJ2aWNlLlxuICAgKi9cbiAgQE1ldGhvZE1ldGFkYXRhKClcbiAgcHVibGljIGFkZEVudmlyb25tZW50VmFyaWFibGUobmFtZTogc3RyaW5nLCB2YWx1ZTogc3RyaW5nKSB7XG4gICAgaWYgKG5hbWUuc3RhcnRzV2l0aCgnQVdTQVBQUlVOTkVSJykpIHtcbiAgICAgIHRocm93IG5ldyBjZGsuVmFsaWRhdGlvbkVycm9yKGBFbnZpcm9ubWVudCB2YXJpYWJsZSBrZXkgJHtuYW1lfSB3aXRoIGEgcHJlZml4IG9mIEFXU0FQUFJVTk5FUiBpcyBub3QgYWxsb3dlZGAsIHRoaXMpO1xuICAgIH1cbiAgICB0aGlzLnZhcmlhYmxlcy5wdXNoKHsgbmFtZTogbmFtZSwgdmFsdWU6IHZhbHVlIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgbWV0aG9kIGFkZHMgYSBzZWNyZXQgYXMgZW52aXJvbm1lbnQgdmFyaWFibGUgdG8gdGhlIEFwcCBSdW5uZXIgc2VydmljZS5cbiAgICovXG4gIEBNZXRob2RNZXRhZGF0YSgpXG4gIHB1YmxpYyBhZGRTZWNyZXQobmFtZTogc3RyaW5nLCBzZWNyZXQ6IFNlY3JldCkge1xuICAgIGlmIChuYW1lLnN0YXJ0c1dpdGgoJ0FXU0FQUFJVTk5FUicpKSB7XG4gICAgICB0aHJvdyBuZXcgY2RrLlZhbGlkYXRpb25FcnJvcihgRW52aXJvbm1lbnQgc2VjcmV0IGtleSAke25hbWV9IHdpdGggYSBwcmVmaXggb2YgQVdTQVBQUlVOTkVSIGlzIG5vdCBhbGxvd2VkYCwgdGhpcyk7XG4gICAgfVxuICAgIHNlY3JldC5ncmFudFJlYWQodGhpcy5pbnN0YW5jZVJvbGUpO1xuICAgIHRoaXMuc2VjcmV0cy5wdXNoKHsgbmFtZTogbmFtZSwgdmFsdWU6IHNlY3JldC5hcm4gfSk7XG4gIH1cblxuICAvKipcbiAgICogVGhpcyBtZXRob2QgZ2VuZXJhdGVzIGFuIEluc3RhbmNlIFJvbGUuIE5lZWRlZCBpZiB1c2luZyBzZWNyZXRzIGFuZCBwcm9wcy5pbnN0YW5jZVJvbGUgaXMgdW5kZWZpbmVkXG4gICAqIEByZXR1cm5zIGlhbS5JUm9sZVxuICAgKi9cbiAgcHJpdmF0ZSBjcmVhdGVJbnN0YW5jZVJvbGUoKTogaWFtLklSb2xlIHtcbiAgICByZXR1cm4gbmV3IGlhbS5Sb2xlKHRoaXMsICdJbnN0YW5jZVJvbGUnLCB7XG4gICAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgndGFza3MuYXBwcnVubmVyLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIHJvbGVOYW1lOiBjZGsuUGh5c2ljYWxOYW1lLkdFTkVSQVRFX0lGX05FRURFRCxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGlzIG1ldGhvZCBnZW5lcmF0ZXMgYW4gQWNjZXNzIFJvbGUgb25seSB3aGVuIEltYWdlUmVwb3NpdG9yeVR5cGUgaXMgRUNSIGFuZCBwcm9wcy5hY2Nlc3NSb2xlIGlzIHVuZGVmaW5lZFxuICAgKiBAcmV0dXJucyBpYW0uSVJvbGVcbiAgICovXG4gIHByaXZhdGUgZ2VuZXJhdGVEZWZhdWx0Um9sZSgpOiBpYW0uUm9sZSB7XG4gICAgY29uc3QgYWNjZXNzUm9sZSA9IG5ldyBpYW0uUm9sZSh0aGlzLCAnQWNjZXNzUm9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdidWlsZC5hcHBydW5uZXIuYW1hem9uYXdzLmNvbScpLFxuICAgIH0pO1xuICAgIGFjY2Vzc1JvbGUuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydlY3I6R2V0QXV0aG9yaXphdGlvblRva2VuJ10sXG4gICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgIH0pKTtcbiAgICB0aGlzLmFjY2Vzc1JvbGUgPSBhY2Nlc3NSb2xlO1xuICAgIHJldHVybiBhY2Nlc3NSb2xlO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXRFbnZpcm9ubWVudFNlY3JldHMoKTogeyBba2V5OiBzdHJpbmddOiBTZWNyZXQgfSB7XG4gICAgbGV0IHNlY3JldHMgPSB0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeT8uY29kZUNvbmZpZ3VyYXRpb24uY29uZmlndXJhdGlvblZhbHVlcz8uZW52aXJvbm1lbnRTZWNyZXRzID8/XG4gICAgICB0aGlzLnNvdXJjZS5pbWFnZVJlcG9zaXRvcnk/LmltYWdlQ29uZmlndXJhdGlvbj8uZW52aXJvbm1lbnRTZWNyZXRzO1xuXG4gICAgcmV0dXJuIHNlY3JldHMgfHwge307XG4gIH1cblxuICBwcml2YXRlIGdldEVudmlyb25tZW50VmFyaWFibGVzKCk6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0ge1xuICAgIGxldCBjb2RlRW52ID0gW1xuICAgICAgdGhpcy5zb3VyY2UuY29kZVJlcG9zaXRvcnk/LmNvZGVDb25maWd1cmF0aW9uLmNvbmZpZ3VyYXRpb25WYWx1ZXM/LmVudmlyb25tZW50VmFyaWFibGVzLFxuICAgICAgdGhpcy5zb3VyY2UuY29kZVJlcG9zaXRvcnk/LmNvZGVDb25maWd1cmF0aW9uLmNvbmZpZ3VyYXRpb25WYWx1ZXM/LmVudmlyb25tZW50LFxuICAgIF07XG4gICAgbGV0IGltYWdlRW52ID0gW1xuICAgICAgdGhpcy5zb3VyY2UuaW1hZ2VSZXBvc2l0b3J5Py5pbWFnZUNvbmZpZ3VyYXRpb24/LmVudmlyb25tZW50VmFyaWFibGVzLFxuICAgICAgdGhpcy5zb3VyY2UuaW1hZ2VSZXBvc2l0b3J5Py5pbWFnZUNvbmZpZ3VyYXRpb24/LmVudmlyb25tZW50LFxuICAgIF07XG5cbiAgICBpZiAoY29kZUVudi5ldmVyeShlbCA9PiBlbCAhPT0gdW5kZWZpbmVkKSB8fCBpbWFnZUVudi5ldmVyeShlbCA9PiBlbCAhPT0gdW5kZWZpbmVkKSkge1xuICAgICAgdGhyb3cgbmV3IGNkay5WYWxpZGF0aW9uRXJyb3IoW1xuICAgICAgICAnWW91IGNhbm5vdCBzZXQgYm90aCBcXCdlbnZpcm9ubWVudFZhcmlhYmxlc1xcJyBhbmQgXFwnZW52aXJvbm1lbnRcXCcgcHJvcGVydGllcy4nLFxuICAgICAgICAnUGxlYXNlIG9ubHkgdXNlIGVudmlyb25tZW50VmFyaWFibGVzLCBhcyBlbnZpcm9ubWVudCBpcyBkZXByZWNhdGVkLicsXG4gICAgICBdLmpvaW4oJyAnKSwgdGhpcyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGNvZGVFbnYuZmluZChlbCA9PiBlbCAhPT0gdW5kZWZpbmVkKSB8fCBpbWFnZUVudi5maW5kKGVsID0+IGVsICE9PSB1bmRlZmluZWQpIHx8IHt9O1xuICB9XG5cbiAgcHJpdmF0ZSByZW5kZXJBdXRoZW50aWNhdGlvbkNvbmZpZ3VyYXRpb24oKTogQXV0aGVudGljYXRpb25Db25maWd1cmF0aW9uIHtcbiAgICByZXR1cm4ge1xuICAgICAgYWNjZXNzUm9sZUFybjogdGhpcy5hY2Nlc3NSb2xlPy5yb2xlQXJuLFxuICAgICAgY29ubmVjdGlvbkFybjogdGhpcy5zb3VyY2UuY29kZVJlcG9zaXRvcnk/LmNvbm5lY3Rpb24/LmNvbm5lY3Rpb25Bcm4sXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgcmVuZGVyQ29kZUNvbmZpZ3VyYXRpb24ocHJvcHM6IENvZGVDb25maWd1cmF0aW9uVmFsdWVzKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGNvZGVDb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGNvbmZpZ3VyYXRpb25Tb3VyY2U6IHRoaXMuc291cmNlLmNvZGVSZXBvc2l0b3J5IS5jb2RlQ29uZmlndXJhdGlvbi5jb25maWd1cmF0aW9uU291cmNlLFxuICAgICAgICAvLyBjb2RlQ29uZmlndXJhdGlvblZhbHVlcyB3aWxsIGJlIGlnbm9yZWQgaWYgY29uZmlndXJhdGlvblNvdXJjZSBpcyBSRVBPU0lUT1JZXG4gICAgICAgIGNvZGVDb25maWd1cmF0aW9uVmFsdWVzOiB0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeSEuY29kZUNvbmZpZ3VyYXRpb24uY29uZmlndXJhdGlvblZhbHVlcyA/XG4gICAgICAgICAgdGhpcy5yZW5kZXJDb2RlQ29uZmlndXJhdGlvblZhbHVlcyhwcm9wcykgOlxuICAgICAgICAgIHVuZGVmaW5lZCxcbiAgICAgIH0sXG4gICAgICByZXBvc2l0b3J5VXJsOiB0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeSEucmVwb3NpdG9yeVVybCxcbiAgICAgIHNvdXJjZUNvZGVWZXJzaW9uOiB0aGlzLnNvdXJjZS5jb2RlUmVwb3NpdG9yeSEuc291cmNlQ29kZVZlcnNpb24sXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgcmVuZGVyQ29kZUNvbmZpZ3VyYXRpb25WYWx1ZXMocHJvcHM6IENvZGVDb25maWd1cmF0aW9uVmFsdWVzKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgcG9ydDogcHJvcHMucG9ydCxcbiAgICAgIGJ1aWxkQ29tbWFuZDogcHJvcHMuYnVpbGRDb21tYW5kLFxuICAgICAgcnVudGltZTogcHJvcHMucnVudGltZS5uYW1lLFxuICAgICAgcnVudGltZUVudmlyb25tZW50VmFyaWFibGVzOiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMucmVuZGVyRW52aXJvbm1lbnRWYXJpYWJsZXMoKSB9KSxcbiAgICAgIHJ1bnRpbWVFbnZpcm9ubWVudFNlY3JldHM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5yZW5kZXJFbnZpcm9ubWVudFNlY3JldHMoKSB9KSxcbiAgICAgIHN0YXJ0Q29tbWFuZDogcHJvcHMuc3RhcnRDb21tYW5kLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHJlbmRlckVudmlyb25tZW50VmFyaWFibGVzKCk6IEVudmlyb25tZW50VmFyaWFibGVbXSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKHRoaXMudmFyaWFibGVzLmxlbmd0aCA+IDApIHtcbiAgICAgIHJldHVybiB0aGlzLnZhcmlhYmxlcztcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIHJlbmRlckVudmlyb25tZW50U2VjcmV0cygpOiBFbnZpcm9ubWVudFNlY3JldFtdIHwgdW5kZWZpbmVkIHtcbiAgICBpZiAodGhpcy5zZWNyZXRzLmxlbmd0aCA+IDAgJiYgdGhpcy5pbnN0YW5jZVJvbGUpIHtcbiAgICAgIHJldHVybiB0aGlzLnNlY3JldHM7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiB1bmRlZmluZWQ7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSByZW5kZXJJbWFnZVJlcG9zaXRvcnkocmVwbzogSW1hZ2VSZXBvc2l0b3J5KTogYW55IHtcbiAgICByZXR1cm4gT2JqZWN0LmFzc2lnbihyZXBvLCB7XG4gICAgICBpbWFnZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgcG9ydDogcmVwby5pbWFnZUNvbmZpZ3VyYXRpb24/LnBvcnQ/LnRvU3RyaW5nKCksXG4gICAgICAgIHN0YXJ0Q29tbWFuZDogcmVwby5pbWFnZUNvbmZpZ3VyYXRpb24/LnN0YXJ0Q29tbWFuZCxcbiAgICAgICAgcnVudGltZUVudmlyb25tZW50VmFyaWFibGVzOiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMucmVuZGVyRW52aXJvbm1lbnRWYXJpYWJsZXMoKSB9KSxcbiAgICAgICAgcnVudGltZUVudmlyb25tZW50U2VjcmV0czogTGF6eS5hbnkoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLnJlbmRlckVudmlyb25tZW50U2VjcmV0cygpIH0pLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19