import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { Connections } from 'aws-cdk-lib/aws-ec2';
import * as cdk from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
/**
 * Properties of the AppRunner VPC Connector
 */
export interface VpcConnectorProps {
    /**
     * The VPC for the VPC Connector.
     */
    readonly vpc: ec2.IVpc;
    /**
     * Where to place the VPC Connector within the VPC.
     *
     * @default - Private subnets.
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets.
     *
     * @default - a new security group will be created in the specified VPC
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * The name for the VpcConnector.
     *
     * @default - a name generated by CloudFormation
     */
    readonly vpcConnectorName?: string;
}
/**
 * Attributes for the App Runner VPC Connector
 */
export interface VpcConnectorAttributes {
    /**
     * The name of the VPC connector.
     */
    readonly vpcConnectorName: string;
    /**
     * The ARN of the VPC connector.
     */
    readonly vpcConnectorArn: string;
    /**
     * The revision of the VPC connector.
     */
    readonly vpcConnectorRevision: number;
    /**
     * The security groups associated with the VPC connector.
     */
    readonly securityGroups: ec2.ISecurityGroup[];
}
/**
 * Represents the App Runner VPC Connector.
 */
export interface IVpcConnector extends cdk.IResource, ec2.IConnectable {
    /**
     * The Name of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorName: string;
    /**
     * The ARN of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorArn: string;
    /**
     * The revision of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorRevision: number;
}
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
export declare class VpcConnector extends cdk.Resource implements IVpcConnector {
    /** Uniquely identifies this class. */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope: Construct, id: string, attrs: VpcConnectorAttributes): IVpcConnector;
    /**
     * The ARN of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorArn: string;
    /**
     * The revision of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorRevision: number;
    /**
     * The name of the VPC connector.
     * @attribute
     */
    readonly vpcConnectorName: string;
    /**
     * Allows specifying security group connections for the VPC connector.
     */
    readonly connections: Connections;
    constructor(scope: Construct, id: string, props: VpcConnectorProps);
}
