# coding: utf-8

"""
    Automox Console API

    API for use with the Automox Console  # noqa: E501

    OpenAPI spec version: 2021-09-20
    Contact: support@automox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from automox_console_sdk.api_client import ApiClient


class ExtractsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_extract(self, body, o, **kwargs):  # noqa: E501
        """Creates a new Data Extract.  # noqa: E501

        Create a new Data Extract.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_extract(body, o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataextractsBody body: Create Data Extract (required)
        :param int o: Organization ID (required)
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_extract_with_http_info(body, o, **kwargs)  # noqa: E501
        else:
            (data) = self.create_extract_with_http_info(body, o, **kwargs)  # noqa: E501
            return data

    def create_extract_with_http_info(self, body, o, **kwargs):  # noqa: E501
        """Creates a new Data Extract.  # noqa: E501

        Create a new Data Extract.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_extract_with_http_info(body, o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataextractsBody body: Create Data Extract (required)
        :param int o: Organization ID (required)
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'o']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_extract" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_extract`")  # noqa: E501
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `create_extract`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data-extracts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataExtract]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_data_extract(self, id, o, **kwargs):  # noqa: E501
        """Download the CSV for a completed Data Extract job.  # noqa: E501

        Downloads the CSV for a completed Data Extract job. Triggers an automatic download of the CSV file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_data_extract(id, o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The ID of the Data Extract to download. (required)
        :param int o: Organization ID (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_data_extract_with_http_info(id, o, **kwargs)  # noqa: E501
        else:
            (data) = self.download_data_extract_with_http_info(id, o, **kwargs)  # noqa: E501
            return data

    def download_data_extract_with_http_info(self, id, o, **kwargs):  # noqa: E501
        """Download the CSV for a completed Data Extract job.  # noqa: E501

        Downloads the CSV for a completed Data Extract job. Triggers an automatic download of the CSV file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_data_extract_with_http_info(id, o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The ID of the Data Extract to download. (required)
        :param int o: Organization ID (required)
        :return: Object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'o']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_data_extract" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `download_data_extract`")  # noqa: E501
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `download_data_extract`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data-extracts/{id}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_extract_by_id(self, id, **kwargs):  # noqa: E501
        """Show a new Data Extract job.  # noqa: E501

        Retrieves a specific Data Extract job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_extract_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The ID of the Data Extract you want to view. (required)
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_extract_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_extract_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_data_extract_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Show a new Data Extract job.  # noqa: E501

        Retrieves a specific Data Extract job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_extract_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The ID of the Data Extract you want to view. (required)
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_extract_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_data_extract_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data-extracts/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataExtract]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_extracts(self, o, **kwargs):  # noqa: E501
        """List all Data Extracts for an Organization  # noqa: E501

        List all Data extracts for an organization with ability to filter and sort results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_extracts(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Limit response to a specific Automox organization (required)
        :param int limit: A limit on the number of results to be returned, between 1 and 500, with a default of 25. Use with `page` parameter. See [About Automox API - Pagination](/developer-portal/about-ax-api/#pagination)
        :param int page: The page of results you wish to be returned with page numbers starting at 0. Default: 0. See [About Automox API - Pagination](/developer-portal/about-ax-api/#pagination)
        :param list[str] sort: The sort for the results. Options: `created_at:desc/asc` and `status:desc/asc`. Default: `created_at:desc`
        :param str typeequals: The type of Data Extracts to list. Options: `patch-history`.
        :param datetime created_atgreater_than: Created at date is greater than the value submitted. If a time is not specified, greater_than will have a time of start of day.
        :param datetime created_atlesser_than: Created at date is less than the value submitted. If a time is not specified, less_than will have a time of end of day.
        :param datetime created_atgreater_than_or_equals: Created at date is greater than or equals the value submitted. If a time is not specified, greater_than_or_equals will have a time of start of day.
        :param datetime created_atlesser_than_or_equals: Created at date is lesser than or equals the value submitted. If a time is not specified, less_than_or_equals will have a time of end of day.
        :param str statusequals: Find jobs with a specific status. Options: queued, running, complete, failed, canceled, expired
        :param list[str] statusin: Find jobs with one or more of these statuses.
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_extracts_with_http_info(o, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_extracts_with_http_info(o, **kwargs)  # noqa: E501
            return data

    def get_data_extracts_with_http_info(self, o, **kwargs):  # noqa: E501
        """List all Data Extracts for an Organization  # noqa: E501

        List all Data extracts for an organization with ability to filter and sort results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_extracts_with_http_info(o, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int o: Limit response to a specific Automox organization (required)
        :param int limit: A limit on the number of results to be returned, between 1 and 500, with a default of 25. Use with `page` parameter. See [About Automox API - Pagination](/developer-portal/about-ax-api/#pagination)
        :param int page: The page of results you wish to be returned with page numbers starting at 0. Default: 0. See [About Automox API - Pagination](/developer-portal/about-ax-api/#pagination)
        :param list[str] sort: The sort for the results. Options: `created_at:desc/asc` and `status:desc/asc`. Default: `created_at:desc`
        :param str typeequals: The type of Data Extracts to list. Options: `patch-history`.
        :param datetime created_atgreater_than: Created at date is greater than the value submitted. If a time is not specified, greater_than will have a time of start of day.
        :param datetime created_atlesser_than: Created at date is less than the value submitted. If a time is not specified, less_than will have a time of end of day.
        :param datetime created_atgreater_than_or_equals: Created at date is greater than or equals the value submitted. If a time is not specified, greater_than_or_equals will have a time of start of day.
        :param datetime created_atlesser_than_or_equals: Created at date is lesser than or equals the value submitted. If a time is not specified, less_than_or_equals will have a time of end of day.
        :param str statusequals: Find jobs with a specific status. Options: queued, running, complete, failed, canceled, expired
        :param list[str] statusin: Find jobs with one or more of these statuses.
        :return: list[DataExtract]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['o', 'limit', 'page', 'sort', 'typeequals', 'created_atgreater_than', 'created_atlesser_than', 'created_atgreater_than_or_equals', 'created_atlesser_than_or_equals', 'statusequals', 'statusin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_extracts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'o' is set
        if ('o' not in params or
                params['o'] is None):
            raise ValueError("Missing the required parameter `o` when calling `get_data_extracts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'o' in params:
            query_params.append(('o', params['o']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'typeequals' in params:
            query_params.append(('type:equals', params['typeequals']))  # noqa: E501
        if 'created_atgreater_than' in params:
            query_params.append(('created_at:greater_than', params['created_atgreater_than']))  # noqa: E501
        if 'created_atlesser_than' in params:
            query_params.append(('created_at:lesser_than', params['created_atlesser_than']))  # noqa: E501
        if 'created_atgreater_than_or_equals' in params:
            query_params.append(('created_at:greater_than_or_equals', params['created_atgreater_than_or_equals']))  # noqa: E501
        if 'created_atlesser_than_or_equals' in params:
            query_params.append(('created_at:lesser_than_or_equals', params['created_atlesser_than_or_equals']))  # noqa: E501
        if 'statusequals' in params:
            query_params.append(('status:equals', params['statusequals']))  # noqa: E501
        if 'statusin' in params:
            query_params.append(('status:in', params['statusin']))  # noqa: E501
            collection_formats['status:in'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/data-extracts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataExtract]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
