reactions_solutions = [
    {
        "H2O": -1.0,
        "OH-": 1.0,
        "H+": 1.0,
        "log_K25": "",
        "log_K_coefs": [
            293.29227,
            0.1360833,
            -10576.913,
            -123.73158,
            0.0,
            -6.996455e-05,
        ],
        "deltah": "",
        "type": "rev",
    },
    {
        "H2O": -2.0,
        "O2": 1.0,
        "H+": 4.0,
        "e-": 4.0,
        "log_K25": -86.08,
        "log_K_coefs": "",
        "deltah": 134.79,
        "type": "electronic",
    },
    {
        "H+": -2.0,
        "e-": -2.0,
        "H2": 1.0,
        "log_K25": -3.15,
        "log_K_coefs": "",
        "deltah": -1.759,
        "type": "electronic",
    },
    {
        "CO3--": -1.0,
        "H+": -1.0,
        "HCO3-": 1.0,
        "log_K25": 10.329,
        "log_K_coefs": [107.8871, 0.03252849, -5151.79, -38.92561, 563713.9],
        "deltah": -3.561,
        "type": "rev",
    },
    # {
    #     "CO3--": -1.0,
    #     "H+": -2.0,
    #     "CO2": 1.0,
    #     "H2O": 1.0,
    #     "log_K25": 16.681,
    #     "log_K_coefs": [
    #         464.1965,
    #         0.09344813,
    #         -26986.16,
    #         -165.75951,
    #         2248628.9
    #     ],
    #     "deltah": -5.738,
    #     "type": "rev"
    # },
    {
        "HCO3-": 1.0,
        "H+": 1.0,
        "CO2": -1.0,
        "H2O": -1.0,
        "log_K25": "",
        "deltah": -5.738,  # FIXME
        "log_K_coefs": [-356.3094, -0.06091964, 21834.37, 126.8339, -1684915],
        "type": "rev",
    },
    {
        "CO3--": -1.0,
        "H+": -10.0,
        "e-": -8.0,
        "CH4": 1.0,
        "H2O": 3.0,
        "log_K25": 41.071,
        "log_K_coefs": "",
        "deltah": -61.039,
        "type": "electronic",
    },
    {
        "SO4--": -1.0,
        "H+": -1.0,
        "HSO4-": 1.0,
        "log_K25": 1.988,
        "log_K_coefs": [-56.889, 0.006473, 2307.9, 19.8858],
        "deltah": 3.85,
        "type": "rev",
    },
    {
        "HS-": -1.0,
        "S--": 1.0,
        "H+": 1.0,
        "log_K25": -12.918,
        "log_K_coefs": "",
        "deltah": 12.1,
        "type": "rev",
    },
    {
        "SO4--": -1.0,
        "H+": -9.0,
        "e-": -8.0,
        "HS-": 1.0,
        "H2O": 4.0,
        "log_K25": 33.65,
        "log_K_coefs": "",
        "deltah": -60.14,
        "type": "electronic",
    },
    {
        "HS-": -1.0,
        "H+": -1.0,
        "H2S": 1.0,
        "log_K25": 6.994,
        "log_K_coefs": "",
        "deltah": -5.3,
        "type": "rev",
    },
    {
        "H2Sg": -1.0,
        "HSg-": 1.0,
        "H+": 1.0,
        "log_K25": -6.994,
        "log_K_coefs": "",
        "deltah": 5.3,
        "type": "rev",
    },
    {
        "NO3-": -1.0,
        "H+": -2.0,
        "e-": -2.0,
        "NO2-": 1.0,
        "H2O": 1.0,
        "log_K25": 28.57,
        "log_K_coefs": "",
        "deltah": -43.76,
        "type": "electronic",
    },
    {
        "NO3-": -2.0,
        "H+": -12.0,
        "e-": -10.0,
        "N2": 1.0,
        "H2O": 6.0,
        "log_K25": 207.08,
        "log_K_coefs": "",
        "deltah": -312.13,
        "type": "electronic",
    },
    {
        "NO3-": -1.0,
        "H+": -10.0,
        "e-": -8.0,
        "NH4+": 1.0,
        "H2O": 3.0,
        "log_K25": 119.077,
        "log_K_coefs": "",
        "deltah": -187.055,
        "type": "electronic",
    },
    {
        "NH4+": -1.0,
        "NH3": 1.0,
        "H+": 1.0,
        "log_K25": -9.252,
        "log_K_coefs": [0.6322, -0.001225, -2835.76],
        "deltah": 12.48,
        "type": "rev",
    },
    {
        "NH4+": -1.0,
        "SO4--": -1.0,
        "NH4SO4-": 1.0,
        "log_K25": 1.11,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "H3BO3": -1.0,
        "H2BO3-": 1.0,
        "H+": 1.0,
        "log_K25": -9.24,
        "log_K_coefs": "",
        "deltah": 3.224,
        "type": "rev",
    },
    {
        "H3BO3": -1.0,
        "F-": -1.0,
        "BF(OH)3-": 1.0,
        "log_K25": -0.4,
        "log_K_coefs": "",
        "deltah": 1.85,
        "type": "rev",
    },
    {
        "H3BO3": -1.0,
        "F-": -2.0,
        "H+": -1.0,
        "BF2(OH)2-": 1.0,
        "H2O": 1.0,
        "log_K25": 7.63,
        "log_K_coefs": "",
        "deltah": 1.618,
        "type": "rev",
    },
    {
        "H3BO3": -1.0,
        "H+": -2.0,
        "F-": -3.0,
        "BF3OH-": 1.0,
        "H2O": 2.0,
        "log_K25": 13.67,
        "log_K_coefs": "",
        "deltah": -1.614,
        "type": "rev",
    },
    {
        "H3BO3": -1.0,
        "H+": -3.0,
        "F-": -4.0,
        "BF4-": 1.0,
        "H2O": 3.0,
        "log_K25": 20.28,
        "log_K_coefs": "",
        "deltah": -1.846,
        "type": "rev",
    },
    {
        "PO4---": -1.0,
        "H+": -1.0,
        "HPO4--": 1.0,
        "log_K25": 12.346,
        "log_K_coefs": "",
        "deltah": -3.53,
        "type": "rev",
    },
    {
        "PO4---": -1.0,
        "H+": -2.0,
        "H2PO4-": 1.0,
        "log_K25": 19.553,
        "log_K_coefs": "",
        "deltah": -4.52,
        "type": "rev",
    },
    {
        "PO4---": -1.0,
        "H+": -3.0,
        "H3PO4": 1.0,
        "log_K25": 21.721,
        "log_K_coefs": "",
        "deltah": -10.1,
        "type": "rev",
    },
    {
        "H+": -1.0,
        "F-": -1.0,
        "HF": 1.0,
        "log_K25": 3.18,
        "log_K_coefs": [-2.033, 0.012645, 429.01],
        "deltah": 3.18,
        "type": "rev",
    },
    {
        "H+": -1.0,
        "F-": -2.0,
        "HF2-": 1.0,
        "log_K25": 3.76,
        "log_K_coefs": "",
        "deltah": 4.55,
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "H2O": -1.0,
        "CaOH+": 1.0,
        "H+": 1.0,
        "log_K25": -12.78,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "CO3--": -1.0,
        "CaCO3": 1.0,
        "log_K25": 3.224,
        "log_K_coefs": [-1228.732, -0.29944, 35512.75, 485.818],
        "deltah": 3.545,
        "type": "rev",
    },
    # {
    #     "Ca++": -1.0,
    #     "CO3--": -1.0,
    #     "H+": -1.0,
    #     "CaHCO3+": 1.0,
    #     "log_K25": 11.435,
    #     "log_K_coefs": [
    #         1317.0071,
    #         0.34546894,
    #         -39916.84,
    #         -517.70761,
    #         563713.9
    #     ],
    #     "deltah": -0.871,
    #     "type": "rev"
    # },
    {
        "Ca++": -1.0,
        "HCO3-": -1.0,
        "CaHCO3+": 1.0,
        "log_K25": "",
        "log_K_coefs": [1209.120, 0.31294, -34765.05, -478.782],
        "deltah": -0.871,
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "SO4--": -1.0,
        "CaSO4": 1.0,
        "log_K25": 2.25,
        "log_K_coefs": "",
        "deltah": 1.325,
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "HSO4-": -1.0,
        "CaHSO4+": 1.0,
        "log_K25": 1.08,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "PO4---": -1.0,
        "CaPO4-": 1.0,
        "log_K25": 6.459,
        "log_K_coefs": "",
        "deltah": 3.1,
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "HPO4--": -1.0,
        "CaHPO4": 1.0,
        "log_K25": 2.739,
        "log_K_coefs": "",
        "deltah": 3.3,
        "type": "rev",
    },
    {
        "Ca++": -1.0,
        "H2PO4-": -1.0,
        "CaH2PO4+": 1.0,
        "log_K25": 1.408,
        "log_K_coefs": "",
        "deltah": 3.4,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "H2O": -1.0,
        "MgOH+": 1.0,
        "H+": 1.0,
        "log_K25": -11.44,
        "log_K_coefs": "",
        "deltah": 15.952,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "CO3--": -1.0,
        "MgCO3": 1.0,
        "log_K25": 2.98,
        "log_K_coefs": [0.991, 0.00667],
        "deltah": 2.713,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "H+": -1.0,
        "CO3--": -1.0,
        "MgHCO3+": 1.0,
        "log_K25": 11.399,
        "log_K_coefs": [48.6721, 0.03252849, -2614.335, -18.00263, 563713.9],
        "deltah": -2.771,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "SO4--": -1.0,
        "MgSO4": 1.0,
        "log_K25": 2.37,
        "log_K_coefs": "",
        "deltah": 4.55,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "PO4---": -1.0,
        "MgPO4-": 1.0,
        "log_K25": 6.589,
        "log_K_coefs": "",
        "deltah": 3.1,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "HPO4--": -1.0,
        "MgHPO4": 1.0,
        "log_K25": 2.87,
        "log_K_coefs": "",
        "deltah": 3.3,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "H2PO4-": -1.0,
        "MgH2PO4+": 1.0,
        "log_K25": 1.513,
        "log_K_coefs": "",
        "deltah": 3.4,
        "type": "rev",
    },
    {
        "Mg++": -1.0,
        "F-": -1.0,
        "MgF+": 1.0,
        "log_K25": 1.82,
        "log_K_coefs": "",
        "deltah": 3.2,
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "H2O": -1.0,
        "NaOH": 1.0,
        "H+": 1.0,
        "log_K25": -14.18,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "CO3--": -1.0,
        "NaCO3-": 1.0,
        "log_K25": 1.27,
        "log_K_coefs": "",
        "deltah": 8.91,
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "HCO3-": -1.0,
        "NaHCO3": 1.0,
        "log_K25": -0.25,
        "log_K_coefs": "",
        "deltah": -1.0,
        "type": "rev",
    },
    {
        "Na+": -2.0,
        "CO3--": -1.0,
        "Na2CO3": 1.0,
        "log_K25": 0.672,
        "log_K_coefs": "",
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "SO4--": -1.0,
        "NaSO4-": 1.0,
        "log_K25": 0.7,
        "log_K_coefs": "",
        "deltah": 1.12,
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "HPO4--": -1.0,
        "NaHPO4-": 1.0,
        "log_K25": 0.29,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Na+": -1.0,
        "F-": -1.0,
        "NaF": 1.0,
        "log_K25": -0.24,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {  # CHECK
        "K+": -1.0,
        "SO4--": -1.0,
        "KSO4-": 1.0,
        "log_K25": 0.85,
        "log_K_coefs": "",
        "deltah": 2.25,
        "type": "rev",
    },
    {
        "K+": -1.0,
        "HPO4--": -1.0,
        "KHPO4-": 1.0,
        "log_K25": 0.29,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "H2O": -1.0,
        "FeOH+": 1.0,
        "H+": 1.0,
        "log_K25": -9.5,
        "log_K_coefs": "",
        "deltah": 13.2,
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "H2O": -3.0,
        "Fe(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -31.0,
        "log_K_coefs": "",
        "deltah": 30.3,
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "Cl-": -1.0,
        "FeCl+": 1.0,
        "log_K25": 0.14,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "CO3--": -1.0,
        "FeCO3": 1.0,
        "log_K25": 4.38,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "HCO3-": -1.0,
        "FeHCO3+": 1.0,
        "log_K25": 2.0,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "SO4--": -1.0,
        "FeSO4": 1.0,
        "log_K25": 2.25,
        "log_K_coefs": "",
        "deltah": 3.23,
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "HSO4-": -1.0,
        "FeHSO4+": 1.0,
        "log_K25": 1.08,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "HS-": -2.0,
        "Fe(HS)2": 1.0,
        "log_K25": 8.95,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "HS-": -3.0,
        "Fe(HS)3-": 1.0,
        "log_K25": 10.987,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "HPO4--": -1.0,
        "FeHPO4": 1.0,
        "log_K25": 3.6,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "H2PO4-": -1.0,
        "FeH2PO4+": 1.0,
        "log_K25": 2.7,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "F-": -1.0,
        "FeF+": 1.0,
        "log_K25": 1.0,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "Fe+++": 1.0,
        "e-": 1.0,
        "log_K25": -13.02,
        "log_K_coefs": "",
        "deltah": 9.68,
        "type": "electronic",
    },
    {
        "Fe+++": -1.0,
        "H2O": -1.0,
        "FeOH++": 1.0,
        "H+": 1.0,
        "log_K25": -2.19,
        "log_K_coefs": "",
        "deltah": 10.4,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "H2O": -2.0,
        "Fe(OH)2+": 1.0,
        "H+": 2.0,
        "log_K25": -5.67,
        "log_K_coefs": "",
        "deltah": 17.1,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "H2O": -3.0,
        "Fe(OH)3": 1.0,
        "H+": 3.0,
        "log_K25": -12.56,
        "log_K_coefs": "",
        "deltah": 24.8,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "H2O": -4.0,
        "Fe(OH)4-": 1.0,
        "H+": 4.0,
        "log_K25": -21.6,
        "log_K_coefs": "",
        "deltah": 31.9,
        "type": "rev",
    },
    {
        "Fe++": -1.0,
        "H2O": -2.0,
        "Fe(OH)2": 1.0,
        "H+": 2.0,
        "log_K25": -20.57,
        "log_K_coefs": "",
        "deltah": 28.565,
        "type": "rev",
    },
    {
        "Fe+++": -2.0,
        "H2O": -2.0,
        "Fe2(OH)2++++": 1.0,
        "H+": 2.0,
        "log_K25": -2.95,
        "log_K_coefs": "",
        "deltah": 13.5,
        "type": "rev",
    },
    {
        "Fe+++": -3.0,
        "H2O": -4.0,
        "Fe3(OH)4+++++": 1.0,
        "H+": 4.0,
        "log_K25": -6.3,
        "log_K_coefs": "",
        "deltah": 14.3,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "Cl-": -1.0,
        "FeCl++": 1.0,
        "log_K25": 1.48,
        "log_K_coefs": "",
        "deltah": 5.6,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "Cl-": -2.0,
        "FeCl2+": 1.0,
        "log_K25": 2.13,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "Cl-": -3.0,
        "FeCl3": 1.0,
        "log_K25": 1.13,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "SO4--": -1.0,
        "FeSO4+": 1.0,
        "log_K25": 4.04,
        "log_K_coefs": "",
        "deltah": 3.91,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "HSO4-": -1.0,
        "FeHSO4++": 1.0,
        "log_K25": 2.48,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "SO4--": -2.0,
        "Fe(SO4)2-": 1.0,
        "log_K25": 5.38,
        "log_K_coefs": "",
        "deltah": 4.6,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "HPO4--": -1.0,
        "FeHPO4+": 1.0,
        "log_K25": 5.43,
        "log_K_coefs": "",
        "deltah": 5.76,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "H2PO4-": -1.0,
        "FeH2PO4++": 1.0,
        "log_K25": 5.43,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "F-": -1.0,
        "FeF++": 1.0,
        "log_K25": 6.2,
        "log_K_coefs": "",
        "deltah": 2.7,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "F-": -2.0,
        "FeF2+": 1.0,
        "log_K25": 10.8,
        "log_K_coefs": "",
        "deltah": 4.8,
        "type": "rev",
    },
    {
        "Fe+++": -1.0,
        "F-": -3.0,
        "FeF3": 1.0,
        "log_K25": 14.0,
        "log_K_coefs": "",
        "deltah": 5.4,
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "H2O": -1.0,
        "MnOH+": 1.0,
        "H+": 1.0,
        "log_K25": -10.59,
        "log_K_coefs": "",
        "deltah": 14.4,
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "H2O": -3.0,
        "Mn(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -34.8,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "Cl-": -1.0,
        "MnCl+": 1.0,
        "log_K25": 0.61,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "Cl-": -2.0,
        "MnCl2": 1.0,
        "log_K25": 0.25,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "Cl-": -3.0,
        "MnCl3-": 1.0,
        "log_K25": -0.31,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "CO3--": -1.0,
        "MnCO3": 1.0,
        "log_K25": 4.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "HCO3-": -1.0,
        "MnHCO3+": 1.0,
        "log_K25": 1.95,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "SO4--": -1.0,
        "MnSO4": 1.0,
        "log_K25": 2.25,
        "log_K_coefs": "",
        "deltah": 3.37,
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "NO3-": -2.0,
        "Mn(NO3)2": 1.0,
        "log_K25": 0.6,
        "log_K_coefs": "",
        "deltah": -0.396,
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "F-": -1.0,
        "MnF+": 1.0,
        "log_K25": 0.84,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Mn++": -1.0,
        "Mn+++": 1.0,
        "e-": 1.0,
        "log_K25": -25.51,
        "log_K_coefs": "",
        "deltah": 25.8,
        "type": "electronic",
    },
    {
        "Al+++": -1.0,
        "H2O": -1.0,
        "AlOH++": 1.0,
        "H+": 1.0,
        "log_K25": -5.0,
        "log_K_coefs": [-38.253, 0.0, -656.27, 14.327],
        "deltah": 11.49,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "H2O": -2.0,
        "Al(OH)2+": 1.0,
        "H+": 2.0,
        "log_K25": -10.1,
        "log_K_coefs": [88.5, 0.0, -9391.6, -27.121],
        "deltah": 26.9,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "H2O": -3.0,
        "Al(OH)3": 1.0,
        "H+": 3.0,
        "log_K25": -16.9,
        "log_K_coefs": [226.374, 0.0, -18247.8, -73.597],
        "deltah": 39.89,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "H2O": -4.0,
        "Al(OH)4-": 1.0,
        "H+": 4.0,
        "log_K25": -22.7,
        "log_K_coefs": [51.578, 0.0, -11168.9, -14.865],
        "deltah": 42.3,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "SO4--": -1.0,
        "AlSO4+": 1.0,
        "log_K25": 3.5,
        "log_K_coefs": "",
        "deltah": 2.29,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "SO4--": -2.0,
        "Al(SO4)2-": 1.0,
        "log_K25": 5.0,
        "log_K_coefs": "",
        "deltah": 3.11,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "HSO4-": -1.0,
        "AlHSO4++": 1.0,
        "log_K25": 0.46,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "F-": -1.0,
        "AlF++": 1.0,
        "log_K25": 7.0,
        "log_K_coefs": "",
        "deltah": 1.06,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "F-": -2.0,
        "AlF2+": 1.0,
        "log_K25": 12.7,
        "log_K_coefs": "",
        "deltah": 1.98,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "F-": -3.0,
        "AlF3": 1.0,
        "log_K25": 16.8,
        "log_K_coefs": "",
        "deltah": 2.16,
        "type": "rev",
    },
    {
        "Al+++": -1.0,
        "F-": -4.0,
        "AlF4-": 1.0,
        "log_K25": 19.4,
        "log_K_coefs": "",
        "deltah": 2.2,
        "type": "rev",
    },
    {
        "H4SiO4": -1.0,
        "H3SiO4-": 1.0,
        "H+": 1.0,
        "log_K25": -9.83,
        "log_K_coefs": [-302.3724, -0.050698, 15669.69, 108.18466, -1119669.0],
        "deltah": 6.12,
        "type": "rev",
    },
    {
        "H4SiO4": -1.0,
        "H2SiO4--": 1.0,
        "H+": 2.0,
        "log_K25": -23.0,
        "log_K_coefs": [-294.0184, -0.07265, 11204.49, 108.18466, -1119669.0],
        "deltah": 17.6,
        "type": "rev",
    },
    {
        "H4SiO4": -1.0,
        "H+": -4.0,
        "F-": -6.0,
        "SiF6--": 1.0,
        "H2O": 4.0,
        "log_K25": 30.18,
        "log_K_coefs": "",
        "deltah": -16.26,
        "type": "rev",
    },
    {
        "Ba++": -1.0,
        "H2O": -1.0,
        "BaOH+": 1.0,
        "H+": 1.0,
        "log_K25": -13.47,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Ba++": -1.0,
        "CO3--": -1.0,
        "BaCO3": 1.0,
        "log_K25": 2.71,
        "log_K_coefs": [0.113, 0.008721],
        "deltah": 3.55,
        "type": "rev",
    },
    {
        "Ba++": -1.0,
        "HCO3-": -1.0,
        "BaHCO3+": 1.0,
        "log_K25": 0.982,
        "log_K_coefs": [-3.0938, 0.013669],
        "deltah": 5.56,
        "type": "rev",
    },
    {
        "Ba++": -1.0,
        "SO4--": -1.0,
        "BaSO4": 1.0,
        "log_K25": 2.7,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Sr++": -1.0,
        "H2O": -1.0,
        "SrOH+": 1.0,
        "H+": 1.0,
        "log_K25": -13.29,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Sr++": -1.0,
        "CO3--": -1.0,
        "H+": -1.0,
        "SrHCO3+": 1.0,
        "log_K25": 11.509,
        "log_K_coefs": [104.6391, 0.04739549, -5151.79, -38.92561, 563713.9],
        "deltah": 2.489,
        "type": "rev",
    },
    {
        "Sr++": -1.0,
        "CO3--": -1.0,
        "SrCO3": 1.0,
        "log_K25": 2.81,
        "log_K_coefs": [-1.019, 0.012826],
        "deltah": 5.22,
        "type": "rev",
    },
    {
        "Sr++": -1.0,
        "SO4--": -1.0,
        "SrSO4": 1.0,
        "log_K25": 2.29,
        "log_K_coefs": "",
        "deltah": 2.08,
        "type": "rev",
    },
    {
        "Li+": -1.0,
        "SO4--": -1.0,
        "LiSO4-": 1.0,
        "log_K25": 0.64,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "e-": -1.0,
        "Cu+": 1.0,
        "log_K25": 2.72,
        "log_K_coefs": "",
        "deltah": 1.65,
        "type": "electronic",
    },
    {
        "Cu+": -1.0,
        "Cl-": -2.0,
        "CuCl2-": 1.0,
        "log_K25": 5.5,
        "log_K_coefs": "",
        "deltah": -0.42,
        "type": "rev",
    },
    {
        "Cu+": -1.0,
        "Cl-": -3.0,
        "CuCl3--": 1.0,
        "log_K25": 5.7,
        "log_K_coefs": "",
        "deltah": 0.26,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "CO3--": -1.0,
        "CuCO3": 1.0,
        "log_K25": 6.73,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "CO3--": -2.0,
        "Cu(CO3)2--": 1.0,
        "log_K25": 9.83,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "HCO3-": -1.0,
        "CuHCO3+": 1.0,
        "log_K25": 2.7,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "Cl-": -1.0,
        "CuCl+": 1.0,
        "log_K25": 0.43,
        "log_K_coefs": "",
        "deltah": 8.65,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "Cl-": -2.0,
        "CuCl2": 1.0,
        "log_K25": 0.16,
        "log_K_coefs": "",
        "deltah": 10.56,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "Cl-": -3.0,
        "CuCl3-": 1.0,
        "log_K25": -2.29,
        "log_K_coefs": "",
        "deltah": 13.69,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "Cl-": -4.0,
        "CuCl4--": 1.0,
        "log_K25": -4.59,
        "log_K_coefs": "",
        "deltah": 17.78,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "F-": -1.0,
        "CuF+": 1.0,
        "log_K25": 1.26,
        "log_K_coefs": "",
        "deltah": 1.62,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "H2O": -1.0,
        "CuOH+": 1.0,
        "H+": 1.0,
        "log_K25": -8.0,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "H2O": -2.0,
        "Cu(OH)2": 1.0,
        "H+": 2.0,
        "log_K25": -13.68,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "H2O": -3.0,
        "Cu(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -26.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "H2O": -4.0,
        "Cu(OH)4--": 1.0,
        "H+": 4.0,
        "log_K25": -39.6,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cu++": -2.0,
        "H2O": -2.0,
        "Cu2(OH)2++": 1.0,
        "H+": 2.0,
        "log_K25": -10.359,
        "log_K_coefs": "",
        "deltah": 17.539,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "SO4--": -1.0,
        "CuSO4": 1.0,
        "log_K25": 2.31,
        "log_K_coefs": "",
        "deltah": 1.22,
        "type": "rev",
    },
    {
        "Cu++": -1.0,
        "HS-": -3.0,
        "Cu(HS)3-": 1.0,
        "log_K25": 25.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "H2O": -1.0,
        "ZnOH+": 1.0,
        "H+": 1.0,
        "log_K25": -8.96,
        "log_K_coefs": "",
        "deltah": 13.4,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "H2O": -2.0,
        "Zn(OH)2": 1.0,
        "H+": 2.0,
        "log_K25": -16.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "H2O": -3.0,
        "Zn(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -28.4,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "H2O": -4.0,
        "Zn(OH)4--": 1.0,
        "H+": 4.0,
        "log_K25": -41.2,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Cl-": -1.0,
        "ZnCl+": 1.0,
        "log_K25": 0.43,
        "log_K_coefs": "",
        "deltah": 7.79,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Cl-": -2.0,
        "ZnCl2": 1.0,
        "log_K25": 0.45,
        "log_K_coefs": "",
        "deltah": 8.5,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Cl-": -3.0,
        "ZnCl3-": 1.0,
        "log_K25": 0.5,
        "log_K_coefs": "",
        "deltah": 9.56,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Cl-": -4.0,
        "ZnCl4--": 1.0,
        "log_K25": 0.2,
        "log_K_coefs": "",
        "deltah": 10.96,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "H2O": -1.0,
        "Cl-": -1.0,
        "ZnOHCl": 1.0,
        "H+": 1.0,
        "log_K25": -7.48,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "HS-": -2.0,
        "Zn(HS)2": 1.0,
        "log_K25": 14.94,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "HS-": -3.0,
        "Zn(HS)3-": 1.0,
        "log_K25": 16.1,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "CO3--": -1.0,
        "ZnCO3": 1.0,
        "log_K25": 5.3,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "CO3--": -2.0,
        "Zn(CO3)2--": 1.0,
        "log_K25": 9.63,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "HCO3-": -1.0,
        "ZnHCO3+": 1.0,
        "log_K25": 2.1,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "SO4--": -1.0,
        "ZnSO4": 1.0,
        "log_K25": 2.37,
        "log_K_coefs": "",
        "deltah": 1.36,
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "SO4--": -2.0,
        "Zn(SO4)2--": 1.0,
        "log_K25": 3.28,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Br-": -1.0,
        "ZnBr+": 1.0,
        "log_K25": -0.58,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "Br-": -2.0,
        "ZnBr2": 1.0,
        "log_K25": -0.98,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Zn++": -1.0,
        "F-": -1.0,
        "ZnF+": 1.0,
        "log_K25": 1.15,
        "log_K_coefs": "",
        "deltah": 2.22,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "H2O": -1.0,
        "CdOH+": 1.0,
        "H+": 1.0,
        "log_K25": -10.08,
        "log_K_coefs": "",
        "deltah": 13.1,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "H2O": -2.0,
        "Cd(OH)2": 1.0,
        "H+": 2.0,
        "log_K25": -20.35,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "H2O": -3.0,
        "Cd(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -33.3,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "H2O": -4.0,
        "Cd(OH)4--": 1.0,
        "H+": 4.0,
        "log_K25": -47.35,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -2.0,
        "H2O": -1.0,
        "Cd2OH+++": 1.0,
        "H+": 1.0,
        "log_K25": -9.39,
        "log_K_coefs": "",
        "deltah": 10.9,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "H2O": -1.0,
        "Cl-": -1.0,
        "CdOHCl": 1.0,
        "H+": 1.0,
        "log_K25": -7.404,
        "log_K_coefs": "",
        "deltah": 4.355,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "NO3-": -1.0,
        "CdNO3+": 1.0,
        "log_K25": 0.4,
        "log_K_coefs": "",
        "deltah": -5.2,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "Cl-": -1.0,
        "CdCl+": 1.0,
        "log_K25": 1.98,
        "log_K_coefs": "",
        "deltah": 0.59,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "Cl-": -2.0,
        "CdCl2": 1.0,
        "log_K25": 2.6,
        "log_K_coefs": "",
        "deltah": 1.24,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "Cl-": -3.0,
        "CdCl3-": 1.0,
        "log_K25": 2.4,
        "log_K_coefs": "",
        "deltah": 3.9,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "CO3--": -1.0,
        "CdCO3": 1.0,
        "log_K25": 2.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "CO3--": -2.0,
        "Cd(CO3)2--": 1.0,
        "log_K25": 6.4,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "HCO3-": -1.0,
        "CdHCO3+": 1.0,
        "log_K25": 1.5,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "SO4--": -1.0,
        "CdSO4": 1.0,
        "log_K25": 2.46,
        "log_K_coefs": "",
        "deltah": 1.08,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "SO4--": -2.0,
        "Cd(SO4)2--": 1.0,
        "log_K25": 3.5,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "Br-": -1.0,
        "CdBr+": 1.0,
        "log_K25": 2.17,
        "log_K_coefs": "",
        "deltah": -0.81,
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "Br-": -2.0,
        "CdBr2": 1.0,
        "log_K25": 2.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "F-": -1.0,
        "CdF+": 1.0,
        "log_K25": 1.1,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "F-": -2.0,
        "CdF2": 1.0,
        "log_K25": 1.5,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "HS-": -1.0,
        "CdHS+": 1.0,
        "log_K25": 10.17,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "HS-": -2.0,
        "Cd(HS)2": 1.0,
        "log_K25": 16.53,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "HS-": -3.0,
        "Cd(HS)3-": 1.0,
        "log_K25": 18.71,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Cd++": -1.0,
        "HS-": -4.0,
        "Cd(HS)4--": 1.0,
        "log_K25": 20.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "H2O": -1.0,
        "PbOH+": 1.0,
        "H+": 1.0,
        "log_K25": -7.71,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "H2O": -2.0,
        "Pb(OH)2": 1.0,
        "H+": 2.0,
        "log_K25": -17.12,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "H2O": -3.0,
        "Pb(OH)3-": 1.0,
        "H+": 3.0,
        "log_K25": -28.06,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "H2O": -4.0,
        "Pb(OH)4--": 1.0,
        "H+": 4.0,
        "log_K25": -39.7,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -2.0,
        "H2O": -1.0,
        "Pb2OH+++": 1.0,
        "H+": 1.0,
        "log_K25": -6.36,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Cl-": -1.0,
        "PbCl+": 1.0,
        "log_K25": 1.6,
        "log_K_coefs": "",
        "deltah": 4.38,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Cl-": -2.0,
        "PbCl2": 1.0,
        "log_K25": 1.8,
        "log_K_coefs": "",
        "deltah": 1.08,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Cl-": -3.0,
        "PbCl3-": 1.0,
        "log_K25": 1.7,
        "log_K_coefs": "",
        "deltah": 2.17,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Cl-": -4.0,
        "PbCl4--": 1.0,
        "log_K25": 1.38,
        "log_K_coefs": "",
        "deltah": 3.53,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "CO3--": -1.0,
        "PbCO3": 1.0,
        "log_K25": 7.24,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "CO3--": -2.0,
        "Pb(CO3)2--": 1.0,
        "log_K25": 10.64,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "HCO3-": -1.0,
        "PbHCO3+": 1.0,
        "log_K25": 2.9,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "SO4--": -1.0,
        "PbSO4": 1.0,
        "log_K25": 2.75,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "SO4--": -2.0,
        "Pb(SO4)2--": 1.0,
        "log_K25": 3.47,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "HS-": -2.0,
        "Pb(HS)2": 1.0,
        "log_K25": 15.27,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "HS-": -3.0,
        "Pb(HS)3-": 1.0,
        "log_K25": 16.57,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -3.0,
        "H2O": -4.0,
        "Pb3(OH)4++": 1.0,
        "H+": 4.0,
        "log_K25": -23.88,
        "log_K_coefs": "",
        "deltah": 26.5,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "NO3-": -1.0,
        "PbNO3+": 1.0,
        "log_K25": 1.17,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Br-": -1.0,
        "PbBr+": 1.0,
        "log_K25": 1.77,
        "log_K_coefs": "",
        "deltah": 2.88,
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "Br-": -2.0,
        "PbBr2": 1.0,
        "log_K25": 1.44,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "F-": -1.0,
        "PbF+": 1.0,
        "log_K25": 1.25,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "F-": -2.0,
        "PbF2": 1.0,
        "log_K25": 2.56,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "F-": -3.0,
        "PbF3-": 1.0,
        "log_K25": 3.42,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
    {
        "Pb++": -1.0,
        "F-": -4.0,
        "PbF4--": 1.0,
        "log_K25": 3.1,
        "log_K_coefs": "",
        "deltah": "",
        "type": "rev",
    },
]
