species = {
    "debye": {
        "H+": {"dh": {"phreeqc": {"a": 9.0, "b": 0.0}}},
        "Na+": {"dh": {"phreeqc": {"a": 4.0, "b": 0.075}}},
        "Ca++": {"dh": {"phreeqc": {"a": 5.0, "b": 0.1650}}},
        "Mg++": {"dh": {"phreeqc": {"a": 5.5, "b": 0.20}}},
        "Mn++": {"dh": {"phreeqc": {"a": 6.0, "b": 0.0}}},
        "Ba++": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "K+": {"dh": {"phreeqc": {"a": 3.5, "b": 0.015}}},
        "Fe++": {"dh": {"phreeqc": {"a": 6.0, "b": 0.0}}},
        "Al+++": {"dh": {"phreeqc": {"a": 9.0, "b": 0.0}}},
        "AlSO4+": {"dh": {"phreeqc": {"a": 4.5, "b": 0.0}}},
        "Al(SO4)2-": {"dh": {"phreeqc": {"a": 4.5, "b": 0.0}}},
        "AlF++": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "AlF2+": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "AlF4-": {"dh": {"phreeqc": {"a": 4.5, "b": 0.0}}},
        # H4SiO4 and others not sure which element is the gamma
        "Sr++": {"dh": {"phreeqc": {"a": 5.260, "b": 0.121}}},
        "SrOH+": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "SrHCO3+": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "LiSO4-": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "CuCl2-": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "CuCl3--": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "CuCl3-": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "CuCl4--": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "CuOH+": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "ZnCl+": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "ZnCl3-": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "ZnCl4--": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "Li+": {"dh": {"phreeqc": {"a": 6.0, "b": 0.0}}},
        "Zn++": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "Cu++": {"dh": {"phreeqc": {"a": 6.0, "b": 0.0}}},
        "CaHCO3+": {"dh": {"phreeqc": {"a": 6.0, "b": 0.0}}},
        "BaOH+": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "OH-": {"dh": {"phreeqc": {"a": 3.5, "b": 0.0}}},
        "CO3--": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "HCO3-": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "Cl-": {"dh": {"phreeqc": {"a": 3.5, "b": 0.015}}},
        "NO3-": {"dh": {"phreeqc": {"a": 3.0, "b": 0.0}}},
        "PO4---": {"dh": {"phreeqc": {"a": 4.0, "b": 0.0}}},
        "HPO4--": {"dh": {"phreeqc": {"a": 5.0, "b": 0.0}}},
        "H2PO4-": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "CaH2PO4+": {"dh": {"phreeqc": {"a": 5.4, "b": 0.0}}},
        "F-": {"dh": {"phreeqc": {"a": 3.5, "b": 0.0}}},
        "Br-": {"dh": {"phreeqc": {"a": 3.0, "b": 0.0}}},
        "SO4--": {"dh": {"phreeqc": {"a": 5.0, "b": -0.04}}}
        # "CO2": { # Neutral Species are using the 0.3I (PHREEQC)
        #     "I_factor": -0.5
        # },
        # "H2O": {
        #     "I_factor": -0.5
        # }
    },
    "pitzer": {
        "neutrals": ["CO2"],
        "CO2": {
            "n-c": {"Ca++": 0.183, "Na+": 0.085, "Mg++": 0.183},
            "n-a": {"HCO3-": 0.0016},
        },
        "Ca++": {
            "c-c": {
                "H+": 0.092,
                # "Na+": 9.22e-2 #pitzer
                "Na+": 0.07,  # G-A
                "Mg++": 0.007,
            },
            "c-a": {"Cl-": 1.4e-4, "SO4--": 0.114},
            "beta": {
                "OH-": [-0.1747, -0.2303, -5.72],
                "HCO3-": [0.4, 2.977, 0.0],
                "Cl-": [0.3159, 1.614, -1.13],
                "HSO4-": [0.2145, 2.53, 0.0],
                # "SO4--": [0.0, 3.546, -59.3] ,#pitzet.dat
                "SO4--": [0.2, 2.65, -57.7],  # G-A-book
            },
        },
        "Mg++": {  # pitzer.dat+
            "c-c": {"H+": 0.1, "Na+": 0.07, "Ca++": 0.007},
            "c-a": {"Cl-": 0.00651, "SO4--": 2.875e-2},
            "beta": {
                "HCO3-": [0.329, 0.6072, 0.0],
                "Cl-": [0.351, 1.65, 0.0],
                "HSO4-": [0.4746, 1.729, 0.0],
                "SO4--": [0.2135, 3.367, -32.45],
            },
        },
        "H+": {
            "c-c": {"Mg++": 0.1, "Na+": 0.036, "Ca++": 0.092},
            "c-a": {"Cl-": 0.0438},
            "beta": {
                "Cl-": [0.1775, 0.2945, 0.0],
                "HSO4-": [0.2065, 0.5556, 0.0],
                "SO4--": [0.0298, 0.0, 0.0],
            },
        },
        "Na+": {
            "c-c": {
                "H+": 0.036,
                "Mg++": 0.07,
                # "Ca++": 9.22e-2,
                "Ca++": 0.07,  # G-A
            },
            "c-a": {
                "OH-": 0.0044,
                "CO3--": 0.0044,
                "Cl-": 1.48e-3,
                "SO4--": 3.418e-3,
            },
            "beta": {
                "OH-": [0.0864, 0.253, 0.0],
                "HCO3-": [-0.018, 0.0, 8.22],
                "CO3--": [0.0399, 1.389, 0.0],
                "Cl-": [7.534e-2, 0.2769, 0.0],
                "HSO4-": [0.0454, 0.0, 0],
                # "SO4--": [2.73e-2, 0.956, 0], #pitzer.dat
                "SO4--": [0.01958, 1.1130, 0],  # G-A-Book
            },
        },
        "K+": {
            "c-c": {
                "H+": 0.005,
            },
            "c-a": {
                "SO4--": 8.18e-3,  # FIXME: ITS TEMPERATURE DEPENDENT, INCLUDE THIS FEATURE
            },
            "beta": {
                "HSO4-": [-0.0003, 0.1735, 0],
                "SO4--": [
                    3.17e-2,
                    0.756,
                    0,
                ],  # B0 and B1 is T Dependent! FIXME
            },
        },
        "OH-": {
            "a-a": {"CO3--": 0.1, "Cl-": 0.1}
            # "a-c": {
            #     "Na+": 0.0044
            # }
        },
        "Cl-": {  # iteractions a-c are not need, the procedure search by cations and get for each ion
            "a-a": {
                "OH-": 0.1,
                "HCO3-": 0.036,
                "CO3--": -0.053,
                "SO4--": 0.02,
            }  # G-A
            # "a-c": {
            #     "Na+": 0.00127
            # }
        },
        "HCO3-": {"a-a": {"CO3--": -0.04, "Cl-": 0.036}},
        "CO3--": {
            "a-a": {"HCO3-": -0.04, "Cl-": -0.053}
            # "a-c": {
            #     "Na+": 0.0052
            # }
        },
        "dummy": {"c-c": {"Na+": -1}},
    },
    "pitzer_mod": {
        "neutrals": ["CO2"],
        "CO2": {
            "B0": {"Ca++": 0.183, "Na+": 0.085, "Mg++": 0.183, "HCO3-": 0.0016}
        },
        "Ca++": {
            "B0": {
                "H+": 0.092,
                # "Na+": 9.22e-2 #pitzer
                "Na+": 0.07,  # G-A
                "Mg++": 0.007,
                "Cl-": 1.4e-4,
                "SO4--": 0.114,
            },
            "beta": {
                "OH-": [-0.1747, -0.2303, -5.72],
                "HCO3-": [0.4, 2.977, 0.0],
                "Cl-": [0.3159, 1.614, -1.13],
                "HSO4-": [0.2145, 2.53, 0.0],
                # "SO4--": [0.0, 3.546, -59.3] ,#pitzet.dat
                "SO4--": [0.2, 2.65, -57.7],  # G-A-book
            },
        },
        "Mg++": {  # pitzer.dat+
            "c-c": {"H+": 0.1, "Na+": 0.07, "Ca++": 0.007},
            "c-a": {"Cl-": 0.00651, "SO4--": 2.875e-2},
            "beta": {
                "HCO3-": [0.329, 0.6072, 0.0],
                "Cl-": [0.351, 1.65, 0.0],
                "HSO4-": [0.4746, 1.729, 0.0],
                "SO4--": [0.2135, 3.367, -32.45],
            },
        },
        "H+": {
            "c-c": {"Mg++": 0.1, "Na+": 0.036, "Ca++": 0.092},
            "c-a": {"Cl-": 0.0438},
            "beta": {
                "Cl-": [0.1775, 0.2945, 0.0],
                "HSO4-": [0.2065, 0.5556, 0.0],
                "SO4--": [0.0298, 0.0, 0.0],
            },
        },
        "Na+": {
            "c-c": {
                "H+": 0.036,
                "Mg++": 0.07,
                # "Ca++": 9.22e-2,
                "Ca++": 0.07,  # G-A
            },
            "c-a": {
                "OH-": 0.0044,
                "CO3--": 0.0044,
                "Cl-": 1.48e-3,
                "SO4--": 3.418e-3,
            },
            "beta": {
                "OH-": [0.0864, 0.253, 0.0],
                "HCO3-": [-0.018, 0.0, 8.22],
                "CO3--": [0.0399, 1.389, 0.0],
                "Cl-": [7.534e-2, 0.2769, 0.0],
                "HSO4-": [0.0454, 0.0, 0],
                # "SO4--": [2.73e-2, 0.956, 0], #pitzer.dat
                "SO4--": [0.01958, 1.1130, 0],  # G-A-Book
            },
        },
        "OH-": {
            "a-a": {"CO3--": 0.1, "Cl-": 0.1}
            # "a-c": {
            #     "Na+": 0.0044
            # }
        },
        "Cl-": {  # iteractions a-c are not need, the procedure search by cations and get for each ion
            "a-a": {
                "OH-": 0.1,
                "HCO3-": 0.036,
                "CO3--": -0.053,
                "SO4--": 0.02,
            }  # G-A
            # "a-c": {
            #     "Na+": 0.00127
            # }
        },
        "HCO3-": {"a-a": {"CO3--": -0.04, "Cl-": 0.036}},
        "CO3--": {
            "a-a": {"HCO3-": -0.04, "Cl-": -0.053}
            # "a-c": {
            #     "Na+": 0.0052
            # }
        },
        "dummy": {"c-c": {"Na+": -1}},
    },
    "bromley": {
        "K+": {"Cl-": 0.024},
        "Na+": {"Cl-": 0.0574},
        "Mg++": {"SO4--": -0.0153}
        # ,
        # "H+": {
        # }
    },
    "bromley-individuals": {
        # From Table 2 (Bromley 73) - Table 1 is preferred!
        "H+": {"B": 0.0875, "d": 0.103},
        "Li+": {"B": 0.0691, "d": 0.138},
        "Na+": {"B": 0.0000, "d": 0.028},
        "K+": {"B": -0.0452, "d": -0.079},
        "Rb+": {"B": -0.0537, "d": -0.100},
        "Cs+": {"B": -0.0710, "d": -0.138},
        "NH4+": {"B": -0.042, "d": -0.02},
        "Tl+": {"B": -0.135, "d": -0.02},
        "Ag+": {"B": -0.058, "d": 0},
        "Be++": {"B": 0.1, "d": 0.2},
        "Mg++": {"B": 0.0570, "d": 0.157},
        "Ca++": {"B": 0.0374, "d": 0.119},
        "Sr++": {"B": 0.0245, "d": 0.110},
        "Ba++": {"B": 0.0022, "d": 0.098},
        "Mn++": {"B": 0.037, "d": 0.21},
        "Fe++": {"B": 0.046, "d": 0.21},
        "Co++": {"B": 0.0490, "d": 0.210},
        "Ni++": {"B": 0.054, "d": 0.21},
        "Cu++": {"B": 0.022, "d": 0.30},
        "Zn++": {"B": 0.101, "d": 0.09},
        "Cd++": {"B": 0.072, "d": 0.09},
        "Pb++": {"B": -0.104, "d": 0.25},
        "UO2++": {"B": 0.079, "d": 0.19},
        "Cr+++": {"B": 0.066, "d": 0.15},
        "Al+++": {"B": 0.052, "d": 0.12},
        "Sc+++": {"B": 0.046, "d": 0.2},
        "Y+++": {"B": 0.037, "d": 0.2},
        "La+++": {"B": 0.036, "d": 0.27},
        "Ce+++": {"B": 0.035, "d": 0.27},
        "Pr+++": {"B": 0.034, "d": 0.27},
        "Nd+++": {"B": 0.035, "d": 0.27},
        "Sm+++": {"B": 0.039, "d": 0.27},
        "Eu+++": {"B": 0.041, "d": 0.27},
        "Ga+++": {"B": 0.000, "d": 0.21},
        "Th++++": {"B": 0.062, "d": 0.19},
        "Co(en)3+++": {"B": -0.089, "d": 0},
        "F-": {"B": 0.0295, "d": -0.93},
        "Cl-": {"B": 0.0643, "d": -0.067},
        "Br-": {"B": 0.0741, "d": 0.064},
        "I-": {"B": 0.0890, "d": 0.196},
        "ClO3-": {"B": 0.005, "d": 0.45},
        "ClO4-": {"B": 0.002, "d": 0.79},
        "BrO3-": {"B": -0.032, "d": 0.14},
        "IO3-": {"B": -0.04, "d": 0},
        "NO3-": {"B": -0.025, "d": 0.27},
        "H2PO4-": {"B": -0.052, "d": 0.20},
        "HzAs04-": {"B": -0.030, "d": 0.05},
        "CNS-": {"B": 0.071, "d": 0.16},
        "OH-": {"B": 0.076, "d": -1.00},
        "CrO4--": {"B": 0.019, "d": -0.33},
        "SO4--": {"B": 0.000, "d": -0.40},
        "S2O3--": {"B": 0.019, "d": -0.7},
        "HPO4--": {"B": -0.010, "d": -0.57},
        "HasO4--": {"B": 0.021, "d": -0.67},
        "CO3--": {"B": 0.028, "d": -0.67},
        "Formate": {"B": 0.072, "d": -0.7},
        "Acetate": {"B": 0.104, "d": -0.73},
        "Propionate": {"B": 0.152, "d": -0.7},
        "Butyrate": {"B": 0.167, "d": -0.7},
        "Valerate": {"B": 0.142, "d": -0.7},
        "Caproate": {"B": 0.068, "d": -0.7},
        "Heptylate": {"B": -0.027, "d": -0.7},
        "Caprylate": {"B": -0.122, "d": -0.7},
        "Pelargonate": {"B": -0.284, "d": -0.7},
        "Caprate": {"B": -0.459, "d": -0.7},
        "Toluate": {"B": -0.022, "d": -0.16},
        "Fumarate": {"B": 0.056, "d": -0.7},
        "Maleate": {"B": 0.017, "d": -0.7},
        "H-Malonate": {"B": 0.005, "d": -0.22},
        "H-Succinate": {"B": 0.021, "d": -0.27},
        "H-Adipate": {"B": 0.053, "d": -0.26},
        "PO4---": {"B": 0.024, "d": -0.70},
        "AsO4---": {"B": 0.038, "d": -0.78},
        "Fe(CN)6---": {"B": 0.054, "d": 0},
        "Mo(CN)s---": {"B": 0.056, "d": 0},
    },
    "sit": {
        "(NpO2)2(OH)2++": {"Cl-": -0.248, "ClO4-": 0.57},
        "(NpO2)2CO3(OH)3-": {"Na+": 0.0},
        "(NpO2)3(CO3)6-6": {"Na+": -0.46},
        "(NpO2)3(OH)5+": {"Cl-": -0.226, "ClO4-": 0.45},
        "(PuO2)2(OH)2++": {"Cl-": -0.248},
        "(PuO2)3(CO3)6-6": {"Na+": -0.46},
        "(UO2)2(CO3)(OH)3-": {"Na+": 0.0},
        "(UO2)2(NpO2)(CO3)6-6": {"Na+": 0.09},
        "(UO2)2(OH)2++": {"Cl-": 0.69, "ClO4-": 0.57, "NO3-": 0.49},
        "(UO2)3(CO3)6-6": {"Na+": 0.37},
        "(UO2)3(OH)4++": {"Cl-": 0.5},
        "(UO2)3(OH)5+": {"Cl-": 0.81},
        "Ag(SeO3)-": {"Na+": -0.024},
        "Ag+": {"Cl-": 0.031},
        "Al(OH)++": {"Cl-": 0.09},
        "Al(OH)2+": {"Cl-": 0.09},
        "Al+++": {"Cl-": 0.33},
        "Am(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Am(CO3)2-": {"Na+": -0.14},
        "Am(CO3)3---": {"Na+": -0.23},
        "Am(CO3)5-6": {"Na+": -0.3},
        "Am(Edta)-": {"Na+": 0.01},
        "Am(H2PO4)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Am(NO3)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Am(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Am(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Am(Ox)+": {"ClO4-": 0.08},
        "Am(Ox)2-": {"Na+": -0.21},
        "Am(Ox)3---": {"Na+": -0.23},
        "Am(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Am(SO4)2-": {"Na+": -0.05},
        "Am+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "AmCl++": {"Cl-": 0.191, "ClO4-": 0.39},
        "AmCl2+": {"Cl-": 0.129},
        "AmF++": {"Cl-": 0.191, "ClO4-": 0.39},
        "AmF2+": {"Cl-": 0.129, "ClO4-": 0.17},
        "AmO2(CO3)-": {"Na+": -0.18},
        "AmO2(CO3)2---": {"Na+": -0.33},
        "AmO2(CO3)3-----": {"Na+": -0.53},
        "AmO2+": {"Cl-": 0.09},
        "AmO2++": {"Cl-": 0.39},
        "B(OH)4-": {"Na+": -0.07},
        "Ba++": {"Cl-": 0.07, "ClO4-": 0.15, "NO3-": -0.28},
        "Br-": {"Na+": 0.05},
        "CO3--": {"Na+": -0.08},
        "Ca++": {"Cl-": 0.14, "ClO4-": 0.27, "NO3-": 0.02},
        "Ca4Th(OH)8++++": {"Cl-": -0.01, "ClO4-": 0.21},
        "Cd(HCO3)+": {"Cl-": 0.2},
        "Cd++": {"Cl-": 0.16, "NO3-": 0.09},
        "CdCl+": {"Cl-": 0.127, "ClO4-": 0.25},
        "CdI+": {"Cl-": 0.136, "ClO4-": 0.27},
        "Cit---": {"Na+": -0.076},
        "Cl-": {
            "Na+": 0.03,
            "(NpO2)2(OH)2++": -0.248,
            "(NpO2)3(OH)5+": -0.226,
            "(PuO2)2(OH)2++": -0.248,
            "(UO2)2(OH)2++": 0.69,
            "(UO2)3(OH)4++": 0.5,
            "(UO2)3(OH)5+": 0.81,
            "Ag+": 0.031,
            "Al(OH)++": 0.09,
            "Al(OH)2+": 0.09,
            "Al+++": 0.33,
            "Am(CO3)+": 0.129,
            "Am(H2PO4)++": 0.191,
            "Am(NO3)++": 0.191,
            "Am(OH)++": -0.04,
            "Am(OH)2+": -0.29,
            "Am(SO4)+": 0.157,
            "Am+++": 0.23,
            "AmCl++": 0.191,
            "AmCl2+": 0.129,
            "AmF++": 0.191,
            "AmF2+": 0.129,
            "AmO2+": 0.09,
            "AmO2++": 0.39,
            "Ba++": 0.07,
            "Ca++": 0.14,
            "Ca4Th(OH)8++++": -0.01,
            "Cd(HCO3)+": 0.2,
            "Cd++": 0.16,
            "CdCl+": 0.127,
            "CdI+": 0.136,
            "Cm(H2PO4)++": 0.191,
            "Cm(OH)++": -0.04,
            "Cm(OH)2+": -0.27,
            "Cm+++": 0.23,
            "CmCO3+": 0.35,
            "CmCl++": 0.191,
            "CmCl2+": 0.129,
            "CmSO4+": 0.157,
            "Co++": 0.16,
            "Cr+++": 0.3,
            "Cu++": 0.08,
            "Eu(CO3)+": 0.129,
            "Eu(H2PO4)++": 0.191,
            "Eu(NO3)++": 0.191,
            "Eu(OH)++": -0.04,
            "Eu(OH)2+": -0.29,
            "Eu(SO4)+": 0.157,
            "Eu+++": 0.23,
            "EuCl++": 0.191,
            "EuCl2+": 0.129,
            "EuF++": 0.191,
            "EuF2+": 0.129,
            "Fe(OH)++": 0.18600000000000003,
            "H+": 0.12,
            "H5(Edta)+": -0.23,
            "H6(Edta)++": -0.2,
            "Hf++++": 0.89,
            "Hg++": 0.168,
            "Hg+": 0.054000000000000006,
            "Ho(CO3)+": 0.129,
            "Ho(H2PO4)++": 0.191,
            "Ho(NO3)++": 0.191,
            "Ho(OH)++": -0.04,
            "Ho(OH)2+": -0.29,
            "Ho(SO4)+": 0.157,
            "Ho+++": 0.23,
            "HoCl++": 0.191,
            "HoCl2+": 0.129,
            "HoF++": 0.191,
            "HoF2+": 0.129,
            "K+": 0.0,
            "Li+": 0.1,
            "Mg++": 0.19,
            "Mn++": 0.13,
            "NH4+": -0.01,
            "Ni(HCO3)+": 0.085,
            "Ni(NO3)+": 0.06,
            "Ni(OH)+": -0.01,
            "Ni(Scn)+": 0.11,
            "Ni++": 0.17,
            "NiCl+": 0.1,
            "NiF+": 0.065,
            "Np(CO3)+": 0.129,
            "Np(OH)++": -0.04,
            "Np(OH)+++": 0.2,
            "Np(OH)2+": -0.29,
            "Np(OH)2++": 0.1,
            "Np(OH)3+": 0.05,
            "Np(SO4)+": 0.157,
            "Np(SO4)++": 0.23199999999999998,
            "Np+++": 0.23,
            "Np++++": 0.4,
            "NpF2++": 0.18600000000000003,
            "NpF3+": 0.1,
            "NpO2(NO3)+": 0.22,
            "NpO2(OH)+": -0.003,
            "NpO2+": 0.09,
            "NpO2++": 0.223,
            "NpO2Cl+": 0.318,
            "NpO2F+": 0.19699999999999998,
            "Pa++++": 0.3,
            "PaO(OH)++": 0.13,
            "Pb++": 0.081,
            "PbF+": 0.14,
            "Pd++": 0.16,
            "PdBr+": 0.175,
            "PdCl+": 0.175,
            "Pu(CO3)+": 0.129,
            "Pu(NO3)++": 0.191,
            "Pu(OH)++": -0.04,
            "Pu(OH)+++": 0.2,
            "Pu(OH)2+": -0.29,
            "Pu(OH)2++": 0.1,
            "Pu(OH)3+": 0.05,
            "Pu(SO4)+": 0.157,
            "Pu(SO4)++": 0.23199999999999998,
            "Pu+++": 0.23,
            "Pu++++": 0.37,
            "PuBr+++": 0.1,
            "PuCl+++": 0.1,
            "PuF+++": 0.1,
            "PuF2++": 0.177,
            "PuF3+": 0.1,
            "PuI++": 0.191,
            "PuI+++": 0.1,
            "PuO2(OH)+": -0.003,
            "PuO2+": 0.129,
            "PuO2++": 0.223,
            "PuO2Cl+": 0.318,
            "PuO2F+": 0.19699999999999998,
            "PuO2NO3+": 0.22,
            "Sm(CO3)+": 0.129,
            "Sm(H2PO4)++": 0.191,
            "Sm(NO3)++": 0.191,
            "Sm(OH)++": -0.04,
            "Sm(OH)2+": -0.29,
            "Sm(SO4)+": 0.157,
            "Sm+++": 0.23,
            "SmCl++": 0.191,
            "SmF++": 0.191,
            "Sn++": 0.14,
            "Th(OH)+++": 0.19,
            "Th(OH)2++": 0.13,
            "Th(OH)3+": 0.06,
            "Th(SO4)++": 0.14,
            "Th++++": 0.7,
            "Th2(OH)2++++++": 0.4,
            "Th2(OH)3+++++": 0.29,
            "Th4(OH)12++++": 0.25,
            "Th4(OH)8++++++++": 0.7,
            "Th6(OH)14+10": 0.83,
            "Th6(OH)15+++++++++": 0.72,
            "ThCl+++": 0.62,
            "U(NO3)2++": 0.23600000000000002,
            "U(OH)+++": 0.2,
            "U(OH)2++": 0.1,
            "U(OH)3+": 0.05,
            "U(SO4)++": 0.149,
            "U+++": 0.23,
            "U++++": 0.36,
            "UCl+++": 0.1,
            "UF+++": 0.1,
            "UF2++": 0.149,
            "UF3+": 0.1,
            "UO2(NO3)+": 0.22,
            "UO2(OH)+": -0.003,
            "UO2+": 0.18,
            "UO2++": 0.46,
            "UO2Br+": 0.16899999999999998,
            "UO2Cl+": 0.22,
            "UO2F+": 0.04,
            "Zn++": 0.163,
            "Zr++++": 0.89,
        },
        "Cm(CO3)2-": {"Na+": 0.34},
        "Cm(CO3)3---": {"Na+": 0.16},
        "Cm(H2PO4)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Cm(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Cm(OH)2+": {"Cl-": -0.27, "ClO4-": 0.17},
        "Cm(SO4)2-": {"Na+": -0.05},
        "Cm+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "CmCO3+": {"Cl-": 0.35},
        "CmCl++": {"Cl-": 0.191, "ClO4-": 0.39},
        "CmCl2+": {"Cl-": 0.129},
        "CmF++": {"ClO4-": 0.39},
        "CmF2+": {"ClO4-": 0.17},
        "CmNO3++": {"ClO4-": 0.39},
        "CmSO4+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Cn-": {"Na+": 0.07},
        "Co++": {"Cl-": 0.16, "ClO4-": 0.34, "NO3-": 0.14},
        "Cr+++": {"Cl-": 0.3, "NO3-": 0.27},
        "Cu+": {"ClO4-": 0.11},
        "Cu++": {"Cl-": 0.08, "ClO4-": 0.32, "NO3-": 0.11},
        "Edta----": {"Na+": 0.32},
        "Eu(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Eu(CO3)2-": {"Na+": -0.14},
        "Eu(CO3)3---": {"Na+": -0.23},
        "Eu(H2PO4)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Eu(NO3)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Eu(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Eu(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Eu(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Eu(SO4)2-": {"Na+": -0.05},
        "Eu+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "EuCl++": {"Cl-": 0.191, "ClO4-": 0.39},
        "EuCl2+": {"Cl-": 0.129},
        "EuF++": {"Cl-": 0.191},
        "EuF2+": {"Cl-": 0.129},
        "F-": {"Na+": 0.02},
        "Fe(OH)++": {"Cl-": 0.18600000000000003},
        "Fe+++": {"ClO4-": 0.56, "NO3-": 0.42},
        "H(Cit)--": {"Na+": -0.04},
        "H(Edta)---": {"Na+": -0.1},
        "H(Ox)-": {"Na+": -0.07},
        "H(SO4)-": {"Na+": -0.01},
        "H(SeO3)-": {"Na+": 0.02},
        "H(SeO4)-": {"Na+": 0.0},
        "H+": {"Cl-": 0.12, "ClO4-": 0.14, "NO3-": 0.07},
        "H2(Cit)-": {"Na+": -0.05},
        "H2(Edta)--": {"Na+": -0.37},
        "H2(PO4)-": {"Na+": -0.08},
        "H2(SiO4)--": {"Na+": -0.1},
        "H3(Edta)-": {"Na+": -0.33},
        "H3(SiO4)-": {"Na+": -0.08},
        "H5(Edta)+": {"Cl-": -0.23, "ClO4-": -0.23, "NO3-": -0.23},
        "H6(Edta)++": {"Cl-": -0.2, "ClO4-": -0.2, "NO3-": -0.2},
        "HCO3-": {"Na+": 0.0},
        "HGlu-": {"Na+": -0.07},
        "HIsa-": {"Na+": -0.07},
        "HMoO4-": {"Na+": -0.099},
        "HPO4--": {"Na+": -0.15},
        "Hf(NO3)2++": {"ClO4-": 0.84},
        "Hf(OH)+++": {"ClO4-": 0.57},
        "Hf++++": {"Cl-": 0.89, "ClO4-": 0.89, "NO3-": 0.89},
        "HfCl+++": {"ClO4-": 0.87},
        "HfCl2++": {"ClO4-": 0.84},
        "HfF+++": {"ClO4-": 0.63},
        "HfF2++": {"ClO4-": 0.47},
        "HfNO3+++": {"ClO4-": 0.91},
        "Hg(SeO3)2--": {"Na+": 0.008},
        "Hg++": {"Cl-": 0.168},
        "Hg+": {"Cl-": 0.054000000000000006},
        "Ho(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Ho(CO3)2-": {"Na+": -0.14},
        "Ho(CO3)3---": {"Na+": -0.23},
        "Ho(H2PO4)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Ho(NO3)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Ho(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Ho(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Ho(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Ho(SO4)2-": {"Na+": -0.05},
        "Ho+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "HoCl++": {"Cl-": 0.191, "ClO4-": 0.39},
        "HoCl2+": {"Cl-": 0.129},
        "HoF++": {"Cl-": 0.191, "ClO4-": 0.39},
        "HoF2+": {"Cl-": 0.129, "ClO4-": 0.17},
        "I-": {"Na+": 0.08},
        "IO3-": {"Na+": -0.06},
        "K+": {"Cl-": 0.0, "NO3-": -0.11},
        "Li+": {"Cl-": 0.1, "ClO4-": 0.15, "NO3-": 0.08},
        "Mg(Cit)-": {"Na+": 0.03},
        "Mg(Edta)--": {"Na+": -0.01},
        "Mg(HEdta)-": {"Na+": 0.11},
        "Mg(Ox)2--": {"Na+": -0.15},
        "Mg++": {"Cl-": 0.19, "ClO4-": 0.33, "NO3-": 0.17},
        "Mn++": {"Cl-": 0.13},
        "Mo7O21(OH)3---": {"Na+": -1.455},
        "Mo7O22(OH)2----": {"Na+": -1.3459999999999999},
        "Mo7O23(OH)-----": {"Na+": -1.145},
        "Mo7O24-6": {"Na+": -1.265},
        "MoO4--": {"Na+": 0.034},
        "NH4+": {"Cl-": -0.01, "ClO4-": -0.08, "NO3-": -0.06},
        "NO3-": {
            "Na+": -0.04,
            "(UO2)2(OH)2++": 0.49,
            "Ba++": -0.28,
            "Ca++": 0.02,
            "Cd++": 0.09,
            "Co++": 0.14,
            "Cr+++": 0.27,
            "Cu++": 0.11,
            "Fe+++": 0.42,
            "H+": 0.07,
            "H5(Edta)+": -0.23,
            "H6(Edta)++": -0.2,
            "Hf++++": 0.89,
            "K+": -0.11,
            "Li+": 0.08,
            "Mg++": 0.17,
            "NH4+": -0.06,
            "Ni++": 0.182,
            "Pb++": -0.2,
            "Th(NO3)+++": 0.56,
            "Th(NO3)2++": 0.43,
            "Th(OH)+++": 0.2,
            "Th(OH)2++": 0.1,
            "Th(OH)3+": 0.05,
            "Th++++": 0.7,
            "Th2(OH)2++++++": 0.69,
            "Th2(OH)3+++++": 0.69,
            "Th4(OH)12++++": 0.42,
            "Th4(OH)8++++++++": 1.59,
            "Th6(OH)14+10": 2.9,
            "Th6(OH)15+++++++++": 2.2,
            "ThF+++": 0.25,
            "ThF2++": 0.15,
            "ThF3+": 0.0,
            "UI+++": 0.56,
            "UO2(OH)+": 0.51,
            "UO2++": 0.46,
            "Zn++": 0.16,
            "Zr++++": 0.89,
        },
        "Na+": {
            "ClO4-": 0.01,
            "(NpO2)2CO3(OH)3-": 0.0,
            "(NpO2)3(CO3)6------": -0.46,
            "(PuO2)3(CO3)6------": -0.46,
            "(UO2)2(CO3)(OH)3-": 0.0,
            "(UO2)2(NpO2)(CO3)6------": 0.09,
            "(UO2)3(CO3)6------": 0.37,
            "Ag(SeO3)-": -0.024,
            "Am(CO3)2-": -0.14,
            "Am(CO3)3---": -0.23,
            "Am(CO3)5------": -0.3,
            "Am(Edta)-": 0.01,
            "Am(Ox)2-": -0.21,
            "Am(Ox)3---": -0.23,
            "Am(SO4)2-": -0.05,
            "AmO2(CO3)-": -0.18,
            "AmO2(CO3)2---": -0.33,
            "AmO2(CO3)3-----": -0.53,
            "B(OH)4-": -0.07,
            "Br-": 0.05,
            "CO3--": -0.08,
            "Cit---": -0.076,
            "Cl-": 0.03,
            "Cm(CO3)2-": 0.34,
            "Cm(CO3)3---": 0.16,
            "Cm(SO4)2-": -0.05,
            "Cn-": 0.07,
            "Edta----": 0.32,
            "Eu(CO3)2-": -0.14,
            "Eu(CO3)3---": -0.23,
            "Eu(SO4)2-": -0.05,
            "F-": 0.02,
            "H(Cit)--": -0.04,
            "H(Edta)---": -0.1,
            "H(Ox)-": -0.07,
            "H(SO4)-": -0.01,
            "H(SeO3)-": 0.02,
            "H(SeO4)-": 0.0,
            "H2(Cit)-": -0.05,
            "H2(Edta)--": -0.37,
            "H2(PO4)-": -0.08,
            "H2(SiO4)--": -0.1,
            "H3(Edta)-": -0.33,
            "H3(SiO4)-": -0.08,
            "HCO3-": 0.0,
            "HGlu-": -0.07,
            "HIsa-": -0.07,
            "HMoO4-": -0.099,
            "HPO4--": -0.15,
            "Hg(SeO3)2--": 0.008,
            "Ho(CO3)2-": -0.14,
            "Ho(CO3)3---": -0.23,
            "Ho(SO4)2-": -0.05,
            "I-": 0.08,
            "IO3-": -0.06,
            "Mg(Cit)-": 0.03,
            "Mg(Edta)--": -0.01,
            "Mg(HEdta)-": 0.11,
            "Mg(Ox)2--": -0.15,
            "Mo7O21(OH)3---": -1.455,
            "Mo7O22(OH)2----": -1.3459999999999999,
            "Mo7O23(OH)-----": -1.145,
            "Mo7O24------": -1.265,
            "MoO4--": 0.034,
            "NO3-": -0.04,
            "Ni(CO3)2--": 0.003,
            "Ni(Cit)-": 0.22,
            "Ni(Cn)4--": 0.185,
            "Ni(Cn)5---": 0.25,
            "Ni(OH)3-": 0.88,
            "Ni(SO4)2--": -0.263,
            "Ni(Scn)3-": 0.66,
            "Np(CO3)(OH)3-": -0.11,
            "Np(CO3)2-": -0.14,
            "Np(CO3)3---": -0.23,
            "Np(CO3)4----": -0.09,
            "Np(CO3)5------": 0.0,
            "Np(OH)4(CO3)--": -0.13,
            "Np(SO4)2-": -0.05,
            "NpO2(CO3)-": -0.18,
            "NpO2(CO3)2--": -0.02,
            "NpO2(CO3)2---": -0.33,
            "NpO2(CO3)2OH----": -0.4,
            "NpO2(CO3)3----": -0.4,
            "NpO2(CO3)3-----": -0.53,
            "NpO2(Cit)--": -0.06,
            "NpO2(Edta)---": 0.2,
            "NpO2(HEdta)--": 0.07,
            "NpO2(HPO4)2--": -0.1,
            "NpO2(OH)2-": -0.01,
            "NpO2(Ox)-": -0.4,
            "NpO2(Ox)2---": -0.3,
            "NpO2(SO4)-": -0.74,
            "NpO2(SO4)2--": -0.12,
            "OH-": 0.04,
            "Ox--": -0.08,
            "PO4---": -0.25,
            "Pb(OH)3-": 0.02,
            "Pb(SO4)2--": -0.52,
            "Pd(SO4)2--": -0.12,
            "PdBr3-": 0.0,
            "PdBr4--": 0.1,
            "PdCl3-": 0.0,
            "PdCl4--": 0.1,
            "Pu(CO3)2-": -0.14,
            "Pu(CO3)3---": -0.23,
            "Pu(CO3)4----": -0.09,
            "Pu(CO3)5------": 0.0,
            "Pu(SO4)2-": -0.05,
            "PuO2(CO3)2--": -0.7,
            "PuO2(CO3)3----": -0.2,
            "PuO2(CO3)3-----": -0.53,
            "PuO2(SO4)-": -0.74,
            "PuO2(SO4)2--": -0.12,
            "PuO2CO3-": -0.18,
            "PuO2F3-": 0.0,
            "SO3--": -0.08,
            "SO4--": -0.12,
            "Scn-": 0.05,
            "SeO3--": -0.08,
            "SeO4--": -0.12,
            "Si2O2(OH)5-": -0.08,
            "Si2O3(OH)4--": -0.15,
            "Si3O5(OH)5---": -0.25,
            "Si3O6(OH)3---": -0.25,
            "Si4O8(OH)4----": -0.26,
            "Sm(CO3)2-": -0.14,
            "Sm(CO3)3---": -0.23,
            "Sm(SO4)2-": -0.05,
            "Sn(OH)3-": 0.22,
            "SnBr3-": 0.16,
            "SnCl3-": 0.04,
            "Th(CO3)5------": -0.3,
            "Th(OH)(CO3)4-----": -0.22,
            "Th(OH)2(CO3)2--": -0.1,
            "Th(OH)3(CO3)-": -0.05,
            "Th(OH)4(CO3)--": -0.1,
            "Th(SO4)3--": -0.091,
            "U(CO3)4----": -0.09,
            "U(CO3)5------": -0.3,
            "UO2(CO3)2--": -0.02,
            "UO2(CO3)3----": -0.01,
            "UO2(CO3)3-----": -0.62,
            "UO2(Cit)-": -0.11,
            "UO2(OH)3-": -0.09,
            "UO2(Ox)2--": -0.18,
            "UO2(Ox)3----": -0.01,
            "UO2(SO4)2--": -0.12,
            "UO2F3-": -0.14,
            "UO2F4--": -0.3,
            "Zr(CO3)4----": -0.09,
            "Zr(OH)6--": -0.1,
            "ZrF5-": -0.14,
            "ZrF6--": -0.15,
        },
        "Ni(CO3)2--": {"Na+": 0.003},
        "Ni(Cit)-": {"Na+": 0.22},
        "Ni(Cn)4--": {"Na+": 0.185},
        "Ni(Cn)5---": {"Na+": 0.25},
        "Ni(HCO3)+": {"Cl-": 0.085},
        "Ni(NO3)+": {"Cl-": 0.06, "ClO4-": 0.44},
        "Ni(OH)+": {"Cl-": -0.01, "ClO4-": 0.14},
        "Ni(OH)3-": {"Na+": 0.88},
        "Ni(SO4)2--": {"Na+": -0.263},
        "Ni(Scn)+": {"Cl-": 0.11, "ClO4-": 0.31},
        "Ni(Scn)3-": {"Na+": 0.66},
        "Ni++": {"Cl-": 0.17, "ClO4-": 0.37, "NO3-": 0.182},
        "Ni4(OH)4++++": {"ClO4-": 1.08},
        "NiCl+": {"Cl-": 0.1, "ClO4-": 0.34},
        "NiF+": {"Cl-": 0.065, "ClO4-": 0.34},
        "NiHS+": {"ClO4-": -0.85},
        "Np(CO3)(OH)3-": {"Na+": -0.11},
        "Np(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Np(CO3)2-": {"Na+": -0.14},
        "Np(CO3)3---": {"Na+": -0.23},
        "Np(CO3)4----": {"Na+": -0.09},
        "Np(CO3)5-6": {"Na+": 0.0},
        "Np(NO3)+++": {"ClO4-": 0.71},
        "Np(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Np(OH)+++": {"Cl-": 0.2, "ClO4-": 0.5},
        "Np(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Np(OH)2++": {"Cl-": 0.1},
        "Np(OH)3+": {"Cl-": 0.05},
        "Np(OH)4(CO3)--": {"Na+": -0.13},
        "Np(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Np(SO4)++": {"Cl-": 0.23199999999999998, "ClO4-": 0.48},
        "Np(SO4)2-": {"Na+": -0.05},
        "Np+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "Np++++": {"Cl-": 0.4, "ClO4-": 0.84},
        "NpCl+++": {"ClO4-": 0.81},
        "NpF+++": {"ClO4-": 0.58},
        "NpF2++": {"Cl-": 0.18600000000000003, "ClO4-": 0.38},
        "NpF3+": {"Cl-": 0.1},
        "NpI+++": {"ClO4-": 0.77},
        "NpO2(CO3)-": {"Na+": -0.18},
        "NpO2(CO3)2--": {"Na+": -0.02},
        "NpO2(CO3)2---": {"Na+": -0.33},
        "NpO2(CO3)2OH----": {"Na+": -0.4},
        "NpO2(CO3)3----": {"Na+": -0.4},
        "NpO2(CO3)3-----": {"Na+": -0.53},
        "NpO2(Cit)--": {"Na+": -0.06},
        "NpO2(Edta)---": {"Na+": 0.2},
        "NpO2(HEdta)--": {"Na+": 0.07},
        "NpO2(HPO4)2--": {"Na+": -0.1},
        "NpO2(NO3)+": {"Cl-": 0.22, "ClO4-": 0.33},
        "NpO2(OH)+": {"Cl-": -0.003, "ClO4-": -0.06},
        "NpO2(OH)2-": {"Na+": -0.01},
        "NpO2(Ox)-": {"Na+": -0.4},
        "NpO2(Ox)2---": {"Na+": -0.3},
        "NpO2(SO4)-": {"Na+": -0.74},
        "NpO2(SO4)2--": {"Na+": -0.12},
        "NpO2+": {"Cl-": 0.09, "ClO4-": 0.25},
        "NpO2++": {"Cl-": 0.223, "ClO4-": 0.46},
        "NpO2Cl+": {"Cl-": 0.318, "ClO4-": 0.5},
        "NpO2F+": {"Cl-": 0.19699999999999998, "ClO4-": 0.29},
        "OH-": {"Na+": 0.04},
        "Ox--": {"Na+": -0.08},
        "PO4---": {"Na+": -0.25},
        "Pa++++": {"Cl-": 0.3},
        "PaO(OH)++": {"Cl-": 0.13},
        "Pb(OH)3-": {"Na+": 0.02},
        "Pb(SO4)2--": {"Na+": -0.52},
        "Pb++": {"Cl-": 0.081, "ClO4-": 0.15, "NO3-": -0.2},
        "PbF+": {"Cl-": 0.14},
        "Pd(SO4)2--": {"Na+": -0.12},
        "Pd++": {"Cl-": 0.16},
        "PdBr+": {"Cl-": 0.175},
        "PdBr3-": {"Na+": 0.0},
        "PdBr4--": {"Na+": 0.1},
        "PdCl+": {"Cl-": 0.175},
        "PdCl3-": {"Na+": 0.0},
        "PdCl4--": {"Na+": 0.1},
        "Pu(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Pu(CO3)2-": {"Na+": -0.14},
        "Pu(CO3)3---": {"Na+": -0.23},
        "Pu(CO3)4----": {"Na+": -0.09},
        "Pu(CO3)5-6": {"Na+": 0.0},
        "Pu(NO3)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Pu(NO3)+++": {"ClO4-": 0.59},
        "Pu(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Pu(OH)+++": {"Cl-": 0.2, "ClO4-": 0.5},
        "Pu(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Pu(OH)2++": {"Cl-": 0.1},
        "Pu(OH)3+": {"Cl-": 0.05},
        "Pu(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Pu(SO4)++": {"Cl-": 0.23199999999999998, "ClO4-": 0.36},
        "Pu(SO4)2-": {"Na+": -0.05},
        "Pu+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "Pu++++": {"Cl-": 0.37, "ClO4-": 0.82},
        "PuBr+++": {"Cl-": 0.1, "ClO4-": 0.58},
        "PuCl+++": {"Cl-": 0.1, "ClO4-": 0.85},
        "PuF+++": {"Cl-": 0.1, "ClO4-": 0.56},
        "PuF2++": {"Cl-": 0.177, "ClO4-": 0.36},
        "PuF3+": {"Cl-": 0.1},
        "PuI++": {"Cl-": 0.191, "ClO4-": 0.39},
        "PuI+++": {"Cl-": 0.1},
        "PuO2(CO3)2--": {"Na+": -0.7},
        "PuO2(CO3)3----": {"Na+": -0.2},
        "PuO2(CO3)3-----": {"Na+": -0.53},
        "PuO2(OH)+": {"Cl-": -0.003},
        "PuO2(SO4)-": {"Na+": -0.74},
        "PuO2(SO4)2--": {"Na+": -0.12},
        "PuO2+": {"Cl-": 0.129, "ClO4-": 0.24},
        "PuO2++": {"Cl-": 0.223, "ClO4-": 0.46},
        "PuO2CO3-": {"Na+": -0.18},
        "PuO2Cl+": {"Cl-": 0.318, "ClO4-": 0.5},
        "PuO2F+": {"Cl-": 0.19699999999999998, "ClO4-": 0.29},
        "PuO2F3-": {"Na+": 0.0},
        "PuO2NO3+": {"Cl-": 0.22, "ClO4-": 0.33},
        "SO3--": {"Na+": -0.08},
        "SO4--": {"Na+": -0.12},
        "Scn-": {"Na+": 0.05},
        "SeO3--": {"Na+": -0.08},
        "SeO4--": {"Na+": -0.12},
        "Si2O2(OH)5-": {"Na+": -0.08},
        "Si2O3(OH)4--": {"Na+": -0.15},
        "Si3O5(OH)5---": {"Na+": -0.25},
        "Si3O6(OH)3---": {"Na+": -0.25},
        "Si4O8(OH)4----": {"Na+": -0.26},
        "Sm(CO3)+": {"Cl-": 0.129, "ClO4-": 0.17},
        "Sm(CO3)2-": {"Na+": -0.14},
        "Sm(CO3)3---": {"Na+": -0.23},
        "Sm(H2PO4)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Sm(NO3)++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Sm(OH)++": {"Cl-": -0.04, "ClO4-": 0.39},
        "Sm(OH)2+": {"Cl-": -0.29, "ClO4-": 0.17},
        "Sm(SO4)+": {"Cl-": 0.157, "ClO4-": 0.22},
        "Sm(SO4)2-": {"Na+": -0.05},
        "Sm+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "SmCl++": {"Cl-": 0.191, "ClO4-": 0.39},
        "SmF++": {"Cl-": 0.191, "ClO4-": 0.39},
        "Sn(OH)+": {"ClO4-": -0.07},
        "Sn(OH)3-": {"Na+": 0.22},
        "Sn++": {"Cl-": 0.14, "ClO4-": 0.19},
        "Sn++++": {"ClO4-": 0.7},
        "Sn3(OH)4++": {"ClO4-": -0.02},
        "SnBr+": {"ClO4-": 0.17},
        "SnBr3-": {"Na+": 0.16},
        "SnCl+": {"ClO4-": 0.08},
        "SnCl3-": {"Na+": 0.04},
        "SnF+": {"ClO4-": 0.14},
        "Th(CO3)5-6": {"Na+": -0.3},
        "Th(H2PO4)+++": {"ClO4-": 0.5},
        "Th(H2PO4)2++": {"ClO4-": 0.4},
        "Th(H3PO4)(H2PO4)+++": {"ClO4-": 0.5},
        "Th(H3PO4)++++": {"ClO4-": 0.7},
        "Th(NO3)+++": {"ClO4-": 0.56, "NO3-": 0.56},
        "Th(NO3)2++": {"ClO4-": 0.43, "NO3-": 0.43},
        "Th(OH)(CO3)4-----": {"Na+": -0.22},
        "Th(OH)+++": {"Cl-": 0.19, "ClO4-": 0.48, "NO3-": 0.2},
        "Th(OH)2(CO3)2--": {"Na+": -0.1},
        "Th(OH)2++": {"Cl-": 0.13, "ClO4-": 0.33, "NO3-": 0.1},
        "Th(OH)3(CO3)-": {"Na+": -0.05},
        "Th(OH)3+": {"Cl-": 0.06, "ClO4-": 0.15, "NO3-": 0.05},
        "Th(OH)4(CO3)--": {"Na+": -0.1},
        "Th(SO4)++": {"Cl-": 0.14, "ClO4-": 0.3},
        "Th(SO4)3--": {"Na+": -0.091},
        "Th++++": {"Cl-": 0.7, "ClO4-": 0.7, "NO3-": 0.7},
        "Th2(OH)2+6": {"Cl-": 0.4, "ClO4-": 1.22, "NO3-": 0.69},
        "Th2(OH)3+5": {"Cl-": 0.29, "ClO4-": 0.91, "NO3-": 0.69},
        "Th4(OH)12++++": {"Cl-": 0.25, "ClO4-": 0.56, "NO3-": 0.42},
        "Th4(OH)8+8": {"Cl-": 0.7, "ClO4-": 1.69, "NO3-": 1.59},
        "Th6(OH)14+10": {"Cl-": 0.83, "ClO4-": 2.2, "NO3-": 2.9},
        "Th6(OH)15+9": {"Cl-": 0.72, "ClO4-": 1.85, "NO3-": 2.2},
        "ThCl+++": {"Cl-": 0.62, "ClO4-": 0.62},
        "ThF+++": {"ClO4-": 0.48, "NO3-": 0.25},
        "ThF2++": {"ClO4-": 0.3, "NO3-": 0.15},
        "ThF3+": {"ClO4-": 0.1, "NO3-": 0.0},
        "U(CO3)4----": {"Na+": -0.09},
        "U(CO3)5-6": {"Na+": -0.3},
        "U(NO3)+++": {"ClO4-": 0.62},
        "U(NO3)2++": {"Cl-": 0.23600000000000002, "ClO4-": 0.49},
        "U(OH)+++": {"Cl-": 0.2, "ClO4-": 0.48},
        "U(OH)2++": {"Cl-": 0.1},
        "U(OH)3+": {"Cl-": 0.05},
        "U(SO4)++": {"Cl-": 0.149, "ClO4-": 0.3},
        "U+++": {"Cl-": 0.23, "ClO4-": 0.49},
        "U++++": {"Cl-": 0.36, "ClO4-": 0.76},
        "UBr+++": {"ClO4-": 0.52},
        "UCl+++": {"Cl-": 0.1, "ClO4-": 0.5},
        "UF+++": {"Cl-": 0.1, "ClO4-": 0.48},
        "UF2++": {"Cl-": 0.149, "ClO4-": 0.3},
        "UF3+": {"Cl-": 0.1, "ClO4-": 0.1},
        "UI+++": {"ClO4-": 0.55, "NO3-": 0.56},
        "UO2(CO3)2--": {"Na+": -0.02},
        "UO2(CO3)3----": {"Na+": -0.01},
        "UO2(CO3)3-----": {"Na+": -0.62},
        "UO2(Cit)-": {"Na+": -0.11},
        "UO2(NO3)+": {"Cl-": 0.22, "ClO4-": 0.33},
        "UO2(OH)+": {"Cl-": -0.003, "ClO4-": -0.06, "NO3-": 0.51},
        "UO2(OH)3-": {"Na+": -0.09},
        "UO2(Ox)2--": {"Na+": -0.18},
        "UO2(Ox)3----": {"Na+": -0.01},
        "UO2(SO4)2--": {"Na+": -0.12},
        "UO2+": {"Cl-": 0.18, "ClO4-": 0.26},
        "UO2++": {"Cl-": 0.46, "ClO4-": 0.46, "NO3-": 0.46},
        "UO2Br+": {"Cl-": 0.16899999999999998, "ClO4-": 0.24},
        "UO2Cl+": {"Cl-": 0.22, "ClO4-": 0.33},
        "UO2F+": {"Cl-": 0.04, "ClO4-": 0.28},
        "UO2F3-": {"Na+": -0.14},
        "UO2F4--": {"Na+": -0.3},
        "Zn++": {"Cl-": 0.163, "ClO4-": 0.33, "NO3-": 0.16},
        "Zr(CO3)4----": {"Na+": -0.09},
        "Zr(NO3)2++": {"ClO4-": 0.84},
        "Zr(OH)+++": {"ClO4-": 0.57},
        "Zr(OH)2++": {"ClO4-": 0.62},
        "Zr(OH)6--": {"Na+": -0.1},
        "Zr++++": {"Cl-": 0.89, "ClO4-": 0.89, "NO3-": 0.89},
        "Zr4(OH)15+": {"ClO4-": 0.09},
        "ZrCl+++": {"ClO4-": 0.87},
        "ZrCl2++": {"ClO4-": 0.84},
        "ZrF+++": {"ClO4-": 0.63},
        "ZrF2++": {"ClO4-": 0.47},
        "ZrF5-": {"Na+": -0.14},
        "ZrF6--": {"Na+": -0.15},
        "ZrNO3+++": {"ClO4-": 0.88},
        "ClO4-": {
            "(NpO2)2(OH)2++": 0.57,
            "(NpO2)3(OH)5+": 0.45,
            "(UO2)2(OH)2++": 0.57,
            "Am(CO3)+": 0.17,
            "Am(H2PO4)++": 0.39,
            "Am(NO3)++": 0.39,
            "Am(OH)++": 0.39,
            "Am(OH)2+": 0.17,
            "Am(Ox)+": 0.08,
            "Am(SO4)+": 0.22,
            "Am+++": 0.49,
            "AmCl++": 0.39,
            "AmF++": 0.39,
            "AmF2+": 0.17,
            "Ba++": 0.15,
            "Ca++": 0.27,
            "Ca4Th(OH)8++++": 0.21,
            "CdCl+": 0.25,
            "CdI+": 0.27,
            "Cm(H2PO4)++": 0.39,
            "Cm(OH)++": 0.39,
            "Cm(OH)2+": 0.17,
            "Cm+++": 0.49,
            "CmCl++": 0.39,
            "CmF++": 0.39,
            "CmF2+": 0.17,
            "CmNO3++": 0.39,
            "CmSO4+": 0.22,
            "Co++": 0.34,
            "Cu+": 0.11,
            "Cu++": 0.32,
            "Eu(CO3)+": 0.17,
            "Eu(H2PO4)++": 0.39,
            "Eu(NO3)++": 0.39,
            "Eu(OH)++": 0.39,
            "Eu(OH)2+": 0.17,
            "Eu(SO4)+": 0.22,
            "Eu+++": 0.49,
            "EuCl++": 0.39,
            "Fe+++": 0.56,
            "H+": 0.14,
            "H5(Edta)+": -0.23,
            "H6(Edta)++": -0.2,
            "Hf(NO3)2++": 0.84,
            "Hf(OH)+++": 0.57,
            "Hf++++": 0.89,
            "HfCl+++": 0.87,
            "HfCl2++": 0.84,
            "HfF+++": 0.63,
            "HfF2++": 0.47,
            "HfNO3+++": 0.91,
            "Ho(CO3)+": 0.17,
            "Ho(H2PO4)++": 0.39,
            "Ho(NO3)++": 0.39,
            "Ho(OH)++": 0.39,
            "Ho(OH)2+": 0.17,
            "Ho(SO4)+": 0.22,
            "Ho+++": 0.49,
            "HoCl++": 0.39,
            "HoF++": 0.39,
            "HoF2+": 0.17,
            "Li+": 0.15,
            "Mg++": 0.33,
            "NH4+": -0.08,
            "Na+": 0.01,
            "Ni(NO3)+": 0.44,
            "Ni(OH)+": 0.14,
            "Ni(Scn)+": 0.31,
            "Ni++": 0.37,
            "Ni4(OH)4++++": 1.08,
            "NiCl+": 0.34,
            "NiF+": 0.34,
            "NiHS+": -0.85,
            "Np(CO3)+": 0.17,
            "Np(NO3)+++": 0.71,
            "Np(OH)++": 0.39,
            "Np(OH)+++": 0.5,
            "Np(OH)2+": 0.17,
            "Np(SO4)+": 0.22,
            "Np(SO4)++": 0.48,
            "Np+++": 0.49,
            "Np++++": 0.84,
            "NpCl+++": 0.81,
            "NpF+++": 0.58,
            "NpF2++": 0.38,
            "NpI+++": 0.77,
            "NpO2(NO3)+": 0.33,
            "NpO2(OH)+": -0.06,
            "NpO2+": 0.25,
            "NpO2++": 0.46,
            "NpO2Cl+": 0.5,
            "NpO2F+": 0.29,
            "Pb++": 0.15,
            "Pu(CO3)+": 0.17,
            "Pu(NO3)++": 0.39,
            "Pu(NO3)+++": 0.59,
            "Pu(OH)++": 0.39,
            "Pu(OH)+++": 0.5,
            "Pu(OH)2+": 0.17,
            "Pu(SO4)+": 0.22,
            "Pu(SO4)++": 0.36,
            "Pu+++": 0.49,
            "Pu++++": 0.82,
            "PuBr+++": 0.58,
            "PuCl+++": 0.85,
            "PuF+++": 0.56,
            "PuF2++": 0.36,
            "PuI++": 0.39,
            "PuO2+": 0.24,
            "PuO2++": 0.46,
            "PuO2Cl+": 0.5,
            "PuO2F+": 0.29,
            "PuO2NO3+": 0.33,
            "Sm(CO3)+": 0.17,
            "Sm(H2PO4)++": 0.39,
            "Sm(NO3)++": 0.39,
            "Sm(OH)++": 0.39,
            "Sm(OH)2+": 0.17,
            "Sm(SO4)+": 0.22,
            "Sm+++": 0.49,
            "SmCl++": 0.39,
            "SmF++": 0.39,
            "Sn(OH)+": -0.07,
            "Sn++": 0.19,
            "Sn++++": 0.7,
            "Sn3(OH)4++": -0.02,
            "SnBr+": 0.17,
            "SnCl+": 0.08,
            "SnF+": 0.14,
            "Th(H2PO4)+++": 0.5,
            "Th(H2PO4)2++": 0.4,
            "Th(H3PO4)(H2PO4)+++": 0.5,
            "Th(H3PO4)++++": 0.7,
            "Th(NO3)+++": 0.56,
            "Th(NO3)2++": 0.43,
            "Th(OH)+++": 0.48,
            "Th(OH)2++": 0.33,
            "Th(OH)3+": 0.15,
            "Th(SO4)++": 0.3,
            "Th++++": 0.7,
            "Th2(OH)2++++++": 1.22,
            "Th2(OH)3+++++": 0.91,
            "Th4(OH)12++++": 0.56,
            "Th4(OH)8++++++++": 1.69,
            "Th6(OH)14+10": 2.2,
            "Th6(OH)15+++++++++": 1.85,
            "ThCl+++": 0.62,
            "ThF+++": 0.48,
            "ThF2++": 0.3,
            "ThF3+": 0.1,
            "U(NO3)+++": 0.62,
            "U(NO3)2++": 0.49,
            "U(OH)+++": 0.48,
            "U(SO4)++": 0.3,
            "U+++": 0.49,
            "U++++": 0.76,
            "UBr+++": 0.52,
            "UCl+++": 0.5,
            "UF+++": 0.48,
            "UF2++": 0.3,
            "UF3+": 0.1,
            "UI+++": 0.55,
            "UO2(NO3)+": 0.33,
            "UO2(OH)+": -0.06,
            "UO2+": 0.26,
            "UO2++": 0.46,
            "UO2Br+": 0.24,
            "UO2Cl+": 0.33,
            "UO2F+": 0.28,
            "Zn++": 0.33,
            "Zr(NO3)2++": 0.84,
            "Zr(OH)+++": 0.57,
            "Zr(OH)2++": 0.62,
            "Zr++++": 0.89,
            "Zr4(OH)15+": 0.09,
            "ZrCl+++": 0.87,
            "ZrCl2++": 0.84,
            "ZrF+++": 0.63,
            "ZrF2++": 0.47,
            "ZrNO3+++": 0.88,
        },
    },
    "conductivity": {
        # S cm2 mol-1
        # Ref: http:#www.aqion.de/site/194
        "Ag+": 61.9,
        "Al+++": 188.9,
        "Ba++": 127.4,
        "Be++": 90.0,
        "Ca++": 119.1,
        "CaHCO3+": 19.0,
        "Cd++": 107.7,
        "Co++": 110.0,
        "Cr+++": 201.1,
        "Cu++": 110.1,
        "Fe++": 108.0,
        "Fe+++": 204.1,
        "H+": 349.6,
        "Hg++": 137.2,
        "K+": 73.6,
        "Li+": 38.7,
        "Mg++": 105.1,
        "MgHCO3+": 18.0,
        "Mn++": 103.4,
        "Na+": 50.0,
        "NH4+": 74.4,
        "Pb++": 142.0,
        "Sr++": 119.3,
        "UO2++": 64.0,
        "Zn++": 107.4,
        "Br-": 75.5,
        "Cl-": 76.2,
        "CO3--": 143.5,
        "CN-": 78.0,
        "CNO-": 64.6,
        "CrO4--": 170.0,
        "F-": 54.8,
        "H2AsO4-": 34.0,
        "H2PO4-": 31.8,
        "HCO3-": 44.3,
        "HPO4--": 103.6,
        "HS-": 65.0,
        "HSO4-": 50.0,
        "I-": 76.8,
        "KSO4-": 28.0,
        "MnO4-": 61.3,
        "MoO4--": 298.0,
        "NaCO3-": 22.0,
        "NaSO4-": 23.2,
        "NO2-": 71.7,
        "NO3-": 71.4,
        "OH-": 197.9,
        "PO4---": 206.8,
        "S--": 109.8,
        "SeO4--": 151.4,
        "SO4--": 160.7,
    },
}
