"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("aws-cdk-lib");
const aws_ivs_1 = require("aws-cdk-lib/aws-ivs");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
 * (experimental) A new IVS Playback Key Pair.
 *
 * @experimental
 */
class PlaybackKeyPair extends PlaybackKeyPairBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {});
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new aws_ivs_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs-alpha.PlaybackKeyPair", version: "2.0.0-alpha.2" };
//# sourceMappingURL=data:application/json;base64,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