import { Construct, Resource, ResourceProps } from '@aws-cdk/core';
import { AuthorizationType } from './method';
/**
 * Base class for all custom authorizers
 */
export declare abstract class Authorizer extends Resource implements IAuthorizer {
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x: any): x is Authorizer;
    abstract readonly authorizerId: string;
    readonly authorizationType?: AuthorizationType;
    constructor(scope: Construct, id: string, props?: ResourceProps);
}
/**
 * Represents an API Gateway authorizer.
 */
export interface IAuthorizer {
    /**
     * The authorizer ID.
     * @attribute
     */
    readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     */
    readonly authorizationType?: AuthorizationType;
}
