"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var JsonSchemaVersion;
(function (JsonSchemaVersion) {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    JsonSchemaVersion["DRAFT4"] = "http://json-schema.org/draft-04/schema#";
    JsonSchemaVersion["DRAFT7"] = "http://json-schema.org/draft-07/schema#";
})(JsonSchemaVersion = exports.JsonSchemaVersion || (exports.JsonSchemaVersion = {}));
var JsonSchemaType;
(function (JsonSchemaType) {
    JsonSchemaType["NULL"] = "null";
    JsonSchemaType["BOOLEAN"] = "boolean";
    JsonSchemaType["OBJECT"] = "object";
    JsonSchemaType["ARRAY"] = "array";
    JsonSchemaType["NUMBER"] = "number";
    JsonSchemaType["INTEGER"] = "integer";
    JsonSchemaType["STRING"] = "string";
})(JsonSchemaType = exports.JsonSchemaType || (exports.JsonSchemaType = {}));
//# sourceMappingURL=data:application/json;base64,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