"use strict";
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'isAuthorizer correctly detects an instance of type Authorizer'(test) {
        class MyAuthorizer extends lib_1.Authorizer {
            constructor() {
                super(...arguments);
                this.authorizerId = 'test-authorizer-id';
            }
            _attachToApi(_) {
                // do nothing
            }
        }
        const stack = new core_1.Stack();
        const authorizer = new MyAuthorizer(stack, 'authorizer');
        test.ok(lib_1.Authorizer.isAuthorizer(authorizer), 'type Authorizer expected but is not');
        test.ok(!lib_1.Authorizer.isAuthorizer(stack), 'type Authorizer found, when not expected');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hdXRob3JpemVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC5hdXRob3JpemVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSx3Q0FBc0M7QUFFdEMsZ0NBQTZDO0FBRTdDLGlCQUFTO0lBQ1AsK0RBQStELENBQUMsSUFBVTtRQUN4RSxNQUFNLFlBQWEsU0FBUSxnQkFBVTtZQUFyQzs7Z0JBQ2tCLGlCQUFZLEdBQUcsb0JBQW9CLENBQUM7WUFJdEQsQ0FBQztZQUhRLFlBQVksQ0FBQyxDQUFVO2dCQUM1QixhQUFhO1lBQ2YsQ0FBQztTQUNGO1FBQ0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLEVBQUUsQ0FBQztRQUMxQixNQUFNLFVBQVUsR0FBRyxJQUFJLFlBQVksQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFFekQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBVSxDQUFDLFlBQVksQ0FBQyxVQUFVLENBQUMsRUFBRSxxQ0FBcUMsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxnQkFBVSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsRUFBRSwwQ0FBMEMsQ0FBQyxDQUFDO1FBRXJGLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBBdXRob3JpemVyLCBSZXN0QXBpIH0gZnJvbSAnLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICAnaXNBdXRob3JpemVyIGNvcnJlY3RseSBkZXRlY3RzIGFuIGluc3RhbmNlIG9mIHR5cGUgQXV0aG9yaXplcicodGVzdDogVGVzdCkge1xuICAgIGNsYXNzIE15QXV0aG9yaXplciBleHRlbmRzIEF1dGhvcml6ZXIge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGF1dGhvcml6ZXJJZCA9ICd0ZXN0LWF1dGhvcml6ZXItaWQnO1xuICAgICAgcHVibGljIF9hdHRhY2hUb0FwaShfOiBSZXN0QXBpKTogdm9pZCB7XG4gICAgICAgIC8vIGRvIG5vdGhpbmdcbiAgICAgIH1cbiAgICB9XG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcbiAgICBjb25zdCBhdXRob3JpemVyID0gbmV3IE15QXV0aG9yaXplcihzdGFjaywgJ2F1dGhvcml6ZXInKTtcblxuICAgIHRlc3Qub2soQXV0aG9yaXplci5pc0F1dGhvcml6ZXIoYXV0aG9yaXplciksICd0eXBlIEF1dGhvcml6ZXIgZXhwZWN0ZWQgYnV0IGlzIG5vdCcpO1xuICAgIHRlc3Qub2soIUF1dGhvcml6ZXIuaXNBdXRob3JpemVyKHN0YWNrKSwgJ3R5cGUgQXV0aG9yaXplciBmb3VuZCwgd2hlbiBub3QgZXhwZWN0ZWQnKTtcblxuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxufTsiXX0=