# mypy-boto3-kinesisanalyticsv2

[![PyPI - mypy-boto3-kinesisanalyticsv2](https://img.shields.io/pypi/v/mypy-boto3-kinesisanalyticsv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisanalyticsv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kinesisanalyticsv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-kinesisanalyticsv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.KinesisAnalyticsV2 1.17.2](https://boto3.amazonaws.com/v1/documentation/api/1.17.2/reference/services/kinesisanalyticsv2.html#KinesisAnalyticsV2) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kinesisanalyticsv2](#mypy-boto3-kinesisanalyticsv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `KinesisAnalyticsV2` service.

```bash
python -m pip install boto3-stubs[kinesisanalyticsv2]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kinesisanalyticsv2]` in your environment: `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`

Both type checking and auto-complete should work for `KinesisAnalyticsV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[kinesisanalyticsv2]` in your environment: `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`

Both type checking and auto-complete should work for `KinesisAnalyticsV2` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kinesisanalyticsv2]` in your environment: `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`
- Run `mypy` as usual

Type checking should work for `KinesisAnalyticsV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kinesisanalyticsv2]` in your environment: `python -m pip install 'boto3-stubs[kinesisanalyticsv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `KinesisAnalyticsV2` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`KinesisAnalyticsV2Client` provides annotations for `boto3.client("kinesisanalyticsv2")`.

```python
import boto3

from mypy_boto3_kinesisanalyticsv2 import KinesisAnalyticsV2Client

client: KinesisAnalyticsV2Client = boto3.client("kinesisanalyticsv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KinesisAnalyticsV2Client = session.client("kinesisanalyticsv2")
```

### Paginators annotations

`mypy_boto3_kinesisanalyticsv2.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_kinesisanalyticsv2 import KinesisAnalyticsV2Client
from mypy_boto3_kinesisanalyticsv2.paginator import (
    ListApplicationSnapshotsPaginator,
    ListApplicationsPaginator,
)

client: KinesisAnalyticsV2Client = boto3.client("kinesisanalyticsv2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_application_snapshots_paginator: ListApplicationSnapshotsPaginator = client.get_paginator("list_application_snapshots")
list_applications_paginator: ListApplicationsPaginator = client.get_paginator("list_applications")
```







### Typed dictionations

`mypy_boto3_kinesisanalyticsv2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_kinesisanalyticsv2.type_defs import (
    ApplicationCodeConfigurationDescriptionTypeDef,
    ApplicationCodeConfigurationTypeDef,
    ApplicationCodeConfigurationUpdateTypeDef,
    ApplicationConfigurationDescriptionTypeDef,
    ApplicationDetailTypeDef,
    ApplicationRestoreConfigurationTypeDef,
    ApplicationSnapshotConfigurationDescriptionTypeDef,
    ApplicationSnapshotConfigurationTypeDef,
    ApplicationSnapshotConfigurationUpdateTypeDef,
    ApplicationSummaryTypeDef,
    CSVMappingParametersTypeDef,
    CheckpointConfigurationDescriptionTypeDef,
    CheckpointConfigurationTypeDef,
    CheckpointConfigurationUpdateTypeDef,
    CloudWatchLoggingOptionDescriptionTypeDef,
    CodeContentDescriptionTypeDef,
    CodeContentTypeDef,
    CodeContentUpdateTypeDef,
    DestinationSchemaTypeDef,
    EnvironmentPropertiesTypeDef,
    EnvironmentPropertyDescriptionsTypeDef,
    EnvironmentPropertyUpdatesTypeDef,
    FlinkApplicationConfigurationDescriptionTypeDef,
    FlinkApplicationConfigurationTypeDef,
    FlinkApplicationConfigurationUpdateTypeDef,
    FlinkRunConfigurationTypeDef,
    InputDescriptionTypeDef,
    InputLambdaProcessorDescriptionTypeDef,
    InputLambdaProcessorTypeDef,
    InputLambdaProcessorUpdateTypeDef,
    InputParallelismTypeDef,
    InputParallelismUpdateTypeDef,
    InputProcessingConfigurationDescriptionTypeDef,
    InputProcessingConfigurationTypeDef,
    InputProcessingConfigurationUpdateTypeDef,
    InputSchemaUpdateTypeDef,
    InputStartingPositionConfigurationTypeDef,
    InputTypeDef,
    InputUpdateTypeDef,
    JSONMappingParametersTypeDef,
    KinesisFirehoseInputDescriptionTypeDef,
    KinesisFirehoseInputTypeDef,
    KinesisFirehoseInputUpdateTypeDef,
    KinesisFirehoseOutputDescriptionTypeDef,
    KinesisFirehoseOutputTypeDef,
    KinesisFirehoseOutputUpdateTypeDef,
    KinesisStreamsInputDescriptionTypeDef,
    KinesisStreamsInputTypeDef,
    KinesisStreamsInputUpdateTypeDef,
    KinesisStreamsOutputDescriptionTypeDef,
    KinesisStreamsOutputTypeDef,
    KinesisStreamsOutputUpdateTypeDef,
    LambdaOutputDescriptionTypeDef,
    LambdaOutputTypeDef,
    LambdaOutputUpdateTypeDef,
    MappingParametersTypeDef,
    MonitoringConfigurationDescriptionTypeDef,
    MonitoringConfigurationTypeDef,
    MonitoringConfigurationUpdateTypeDef,
    OutputDescriptionTypeDef,
    OutputTypeDef,
    OutputUpdateTypeDef,
    ParallelismConfigurationDescriptionTypeDef,
    ParallelismConfigurationTypeDef,
    ParallelismConfigurationUpdateTypeDef,
    PropertyGroupTypeDef,
    RecordColumnTypeDef,
    RecordFormatTypeDef,
    ReferenceDataSourceDescriptionTypeDef,
    ReferenceDataSourceTypeDef,
    ReferenceDataSourceUpdateTypeDef,
    ResponseMetadata,
    RunConfigurationDescriptionTypeDef,
    S3ApplicationCodeLocationDescriptionTypeDef,
    S3ContentLocationTypeDef,
    S3ContentLocationUpdateTypeDef,
    S3ReferenceDataSourceDescriptionTypeDef,
    S3ReferenceDataSourceTypeDef,
    S3ReferenceDataSourceUpdateTypeDef,
    SnapshotDetailsTypeDef,
    SourceSchemaTypeDef,
    SqlApplicationConfigurationDescriptionTypeDef,
    SqlApplicationConfigurationTypeDef,
    SqlApplicationConfigurationUpdateTypeDef,
    SqlRunConfigurationTypeDef,
    TagTypeDef,
    VpcConfigurationDescriptionTypeDef,
    VpcConfigurationTypeDef,
    VpcConfigurationUpdateTypeDef,
    AddApplicationCloudWatchLoggingOptionResponseTypeDef,
    AddApplicationInputProcessingConfigurationResponseTypeDef,
    AddApplicationInputResponseTypeDef,
    AddApplicationOutputResponseTypeDef,
    AddApplicationReferenceDataSourceResponseTypeDef,
    AddApplicationVpcConfigurationResponseTypeDef,
    ApplicationConfigurationTypeDef,
    ApplicationConfigurationUpdateTypeDef,
    CloudWatchLoggingOptionTypeDef,
    CloudWatchLoggingOptionUpdateTypeDef,
    CreateApplicationPresignedUrlResponseTypeDef,
    CreateApplicationResponseTypeDef,
    DeleteApplicationCloudWatchLoggingOptionResponseTypeDef,
    DeleteApplicationInputProcessingConfigurationResponseTypeDef,
    DeleteApplicationOutputResponseTypeDef,
    DeleteApplicationReferenceDataSourceResponseTypeDef,
    DeleteApplicationVpcConfigurationResponseTypeDef,
    DescribeApplicationResponseTypeDef,
    DescribeApplicationSnapshotResponseTypeDef,
    DiscoverInputSchemaResponseTypeDef,
    ListApplicationSnapshotsResponseTypeDef,
    ListApplicationsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    RunConfigurationTypeDef,
    RunConfigurationUpdateTypeDef,
    S3ConfigurationTypeDef,
    UpdateApplicationResponseTypeDef,
)

def get_structure() -> ApplicationCodeConfigurationDescriptionTypeDef:
    return {
      ...
    }
```
