"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * In most cases, you will probably want to use
 * `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if this is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = props.restApi instanceof restapi_1.RestApi
            ? props.restApi.deploymentStage
            : undefined;
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,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