import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import { Construct, Resource } from '@aws-cdk/core';
/**
 * Properties for a VpcLink
 */
export interface VpcLinkProps {
    /**
     * The name used to label and identify the VPC link.
     * @default - automatically generated name
     */
    readonly vpcLinkName?: string;
    /**
     * The description of the VPC link.
     * @default no description
     */
    readonly description?: string;
    /**
     * The network load balancers of the VPC targeted by the VPC link.
     * The network load balancers must be owned by the same AWS account of the API owner.
     *
     * @default - no targets. Use `addTargets` to add targets
     */
    readonly targets?: elbv2.INetworkLoadBalancer[];
}
/**
 * Define a new VPC Link
 * Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 */
export declare class VpcLink extends Resource {
    /**
     * Physical ID of the VpcLink resource
     * @attribute
     */
    readonly vpcLinkId: string;
    private readonly targets;
    constructor(scope: Construct, id: string, props?: VpcLinkProps);
    addTargets(...targets: elbv2.INetworkLoadBalancer[]): void;
    protected validate(): string[];
    private renderTargets;
}
