"use strict";
// tslint:disable:no-console
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = async (event, _context = {}) => {
    const authToken = event.headers.Authorization;
    const authQueryString = event.queryStringParameters.allow;
    console.log(`event.headers.Authorization = ${authToken}`);
    console.log(`event.queryStringParameters.allow = ${authQueryString}`);
    if ((authToken === 'allow' || authToken === 'deny') && authQueryString === 'yes') {
        return {
            principalId: 'user',
            policyDocument: {
                Version: "2012-10-17",
                Statement: [
                    {
                        Action: "execute-api:Invoke",
                        Effect: authToken,
                        Resource: event.methodArn
                    }
                ]
            }
        };
    }
    else {
        throw new Error('Unauthorized');
    }
};
//# sourceMappingURL=data:application/json;base64,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