"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const path = require("path");
const lib_1 = require("../../lib");
const authorizers_1 = require("../../lib/authorizers");
const identity_source_1 = require("../../lib/authorizers/identity-source");
// Against the RestApi endpoint from the stack output, run
// `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>?allow=yes` should return 403
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>?allow=yes` should return 200
const app = new core_1.App();
const stack = new core_1.Stack(app, 'RequestAuthorizerInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_10_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.request-authorizer.handler'))
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
const authorizer = new authorizers_1.RequestAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
    identitySources: [identity_source_1.IdentitySource.header('Authorization'), identity_source_1.IdentitySource.queryString('allow')],
});
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' }
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' }
    ],
    authorizer
});
//# sourceMappingURL=data:application/json;base64,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