"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const apigw = require("../lib");
class BookStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const booksHandler = new apigw.LambdaIntegration(new lambda.Function(this, 'BooksHandler', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${echoHandlerCode}`)
        }));
        const bookHandler = new apigw.LambdaIntegration(new lambda.Function(this, 'BookHandler', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${echoHandlerCode}`)
        }));
        const hello = new apigw.LambdaIntegration(new lambda.Function(this, 'Hello', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${helloCode}`)
        }));
        const api = new apigw.RestApi(this, 'books-api');
        api.root.addMethod('ANY', hello);
        const books = api.root.addResource('books', {
            defaultIntegration: booksHandler,
            defaultMethodOptions: { authorizationType: apigw.AuthorizationType.IAM }
        });
        books.addMethod('GET');
        books.addMethod('POST');
        const book = books.addResource('{book_id}', {
            defaultIntegration: bookHandler
            // note that authorization type is inherited from /books
        });
        book.addMethod('GET');
        book.addMethod('DELETE');
    }
}
class BookApp extends cdk.App {
    constructor() {
        super();
        new BookStack(this, 'restapi-books-example');
    }
}
function echoHandlerCode(event, _, callback) {
    return callback(undefined, {
        isBase64Encoded: false,
        statusCode: 200,
        headers: { 'content-type': 'application/json' },
        body: JSON.stringify(event)
    });
}
function helloCode(_event, _context, callback) {
    return callback(undefined, {
        statusCode: 200,
        body: 'hello, world!'
    });
}
new BookApp().synth();
//# sourceMappingURL=data:application/json;base64,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