"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamKey = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("aws-cdk-lib");
const aws_ivs_1 = require("aws-cdk-lib/aws-ivs");
/**
  A new IVS Stream Key
*/
class StreamKey extends core.Resource {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_alpha_StreamKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StreamKey);
            }
            throw error;
        }
        const resource = new aws_ivs_1.CfnStreamKey(this, 'Resource', {
            channelArn: props.channel.channelArn,
        });
        this.streamKeyArn = resource.attrArn;
        this.streamKeyValue = resource.attrValue;
    }
}
exports.StreamKey = StreamKey;
_a = JSII_RTTI_SYMBOL_1;
StreamKey[_a] = { fqn: "@aws-cdk/aws-ivs-alpha.StreamKey", version: "2.49.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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