# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.


from datadog_api_client.model_utils import (
    ModelNormal,
    cached_property,
)


def lazy_import():
    from datadog_api_client.v2.model.dashboard_type import DashboardType

    globals()["DashboardType"] = DashboardType


class DashboardListItemRequest(ModelNormal):
    @cached_property
    def openapi_types(_):
        lazy_import()
        return {
            "id": (str,),
            "type": (DashboardType,),
        }

    attribute_map = {
        "id": "id",
        "type": "type",
    }

    def __init__(self, id, type, *args, **kwargs):
        """
        A dashboard within a list.

        :param id: ID of the dashboard.
        :type id: str

        :param type: The type of the dashboard.
        :type type: DashboardType
        """
        super().__init__(kwargs)

        self._check_pos_args(args)

        self.id = id
        self.type = type

    @classmethod
    def _from_openapi_data(cls, id, type, *args, **kwargs):
        """Helper creating a new instance from a response."""

        self = super(DashboardListItemRequest, cls)._from_openapi_data(kwargs)

        self._check_pos_args(args)

        self.id = id
        self.type = type
        return self
