import * as ec2 from '@aws-cdk/aws-ec2';
import * as awsLambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as awssecret from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface FlywayConstructParams {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly subnet: ec2.SubnetSelection;
    /**
     * @stability stable
     */
    readonly securityGroups: [ec2.ISecurityGroup];
    /**
     * @stability stable
     */
    readonly migrationBucketSecretManager: awssecret.ISecret;
    /**
     * @stability stable
     */
    readonly bucket: s3.IBucket;
    /**
     * @stability stable
     */
    readonly memorySize?: number;
    /**
     * @stability stable
     */
    readonly timeout?: cdk.Duration;
}
/**
 * @stability stable
 */
export declare class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    static readonly HANDLER = "be.tech.necko.flywayjar.Main::handleRequest";
    /**
     * @stability stable
     */
    static readonly ID_LAMBDA_CODE = "bucketMigration";
    /**
     * @stability stable
     */
    static readonly BUCKET_CODE_ARN = "arn:aws:s3:::flywaymigrationconstruct";
    /**
     * @stability stable
     */
    static readonly OBJECT_CODE_KEY = "flywayjar.0.1.0.zip";
    /**
     * @stability stable
     */
    flywayLambdaMigration: awsLambda.Function;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, params: FlywayConstructParams);
}
