"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                ARN: params.migrationBucketSecretManager.secretArn,
                BUCKET_NAME: params.bucket.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), FlywayConstruct.OBJECT_CODE_KEY),
        });
        params.migrationBucketSecretManager.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.1.13" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'be.tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct';
/**
 * @stability stable
 */
FlywayConstruct.OBJECT_CODE_KEY = 'flywayjar.0.1.0.zip';
//# sourceMappingURL=data:application/json;base64,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