"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../");
const core_1 = require("@aws-cdk/core");
const path = require("path");
require("@aws-cdk/assert/jest");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
test('create the ServerlessAPI', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    new __1.ServerlessApi(stack, 'testing', {
        brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
        lambdaCodePath: path.join(__dirname, '../../codebase'),
    });
    expect(stack).toHaveResource('AWS::ApiGatewayV2::Api');
    expect(stack).toHaveResource('AWS::Lambda::Function');
});
test('create rdsProxy if props.rdsProxy is undefined', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const vpc = new aws_ec2_1.Vpc(stack, 'Vpc');
    new __1.DatabaseCluster(stack, 'DBCluster', {
        vpc,
    });
    expect(stack).toHaveResource('AWS::RDS::DBProxy');
});
test('create rdsProxy if props.rdsProxy is true', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const vpc = new aws_ec2_1.Vpc(stack, 'Vpc');
    new __1.DatabaseCluster(stack, 'DBCluster', {
        vpc,
        rdsProxy: true,
    });
    expect(stack).toHaveResource('AWS::RDS::DBProxy');
});
test('do not create rdsProxy if props.rdsProxy is false', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const vpc = new aws_ec2_1.Vpc(stack, 'Vpc');
    new __1.DatabaseCluster(stack, 'DBCluster', {
        vpc,
        rdsProxy: false,
    });
    expect(stack).not.toHaveResource('AWS::RDS::DBProxy');
});
//# sourceMappingURL=data:application/json;base64,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