"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../");
const core_1 = require("@aws-cdk/core");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const path = require("path");
const app = new core_1.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new core_1.Stack(app, 'testing-stack', { env });
const vpc = aws_ec2_1.Vpc.fromLookup(stack, 'Vpc', { isDefault: true });
// the DatabaseCluster sharing the same vpc with the ServerlessLaravel
const db = new __1.DatabaseCluster(stack, 'DatabaseCluster', {
    vpc,
    instanceType: new aws_ec2_1.InstanceType('t3.small'),
    rdsProxy: true,
    instanceCapacity: 1,
});
// the ServerlessLaravel
new __1.ServerlessLaravel(stack, 'ServerlessLaravel', {
    brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
    laravelPath: path.join(__dirname, '../../codebase'),
    vpc,
    databaseConfig: {
        writerEndpoint: db.rdsProxy.endpoint,
    },
});
new core_1.CfnOutput(stack, 'RDSProxyEndpoint', { value: db.rdsProxy.endpoint });
new core_1.CfnOutput(stack, 'DBMasterUser', { value: db.masterUser });
new core_1.CfnOutput(stack, 'DBMasterPasswordSecret', { value: db.masterPassword.secretArn });
//# sourceMappingURL=data:application/json;base64,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