"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 *
 * @stability stable
 */
class BasePathMapping extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-zA-Z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_a = props.stage) !== null && _a !== void 0 ? _a : (props.restApi instanceof restapi_1.RestApiBase
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,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