# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['eksupgrade', 'eksupgrade.src']

package_data = \
{'': ['*'], 'eksupgrade.src': ['S3Files/*']}

install_requires = \
['boto3>=1.26.60,<2.0.0', 'kubernetes>=21.0.0,<25.0.0']

entry_points = \
{'console_scripts': ['eksupgrade = eksupgrade.cli:entry']}

setup_kwargs = {
    'name': 'eksupgrade',
    'version': '0.2.0',
    'description': 'The Amazon EKS cluster upgrade utility',
    'long_description': '# Amazon EKS Upgrade Utility\n\n<p align="center">\n<a href="">\n    <img src="https://forthebadge.com/images/badges/open-source.svg" alt="Opensource eks" style="vertical-align:top; margin:4px">\n  </a>  \n  <a href="">\n    <img src="https://ForTheBadge.com/images/badges/built-with-love.svg" alt="Eks one click" style="vertical-align:top; margin:4px">\n  </a>  \n<a href="">\n    <img src="https://ForTheBadge.com/images/badges/made-with-python.svg" alt="kubernetes python" style="vertical-align:top; margin:4px">\n  </a>  \n</p>\n\nAmazon Elastic Kubernetes Service (Amazon EKS) is a managed service that you can use to run Kubernetes on AWS without needing to install, operate, and maintain your own Kubernetes control plane or nodes. Kubernetes is an open-source system for automating the deployment, scaling, and management of containerized applications.\nWorking with EKS starts with creating a cluster and an Amazon EKS cluster consists of two primary components:\n\n1. Amazon EKS control plane\n2. Amazon EKS nodes that are registered with the control plane\n\nThe current process of EKS cluster upgrade includes:\n\n1. Check the Kubernetes object compatibility with regards to API specific Changes\n2. Check the version of Core Kubernetes Components and do changes as per the changes required in the newer\n   version which is compatible with the targeted version.\n3. Check worker node version and control plane version and ensure that they are in same version\n4. Check Enough IPs are there in the Subnet and the Customer account has not reached the ENI limit\n5. Do Control Plane Upgrade\n6. Do Node Upgrade and graceful shift of workloads to newer instances\n7. Check for stability of Core Kubernetes Components after Cluster Upgrade.\n\n## Workflow\n\nThe process of EKS Cluster upgradation is divided majorly into three steps carrying out the task of doing preflight check, cluster upgradation and post upgradation check for verifying if the different components have upgraded successfully.\n\n## Preflight Check\n\nTo upgrade the cluster successfully without any roll backs there are multiple parameters, versions associated with the cluster which have to be checked beforehand in order to initate its process. To verify all such variable parameters and check version compatibility, pre-flight check for the following components is carried out before initiating a cluster upgrade.\n\n1. Target Version Compatibility Check - Since any cluster in eks is always allowed to upgrade to one above version and not beyond a check for the target version is done as with each upgrade there are a lot of configuration changes and upgrading directly to a higher version can lead to breakdown of the services being provided by it.\n2. Customer Management Key - A cluster might have CMK Key associated with it and so it is essential to verify if the same exists in users account to carry out the upgradation process\n3. Security Group - Every cluster has a security group associated with it to restrict and allow the flow of traffic across it and therefore it has to be verified whether it exists in the users VPC or not.\n4. Nodegroup and worker node detail - EKS cluster supports multiple types of node groups and so for the purpose of upgradation and there kubelet version compatibility check they have to classify to proceed with the upgrade step.\n5. Subnets - A minimum of 4-5 free IP are required when doing a cluster upgrade to launch new nodes and nodegroup with the old ones to keep the services of the cluster running while the upgrade is going on and so a check for them\nTarget version compatibly check\n6. Cluster Roles - There are a lot of important cluster roles required during the upgradation related to addons, nodes and other components of cluster without which cluster upgrade can’t be executed successfully.\n7. Pod Security Policy - Eks privileged role has to be checked to be present with the current pod security policy.\n8. cluster addons - The cluster addons like kube-proxy, vpc-cni and cordns are essential for running various services across the cluster and sometimes there are certain variable parameters present by them which have been customized by the users end as per the functionality the cluster supports which have to captured while upgradation and then added during the upgrade for the services to continue working smoothly as before.\n9. Pod Disruption Budget - The existence of PDB has to be checked in the cluster and minimum and maximum available with it has to be taken into account while upgrading.\n10. Horizontal Pod and Cluster Autoscaler - As the other components are upgraded to the compatible image version, a check firstly to check of these are present and then to upgrade them to compatible version with respect to the control plane. Deprecated API check - With every new version release there are a certain set of API which get deprecated and so a check for the resources running over them has to be done so that they do not break post upgrade\n\nAfter the pre-flight check is completed for the cluster an email is generated summarizing the details for all the above steps for the user and the status of preflight. If preflight completes successfully the upgrade process is initiated or else the process of upgradation is terminated after pre-flight.\n\n### Upgrade Flow\n\n1. Control plane upgrade - Upgrades control plane components i.e API server ,etcd ,kube-scheduler,kubelet etc to target version.\n2. Identification of Managed and Self managed node - The worker nodes are identified as EKS managed and self managed to perform upgrade.\n3. Managed Node group update - updates managed node group to the specified version\n4. Self Managed Nodegroup update\n   - Launch new nodes with upgraded version and wait until they require ready status for next step.\n   - Mark existing nodes as un-schedulable.\n   - If pod disruption budget (PDB) is present then check for force eviction flag (--force) which is given by user, only then evit the pods or continue with the        flow.\n\n### Objective\n\n1. **To upgrade the cluster in one click** : There are many steps involved in updating a cluster and our main objective is to automate all the steps involved in EKS Cluster Upgradation to one click.\n2. **To reduce manual effort and time** : To update an EKS cluster , customers have to manually perform every step which is quite time taking and also a hectic task so, our objective is to reduce that manual intervention and also to save customer’s time.\n\n### Architecture\n\nThis is the architecture of EKS One Click Upgrade:\n<p align="center">\n<img src="./Images/architecture.png" height="600px"/>\n</p>\n\n### Components used\n\n![Technologies Used ](./Images/technologies-used.png)\n\n### Workflow\n\nOnce the user executes the python script, a pre-flight check is initiated where multiple parameters and versions associated with the cluster are verified. If this check is performed successfully, then the upgrade workflow will be initiated and the cluster along with its components will be upgraded to the target version. After the upgradation process, a final check is done and an email is generated summarizing the details of cluster.\n\n<p align="center">\n<img src="./Images/workflow.png"/>\n</p>\n\n### How to use EKS One Click Upgrade via CLI\n\n```zsh\n\n$ aws eks update-kubeconfig --name eks-cluster-name --region aws-region \n$ kubectl edit configmap aws-auth -n kube-system\n\n# Add the IAM user to mapUsers. For example:\nmapUsers: |\n  - userarn: arn:aws:iam::XXXXXXXXXXXX:user/testuser\nusername: testuser\n    groups:\n      - system:masters\nAdd the IAM role to mapRoles. For example:\nmapRoles: |\n  - rolearn: arn:aws:iam::XXXXXXXXXXXX:role/testrole\n    username: testrole\n    groups:\n      - system:masters\n```\n\n### Roles and Policies required\n\nIn order to proceed with the upgrade and preflight workflow for your EKS cluster, below mentioned permissions are required as part of the IAM user being used to complete with the process. Below mentioned IAM policy can be used to attach to a user in order to grant access to required AWS service and related actions to complete the processs for eks-one-click upgrade\n\nFor more information related to steps on how to create and attach IAM policy, you can follow the below mentioned steps in AWS Documentation\n\n[https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-and-attach-iam-policy.html](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-and-attach-iam-policy.html)\n\n```json\n{\n    "Version": "2012-10-17",\n    "Statement": [\n        {\n            "Sid": "eksoneclickrole",\n            "Effect": "Allow",\n            "Action": [\n                "autoscaling:DescribeAutoScalingInstances",\n                "eks:UpdateClusterVersion",\n                "ec2:DescribeInstances",\n                "eks:DescribeFargateProfile",\n                "ses:VerifyEmailIdentity",\n                "logs:DescribeLogStreams",\n                "ses:GetSendQuota",\n                "autoscaling:DescribeLaunchConfigurations",\n                "eks:UpdateAddon",\n                "eks:ListAddons",\n                "sts:GetAccessKeyInfo",\n                "autoscaling:CreateLaunchConfiguration",\n                "ssm:*",\n                "ses:VerifyDomainIdentity",\n                "eks:DescribeAddon",\n                "sts:GetSessionToken",\n                "eks:UpdateNodegroupVersion",\n                "logs:CreateLogStream",\n                "eks:DescribeNodegroup",\n                "autoscaling:DescribeAutoScalingGroups",\n                "eks:ListUpdates",\n                "autoscaling:UpdateAutoScalingGroup",\n                "eks:DescribeAddonVersions",\n                "ses:ListIdentities",\n                "autoscaling:TerminateInstanceInAutoScalingGroup",\n                "iam:GetRole",\n                "eks:ListNodegroups",\n                "logs:DescribeLogGroups",\n                "ec2:DescribeLaunchTemplates",\n                "autoscaling:SetDesiredCapacity",\n                "ses:SendRawEmail",\n                "ses:GetIdentityVerificationAttributes",\n                "logs:CreateLogGroup",\n                "logs:PutLogEvents",\n                "config:DescribeConfigurationRecorderStatus",\n                "ec2:DescribeSecurityGroups",\n                "ec2:DescribeImages",\n                "eks:ListFargateProfiles",\n                "config:DescribeConfigurationRecorders",\n                "eks:DescribeUpdate",\n                "ses:DeleteIdentity",\n                "eks:DescribeCluster",\n                "sts:GetCallerIdentity",\n                "eks:ListClusters",\n                "ec2:DescribeSubnets"\n            ],\n            "Resource": "*"\n        }\n    ]\n}\n```\n\n### Folder Structure\n\n```bash\neks-upgrade/\n├── src/\n│   ├── S3Files/\n│   ├── __init__.py\n│   ├── boto_aws.py\n│   ├── eks_get_image_type.py\n│   ├── eksctlfinal.py\n│   ├── ekslogs.py\n│   ├── k8s_client.py\n│   ├── latest_ami.py\n│   ├── preflight_module.py\n│   └── self_managed.py\n├── __init__.py\n├── cli.py\n└── starter.py\n```\n\n## Installation\n\n```zsh\npip install eksupgrade\n```\n\n## Usage\n\n```zsh\n\nTo Get Help Use [-h] \n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade -h \n\n    usage: eksupgrade [-h] [--pass_vpc] [--max_retry MAX_RETRY] [--force]\n                     [--eksctl] [--preflight] [--email EMAIL]\n                     name version region\n\nTo Receive Email Report Use [ --email]\n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade Cluster_Name new_Version aws_Region --email okaboi@example.com\n\nTo Skip The upgrade and if you only want to perform preflight check [ --preflight ]\n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade Cluster_Name new_Version aws_Region --email okaboi@example.com --preflight\n\nTo Skip Vpc-cni Addon Upgrade use [ --pass_vpc ]\n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade Cluster_Name new_Version aws_Region --pass_vpc\n\nAdd Number of retry you want the script to peform by default it is 2 [ --max_retry ]\n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade Cluster_Name new_Version aws_Region --max_retry 5\n\nTo Utilize Force Pod Eviction when you Have Pdb (Pod disruption budget) [ --force]\n\nUsage :\n\n    eks-one-click-upgrade % eksupgrade Cluster_Name new_Version aws_Region --pass_vpc\n\n```\n\n## Command Line Interface (CLI)\n\n<p align="center">\n<img src="./Images/CLI-1.png" height="800px"/>\n<img src="./Images/CLI-2.png" height="600px"/>\n</p>\n\n## Security\n\nSee [CONTRIBUTING](CONTRIBUTING.md#security-issue-notifications) for more information.\n\n## License\n\nThis library is licensed under the MIT-0 License. See the [LICENSE](LICENSE) file.\n\n### 🤝 Contributing\n\n- Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.\n- Please make sure to update tests as appropriate.\n',
    'author': 'EKS Upgrade Maintainers',
    'author_email': 'eks-upgrade-maintainers@amazon.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
