<a id="mypy-boto3-mgn"></a>

# mypy-boto3-mgn

[![PyPI - mypy-boto3-mgn](https://img.shields.io/pypi/v/mypy-boto3-mgn.svg?color=blue)](https://pypi.org/project/mypy-boto3-mgn)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mgn.svg?color=blue)](https://pypi.org/project/mypy-boto3-mgn)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-mgn?color=blue)](https://pypistats.org/packages/mypy-boto3-mgn)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.mgn 1.20.49](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/mgn.html#mgn)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.4.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-mgn docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mgn/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-mgn](#mypy-boto3-mgn)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `mgn`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `mgn` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[mgn]'

# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[mgn]'

# standalone installation
python -m pip install mypy-boto3-mgn
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[mgn]` in your environment:
  `python -m pip install 'boto3-stubs[mgn]'`

Both type checking and auto-complete should work for `mgn` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto3-stubs[mgn]` in your environment:
  `python -m pip install 'boto3-stubs[mgn]'`

Both type checking and auto-complete should work for `mgn` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[mgn]` in your environment:
  `python -m pip install 'boto3-stubs[mgn]'`
- Run `mypy` as usual

Type checking should work for `mgn` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto3-stubs[mgn]` in your environment:
  `python -m pip install 'boto3-stubs[mgn]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `mgn` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`mgnClient` provides annotations for `boto3.client("mgn")`.

```python
from boto3.session import Session

from mypy_boto3_mgn import mgnClient

client: mgnClient = Session().client("mgn")

# now client usage is checked by mypy and IDE should provide code auto-complete
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_mgn.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_mgn import mgnClient
from mypy_boto3_mgn.paginator import (
    DescribeJobLogItemsPaginator,
    DescribeJobsPaginator,
    DescribeReplicationConfigurationTemplatesPaginator,
    DescribeSourceServersPaginator,
    DescribeVcenterClientsPaginator,
)

client: mgnClient = Session().client("mgn")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_job_log_items_paginator: DescribeJobLogItemsPaginator = client.get_paginator("describe_job_log_items")
describe_jobs_paginator: DescribeJobsPaginator = client.get_paginator("describe_jobs")
describe_replication_configuration_templates_paginator: DescribeReplicationConfigurationTemplatesPaginator = client.get_paginator("describe_replication_configuration_templates")
describe_source_servers_paginator: DescribeSourceServersPaginator = client.get_paginator("describe_source_servers")
describe_vcenter_clients_paginator: DescribeVcenterClientsPaginator = client.get_paginator("describe_vcenter_clients")
```

<a id="literals"></a>

### Literals

`mypy_boto3_mgn.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_mgn.literals import (
    ChangeServerLifeCycleStateSourceServerLifecycleStateType,
    DataReplicationErrorStringType,
    DataReplicationInitiationStepNameType,
    DataReplicationInitiationStepStatusType,
    DataReplicationStateType,
    DescribeJobLogItemsPaginatorName,
    DescribeJobsPaginatorName,
    DescribeReplicationConfigurationTemplatesPaginatorName,
    DescribeSourceServersPaginatorName,
    DescribeVcenterClientsPaginatorName,
    FirstBootType,
    InitiatedByType,
    JobLogEventType,
    JobStatusType,
    JobTypeType,
    LaunchDispositionType,
    LaunchStatusType,
    LifeCycleStateType,
    ReplicationConfigurationDataPlaneRoutingType,
    ReplicationConfigurationDefaultLargeStagingDiskTypeType,
    ReplicationConfigurationEbsEncryptionType,
    ReplicationConfigurationReplicatedDiskStagingDiskTypeType,
    ReplicationTypeType,
    TargetInstanceTypeRightSizingMethodType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ChangeServerLifeCycleStateSourceServerLifecycleStateType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_mgn.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_mgn.type_defs import (
    CPUTypeDef,
    ChangeServerLifeCycleStateRequestRequestTypeDef,
    ChangeServerLifeCycleStateSourceServerLifecycleTypeDef,
    CreateReplicationConfigurationTemplateRequestRequestTypeDef,
    DataReplicationErrorTypeDef,
    DataReplicationInfoReplicatedDiskTypeDef,
    DataReplicationInfoTypeDef,
    DataReplicationInitiationStepTypeDef,
    DataReplicationInitiationTypeDef,
    DeleteJobRequestRequestTypeDef,
    DeleteReplicationConfigurationTemplateRequestRequestTypeDef,
    DeleteSourceServerRequestRequestTypeDef,
    DeleteVcenterClientRequestRequestTypeDef,
    DescribeJobLogItemsRequestRequestTypeDef,
    DescribeJobLogItemsResponseTypeDef,
    DescribeJobsRequestFiltersTypeDef,
    DescribeJobsRequestRequestTypeDef,
    DescribeJobsResponseTypeDef,
    DescribeReplicationConfigurationTemplatesRequestRequestTypeDef,
    DescribeReplicationConfigurationTemplatesResponseTypeDef,
    DescribeSourceServersRequestFiltersTypeDef,
    DescribeSourceServersRequestRequestTypeDef,
    DescribeSourceServersResponseTypeDef,
    DescribeVcenterClientsRequestRequestTypeDef,
    DescribeVcenterClientsResponseTypeDef,
    DisconnectFromServiceRequestRequestTypeDef,
    DiskTypeDef,
    FinalizeCutoverRequestRequestTypeDef,
    GetLaunchConfigurationRequestRequestTypeDef,
    GetReplicationConfigurationRequestRequestTypeDef,
    IdentificationHintsTypeDef,
    JobLogEventDataTypeDef,
    JobLogTypeDef,
    JobTypeDef,
    LaunchConfigurationTypeDef,
    LaunchedInstanceTypeDef,
    LicensingTypeDef,
    LifeCycleLastCutoverFinalizedTypeDef,
    LifeCycleLastCutoverInitiatedTypeDef,
    LifeCycleLastCutoverRevertedTypeDef,
    LifeCycleLastCutoverTypeDef,
    LifeCycleLastTestFinalizedTypeDef,
    LifeCycleLastTestInitiatedTypeDef,
    LifeCycleLastTestRevertedTypeDef,
    LifeCycleLastTestTypeDef,
    LifeCycleTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MarkAsArchivedRequestRequestTypeDef,
    NetworkInterfaceTypeDef,
    OSTypeDef,
    PaginatorConfigTypeDef,
    ParticipatingServerTypeDef,
    ReplicationConfigurationReplicatedDiskTypeDef,
    ReplicationConfigurationTemplateResponseMetadataTypeDef,
    ReplicationConfigurationTemplateTypeDef,
    ReplicationConfigurationTypeDef,
    ResponseMetadataTypeDef,
    RetryDataReplicationRequestRequestTypeDef,
    SourcePropertiesTypeDef,
    SourceServerResponseMetadataTypeDef,
    SourceServerTypeDef,
    StartCutoverRequestRequestTypeDef,
    StartCutoverResponseTypeDef,
    StartReplicationRequestRequestTypeDef,
    StartTestRequestRequestTypeDef,
    StartTestResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TerminateTargetInstancesRequestRequestTypeDef,
    TerminateTargetInstancesResponseTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateLaunchConfigurationRequestRequestTypeDef,
    UpdateReplicationConfigurationRequestRequestTypeDef,
    UpdateReplicationConfigurationTemplateRequestRequestTypeDef,
    UpdateSourceServerReplicationTypeRequestRequestTypeDef,
    VcenterClientTypeDef,
)

def get_structure() -> CPUTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-mgn` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-mgn docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mgn/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
