# Generated by Django 2.2.4 on 2019-08-19 10:15

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.code_field
import isc_common.fields.description_field
import isc_common.fields.name_field
import isc_common.fields.related


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Chats',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('code', isc_common.fields.code_field.CodeField(blank=True, null=True)),
                ('name', isc_common.fields.name_field.NameField(blank=True, null=True)),
                ('description', isc_common.fields.description_field.DescriptionField()),
            ],
            options={
                'verbose_name': 'Чаты',
            },
        ),
        migrations.CreateModel(
            name='Chat_users',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('chat', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='twits.Chats')),
                ('user', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Участники чатов',
            },
        ),
        migrations.CreateModel(
            name='Chat_user_permission',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('user_reciver', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, related_name='user_reciver_user', to=settings.AUTH_USER_MODEL)),
                ('user_sender', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, related_name='user_sender_user', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Доступ к общению с пользователями',
                'unique_together': {('user_sender', 'user_reciver')},
            },
        ),
        migrations.CreateModel(
            name='Chat_permission',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('id_old', models.BigIntegerField(blank=True, null=True, verbose_name='Идентификатор старый')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('chat', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='twits.Chats')),
                ('user', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Доступ к группам',
                'unique_together': {('user', 'chat')},
            },
        ),
    ]
