from .base_model import *


class HltTap(BaseModel):
    """
    Талон амбулаторного пациента
    """

    id = models.AutoField(db_column="TAPID", primary_key=True)
    uuid = models.CharField(db_column="UGUID", max_length=36, unique=True, default=uuid4)
    mkab = models.ForeignKey("HltMkab", models.DO_NOTHING, db_column="rf_MKABID", related_name="taps")
    katl = models.IntegerField(db_column="rf_KATLID", default=0)
    mkb = models.ForeignKey("OmsMkb", db_column="rf_MKBID", **FK_DEFAULT)
    mkb2 = models.ForeignKey("OmsMkb", db_column="rf_MKB2ID", **FK_DEFAULT)
    reason_care = models.ForeignKey("HltReasonCare", db_column="rf_ReasonCareID", **FK_DEFAULT)
    care_person_sex = models.BooleanField(db_column="CarePersonSex", default=0)
    care_person_age = models.IntegerField(db_column="CarePersonAge", default=0)
    date_tap = models.DateTimeField(db_column="DateTAP", default=timezone.now)
    inv = models.IntegerField(db_column="rf_INVID", default=0)
    not_work_doc_status = models.IntegerField(db_column="rf_NotWorkDocStatusID", default=0)
    date_close = models.DateTimeField(db_column="DateClose", default=timezone.now)
    lpu_doctor = models.ForeignKey("HltLpuDoctor", db_column="rf_LPUDoctorID", **FK_DEFAULT)
    lpu_doctor_s = models.ForeignKey("HltLpuDoctor", db_column="rf_LPUDoctor_SID", **FK_DEFAULT)
    smo = models.ForeignKey("OmsSmo", db_column="rf_SMOID", **FK_DEFAULT)
    other_smo = models.ForeignKey("OmsSmo", db_column="rf_OtherSMOID", **FK_DEFAULT)
    s_pol = models.CharField(db_column="S_POL", max_length=50, default="")
    n_pol = models.CharField(db_column="N_POL", max_length=50, default="")
    is_closed = models.BooleanField(db_column="IsClosed", default=0)
    is_worker = models.BooleanField(db_column="isWorker", default=0)
    spec_event_cert_id = models.IntegerField(db_column="rf_SpecEventCertID", default=0)
    care_begin = models.DateTimeField(db_column="CareBegin", default=timezone.now)
    care_end = models.DateTimeField(db_column="CareEnd", default=timezone.now)
    family = models.CharField(db_column="FAMILY", max_length=40, default="")
    mkab_sheet_final_ds = models.IntegerField(db_column="rf_MKABSheetFinalDSID", default=0)
    direction_id = models.IntegerField(db_column="rf_DirectionID", default=0)
    outcome_visit_id = models.IntegerField(db_column="rf_OutcomeVisitID", default=0)
    description = models.CharField(db_column="Description", max_length=1000, default="")
    profit_type = models.ForeignKey("OmsKlProfitType", db_column="rf_kl_ProfitTypeID", **FK_DEFAULT)
    disp_reg_state_id = models.IntegerField(db_column="rf_kl_DispRegStateID", default=0)
    disp_reg_state2_id = models.IntegerField(db_column="rf_kl_DispRegState2ID", default=0)
    disease_type = models.ForeignKey("OmsKlDiseaseType", db_column="rf_kl_DiseaseTypeID", **FK_DEFAULT)
    disease_type2 = models.ForeignKey("OmsKlDiseaseType", db_column="rf_kl_DiseaseType2ID", **FK_DEFAULT)
    trauma_type_id = models.IntegerField(db_column="rf_kl_TraumaTypeID", default=0)
    sick_list_reason = models.IntegerField(db_column="rf_kl_SickListReasonID", default=0)
    visit_result = models.ForeignKey("OmsKlVisitResult", db_column="rf_kl_VisitResultID", **FK_DEFAULT)
    registration_end_reason_id = models.IntegerField(db_column="rf_kl_RegistrationEndReasonID", default=0)
    registration_end_reason2_id = models.IntegerField(db_column="rf_kl_RegistrationEndReason2ID", default=0)
    health_group = models.ForeignKey("OmsKlHealthGroup", db_column="rf_kl_HealthGroupID", **FK_DEFAULT)
    visit_place = models.ForeignKey("OmsKlVisitPlace", db_column="rf_kl_VisitPlaceID", **FK_DEFAULT)
    reason_type = models.ForeignKey("OmsKlReasonType", db_column="rf_kl_ReasonTypeID", **FK_DEFAULT)
    department = models.ForeignKey("OmsDepartment", db_column="rf_DepartmentID", **FK_DEFAULT)
    soc_status = models.ForeignKey("OmsKlSocStatus", db_column="rf_kl_SocStatusID", **FK_DEFAULT)
    create_username = models.CharField(db_column="CreateUserName", max_length=255, default="не определено")
    edit_username = models.CharField(db_column="EditUserName", max_length=255, default="не определено")
    flag_bill = models.BooleanField(db_column="FlagBill", default=0)
    flag_statist = models.BooleanField(db_column="FlagStatist", default=0)
    create_user = models.ForeignKey("XUser", db_column="rf_CreateUserID", **FK_DEFAULT)
    edit_user = models.ForeignKey("XUser", db_column="rf_EditUserID", **FK_DEFAULT)
    stat_cure_result = models.ForeignKey("OmsKlStatCureResult", db_column="rf_kl_StatCureResultID", **FK_DEFAULT)
    polis_mkab_id = models.IntegerField(db_column="rf_PolisMKABID", default=0)
    type_tap_id = models.IntegerField(db_column="rf_TypeTAPID", default=0)
    registr_patient_id = models.IntegerField(db_column="rf_RegistrPatientID", default=0)
    doc_prvd = models.ForeignKey("HltDocPrvd", db_column="rf_DocPRVDID", **FK_DEFAULT)
    mkp_card = models.UUIDField(db_column="rf_mkp_CardGUID", default=UUID('00000000-0000-0000-0000-000000000000'))
    date_create_tap = models.DateTimeField(db_column="DateCreateTAP", default=timezone.now)
    num_in_other_system = models.CharField(db_column="NumInOtherSystem", max_length=50, default="")
    is_dvn_closed = models.BooleanField(db_column="isDVNClosed", default=0)
    med_care_type = models.ForeignKey("OmsKlMedCareType", db_column="rf_kl_MedCareTypeID", **FK_DEFAULT)
    disability_status = models.IntegerField(db_column="DisabilityStatus", default=0)
    reason_inv_id = models.IntegerField(db_column="rf_kl_ReasonInvID", default=0)
    mkb_external = models.ForeignKey("OmsMkb", db_column="rf_MKBExternalID", **FK_DEFAULT)
    sanitation_id = models.IntegerField(db_column="rf_kl_SanitationID", default=0)
    patient_status_id = models.IntegerField(db_column="rf_kl_PatientStatusID", default=0)
    onco_sign_id = models.IntegerField(db_column="rf_onco_SignID", default=0)
    dd_service = models.ForeignKey("OmsKlDDService", db_column="rf_kl_DDServiceID", **FK_DEFAULT)
    tip_oms = models.ForeignKey("OmsKlTipOms", db_column="rf_kl_TipOMSID", **FK_DEFAULT)
    num = models.IntegerField(db_column="Num", default=0)

    flags = models.IntegerField(db_column="Flags")

    class Meta:
        managed = False
        db_table = "hlt_TAP"
